/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

class MultiValueBoundaryScanner
extends ValueBoundaryScanner {
    OrderDef orderDef;

    public MultiValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderDef orderDef, boolean nullsLast) {
        super(start, end, nullsLast);
        this.orderDef = orderDef;
    }

    @Override
    public int computeStart(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.start.getDirection()) {
            case PRECEDING: {
                return this.computeStartPreceding(rowIdx, p);
            }
            case CURRENT: {
                return this.computeStartCurrentRow(rowIdx, p);
            }
        }
        throw new HiveException("FOLLOWING not allowed for starting RANGE with multiple expressions in ORDER BY");
    }

    protected int computeStartPreceding(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.start.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return 0;
        }
        throw new HiveException("PRECEDING needs UNBOUNDED for RANGE with multiple expressions in ORDER BY");
    }

    protected int computeStartCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        Object rowVal = sortKey = this.computeValueUseCache(rowIdx, p);
        int r = rowIdx;
        while (r >= 0 && this.isEqual(rowVal, sortKey)) {
            Pair<Integer, Object> stepResult = this.skipOrStepBack(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r + 1;
    }

    @Override
    public int computeEnd(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.end.getDirection()) {
            case PRECEDING: {
                throw new HiveException("PRECEDING not allowed for finishing RANGE with multiple expressions in ORDER BY");
            }
            case CURRENT: {
                return this.computeEndCurrentRow(rowIdx, p);
            }
        }
        return this.computeEndFollowing(rowIdx, p);
    }

    protected int computeEndCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        Object rowVal = sortKey = this.computeValueUseCache(rowIdx, p);
        int r = rowIdx;
        while (r < p.size() && this.isEqual(sortKey, rowVal)) {
            Pair<Integer, Object> stepResult = this.skipOrStepForward(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r;
    }

    protected int computeEndFollowing(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.end.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return p.size();
        }
        throw new HiveException("FOLLOWING needs UNBOUNDED for RANGE with multiple expressions in ORDER BY");
    }

    @Override
    public Object computeValue(Object row) throws HiveException {
        Object[] objs = new Object[this.orderDef.getExpressions().size()];
        for (int i = 0; i < objs.length; ++i) {
            Object o = ((OrderExpressionDef)this.orderDef.getExpressions().get(i)).getExprEvaluator().evaluate(row);
            objs[i] = ObjectInspectorUtils.copyToStandardObject(o, ((OrderExpressionDef)this.orderDef.getExpressions().get(i)).getOI());
        }
        return objs;
    }

    @Override
    public boolean isEqual(Object val1, Object val2) {
        if (val1 == null || val2 == null) {
            return val1 == null && val2 == null;
        }
        Object[] v1 = (Object[])val1;
        Object[] v2 = (Object[])val2;
        assert (v1.length == v2.length);
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] == null && v2[i] == null) continue;
            if (v1[i] == null || v2[i] == null) {
                return false;
            }
            if (ObjectInspectorUtils.compare(v1[i], ((OrderExpressionDef)this.orderDef.getExpressions().get(i)).getOI(), v2[i], ((OrderExpressionDef)this.orderDef.getExpressions().get(i)).getOI()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        throw new UnsupportedOperationException("Only unbounded ranges supported");
    }
}

