/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;

@Description(name="months_between", value="_FUNC_(date1, date2, roundOff) - returns number of months between dates date1 and date2", extended="If date1 is later than date2, then the result is positive. If date1 is earlier than date2, then the result is negative. If date1 and date2 are either the same days of the month or both last days of months, then the result is always an integer. Otherwise the UDF calculates the fractional portion of the result based on a 31-day month and considers the difference in time components date1 and date2.\ndate1 and date2 type can be date, timestamp or string in the format 'yyyy-MM-dd' or 'yyyy-MM-dd HH:mm:ss'. The result is rounded to 8 decimal places by default. Set roundOff=false otherwise.\n Example:\n  > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n 3.94959677")
public class GenericUDFMonthsBetween
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private transient ObjectInspectorConverters.Converter[] dtConverters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] dtInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Calendar cal1 = DateTimeMath.getProlepticGregorianCalendarUTC();
    private final Calendar cal2 = DateTimeMath.getProlepticGregorianCalendarUTC();
    private final DoubleWritable output = new DoubleWritable();
    private boolean isRoundOffNeeded = true;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 3);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        if (arguments.length == 3 && arguments[2] instanceof ConstantObjectInspector) {
            this.isRoundOffNeeded = this.getConstantBooleanValue(arguments, 2);
        }
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 1, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 0, this.dtInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 1, this.dtInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConverters);
        this.obtainTimestampConverter(arguments, 1, this.tsInputTypes, this.tsConverters);
        this.obtainDateConverter(arguments, 0, this.dtInputTypes, this.dtConverters);
        this.obtainDateConverter(arguments, 1, this.dtInputTypes, this.dtConverters);
        WritableDoubleObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Timestamp date2;
        Timestamp date1 = this.getTimestampValue(arguments, 0, this.tsConverters);
        if (date1 == null) {
            Date date = this.getDateValue(arguments, 0, this.dtInputTypes, this.dtConverters);
            if (date == null) {
                return null;
            }
            date1 = Timestamp.ofEpochMilli(date.toEpochMilli());
        }
        if ((date2 = this.getTimestampValue(arguments, 1, this.tsConverters)) == null) {
            Date date = this.getDateValue(arguments, 1, this.dtInputTypes, this.dtConverters);
            if (date == null) {
                return null;
            }
            date2 = Timestamp.ofEpochMilli(date.toEpochMilli());
        }
        this.cal1.setTimeInMillis(date1.toEpochMilli());
        this.cal2.setTimeInMillis(date2.toEpochMilli());
        int monDiffInt = (this.cal1.get(1) - this.cal2.get(1)) * 12 + (this.cal1.get(2) - this.cal2.get(2));
        if (this.cal1.get(5) == this.cal2.get(5) || this.cal1.get(5) == this.cal1.getActualMaximum(5) && this.cal2.get(5) == this.cal2.getActualMaximum(5)) {
            this.output.set(monDiffInt);
            return this.output;
        }
        int sec1 = this.getDayPartInSec(this.cal1);
        int sec2 = this.getDayPartInSec(this.cal2);
        double monBtwDbl = (double)monDiffInt + (double)(sec1 - sec2) / 2678400.0;
        if (this.isRoundOffNeeded) {
            monBtwDbl = BigDecimal.valueOf(monBtwDbl).setScale(8, 4).doubleValue();
        }
        this.output.set(monBtwDbl);
        return this.output;
    }

    protected int getDayPartInSec(Calendar cal) {
        int dd = cal.get(5);
        int HH = cal.get(11);
        int mm = cal.get(12);
        int ss = cal.get(13);
        int dayInSec = dd * 86400 + HH * 3600 + mm * 60 + ss;
        return dayInSec;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "months_between";
    }
}

