/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hiveexec.com.google.common.math.LongMath;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.LongWritable;

@Description(name="grouping", value="_FUNC_(a, p1, ..., pn) - Indicates whether a specified column expression in is aggregated or not. Returns 1 for aggregated or 0 for not aggregated. ", extended="a is the grouping id, p1...pn are the indices we want to extract")
@UDFType(deterministic=true)
public class GenericUDFGrouping
extends GenericUDF {
    private transient PrimitiveObjectInspector groupingIdOI;
    private int[] indices;
    private LongWritable longWritable = new LongWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("grouping() requires at least 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The first argument to grouping() must be primitive");
        }
        PrimitiveObjectInspector arg1OI = (PrimitiveObjectInspector)arguments[0];
        if (arg1OI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT && arg1OI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.LONG) {
            throw new UDFArgumentTypeException(0, "The first argument to grouping() must be an int/long. Got: " + (Object)((Object)arg1OI.getPrimitiveCategory()));
        }
        this.groupingIdOI = arg1OI;
        this.indices = new int[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            PrimitiveObjectInspector arg2OI = (PrimitiveObjectInspector)arguments[i];
            if (!(arg2OI instanceof ConstantObjectInspector)) {
                throw new UDFArgumentTypeException(i, "Must be a constant. Got: " + arg2OI.getClass().getSimpleName());
            }
            this.indices[i - 1] = PrimitiveObjectInspectorUtils.getInt(((ConstantObjectInspector)arguments[i]).getWritableConstantValue(), arg2OI);
        }
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        long result = 0L;
        for (int a = 1; a < arguments.length; ++a) {
            result += LongMath.pow(2L, this.indices.length - a) * (PrimitiveObjectInspectorUtils.getLong(arguments[0].get(), this.groupingIdOI) >> this.indices[a - 1] & 1L);
        }
        this.longWritable.set(result);
        return this.longWritable;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length > 1);
        return this.getStandardDisplayString("grouping", children);
    }
}

