/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public abstract class GenericUDFBaseUnary
extends GenericUDF {
    protected String opName;
    protected String opDisplayName;
    private transient PrimitiveObjectInspector inputOI;
    protected transient PrimitiveObjectInspector resultOI;
    protected transient ObjectInspectorConverters.Converter converter;
    protected ByteWritable byteWritable = new ByteWritable();
    protected ShortWritable shortWritable = new ShortWritable();
    protected IntWritable intWritable = new IntWritable();
    protected LongWritable longWritable = new LongWritable();
    protected FloatWritable floatWritable = new FloatWritable();
    protected DoubleWritable doubleWritable = new DoubleWritable();
    protected HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
    protected HiveIntervalYearMonthWritable intervalYearMonthWritable = new HiveIntervalYearMonthWritable();
    protected HiveIntervalDayTimeWritable intervalDayTimeWritable = new HiveIntervalDayTimeWritable();

    public GenericUDFBaseUnary() {
        this.opName = this.getClass().getSimpleName();
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException(this.opName + " requires one argument.");
        }
        ObjectInspector.Category category = arguments[0].getCategory();
        if (category != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The " + GenericUDFUtils.getOrdinal(1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[0];
        if (!FunctionRegistry.isNumericType((PrimitiveTypeInfo)this.inputOI.getTypeInfo()) && this.inputOI.getTypeInfo() != TypeInfoFactory.intervalDayTimeTypeInfo && this.inputOI.getTypeInfo() != TypeInfoFactory.intervalYearMonthTypeInfo) {
            throw new UDFArgumentTypeException(0, "The " + GenericUDFUtils.getOrdinal(1) + " argument of " + this.opName + "  is expected to be a numeric or interval type, but " + this.inputOI.getTypeName() + " is found");
        }
        PrimitiveTypeInfo resultTypeInfo = this.deriveResultTypeInfo(this.inputOI.getTypeInfo());
        this.resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(resultTypeInfo);
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)this.resultOI);
        return this.resultOI;
    }

    private PrimitiveTypeInfo deriveResultTypeInfo(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return TypeInfoFactory.doubleTypeInfo;
            }
        }
        return typeInfo;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "(" + this.opDisplayName + " " + children[0] + ")";
    }
}

