/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.stats.ColStatsProcessor;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;

@Description(name="compute_bit_vector", value="_FUNC_(x) - Computes bit vector for NDV computation.")
public class GenericUDAFComputeBitVector
extends AbstractGenericUDAFResolver {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length < 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly 2 (col + hll) or 3 (col + fm + #bitvectors) arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        ColStatsProcessor.ColumnStatsType cst = ColStatsProcessor.ColumnStatsType.getColumnStatsType((PrimitiveTypeInfo)((PrimitiveTypeInfo)parameters[0]));
        switch (cst) {
            case LONG: {
                return new GenericUDAFLongStatsEvaluator();
            }
            case DOUBLE: {
                return new GenericUDAFDoubleStatsEvaluator();
            }
            case STRING: {
                return new GenericUDAFStringStatsEvaluator();
            }
            case DECIMAL: {
                return new GenericUDAFDecimalStatsEvaluator();
            }
            case DATE: {
                return new GenericUDAFDateStatsEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Type argument " + parameters[0].getTypeName() + " not valid");
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    static int lengthFor(JavaDataModel model) {
        int length = model.object();
        length += model.array() * 3;
        length += model.primitive1() * 16 * 2;
        return length += (model.object() + model.array() + model.primitive1() + model.primitive2()) * 16;
    }

    public static class GenericUDAFStringStatsEvaluator
    extends GenericUDAFEvaluator {
        private static final int MAX_BIT_VECTORS = 1024;
        private transient PrimitiveObjectInspector inputOI;
        private transient PrimitiveObjectInspector funcOI;
        private transient PrimitiveObjectInspector numVectorsOI;
        private transient BinaryObjectInspector ndvFieldOI;
        private transient BytesWritable partialResult;
        private transient BytesWritable result;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.funcOI = (PrimitiveObjectInspector)parameters[1];
                if (parameters.length > 2) {
                    this.numVectorsOI = (PrimitiveObjectInspector)parameters[2];
                }
            } else {
                this.ndvFieldOI = (BinaryObjectInspector)parameters[0];
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                this.partialResult = new BytesWritable();
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            this.result = new BytesWritable();
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StringStatsAgg result = new StringStatsAgg();
            this.reset(result);
            return result;
        }

        public void initNDVEstimator(StringStatsAgg aggBuffer, String func, int numBitVectors) {
            aggBuffer.numDV = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator((String)func, (int)numBitVectors);
            aggBuffer.numDV.reset();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            myagg.firstItem = true;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            String v;
            Object p = parameters[0];
            StringStatsAgg myagg = (StringStatsAgg)agg;
            if (myagg.firstItem) {
                String func;
                int numVectors = 0;
                String string = func = parameters[1] == null ? "fm" : PrimitiveObjectInspectorUtils.getString(parameters[1], this.funcOI);
                if (parameters.length > 2 && (numVectors = PrimitiveObjectInspectorUtils.getInt(parameters[2], this.numVectorsOI)) > 1024) {
                    throw new HiveException("The maximum allowed value for number of bit vectors  is 1024 , but was passed " + numVectors + " bit vectors");
                }
                this.initNDVEstimator(myagg, func, numVectors);
                myagg.firstItem = false;
            }
            if ((v = PrimitiveObjectInspectorUtils.getString(p, this.inputOI)) != null) {
                myagg.numDV.addToEstimator(v);
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                StringStatsAgg myagg = (StringStatsAgg)agg;
                byte[] buf = this.ndvFieldOI.getPrimitiveJavaObject(partial);
                if (buf != null && buf.length != 0) {
                    if (myagg.numDV == null) {
                        myagg.numDV = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
                    } else {
                        myagg.numDV.mergeEstimators(NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            if (myagg.numDV != null) {
                byte[] buf = myagg.numDV.serialize();
                this.partialResult.set(buf, 0, buf.length);
            }
            return this.partialResult;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            if (myagg.numDV != null) {
                byte[] buf = myagg.numDV.serialize();
                this.result.set(buf, 0, buf.length);
            }
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class StringStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public NumDistinctValueEstimator numDV;
            public boolean firstItem;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return this.numDV == null ? GenericUDAFComputeBitVector.lengthFor(model) : this.numDV.lengthFor(model);
            }
        }
    }

    public static class GenericUDAFTimestampStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<TimestampWritableV2, TimestampObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            TimestampStatsAgg result = new TimestampStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class TimestampStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                TimestampWritableV2 v = new TimestampWritableV2((TimestampWritableV2)inputOI.getPrimitiveWritableObject(p));
                this.numDV.addToEstimator(v.getSeconds());
            }
        }
    }

    public static class GenericUDAFDateStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<DateWritableV2, DateObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DateStatsAgg result = new DateStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DateStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                DateWritableV2 v = new DateWritableV2((DateWritableV2)inputOI.getPrimitiveWritableObject(p));
                this.numDV.addToEstimator((long)v.getDays());
            }
        }
    }

    public static class GenericUDAFDecimalStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<HiveDecimal, HiveDecimalObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DecimalStatsAgg result = new DecimalStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DecimalStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.lengthOfDecimal() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                HiveDecimal v = PrimitiveObjectInspectorUtils.getHiveDecimal(p, inputOI);
                this.numDV.addToEstimator(v);
            }
        }
    }

    public static class GenericUDAFDoubleStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Double, DoubleObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DoubleStatsAgg result = new DoubleStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DoubleStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                double v = PrimitiveObjectInspectorUtils.getDouble(p, inputOI);
                this.numDV.addToEstimator(v);
            }
        }
    }

    public static class GenericUDAFLongStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Long, LongObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            LongStatsAgg result = new LongStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class LongStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                long v = PrimitiveObjectInspectorUtils.getLong(p, inputOI);
                this.numDV.addToEstimator(v);
            }
        }
    }

    public static abstract class GenericUDAFNumericStatsEvaluator<V, OI extends PrimitiveObjectInspector>
    extends GenericUDAFEvaluator {
        protected static final int MAX_BIT_VECTORS = 1024;
        protected transient PrimitiveObjectInspector inputOI;
        protected transient PrimitiveObjectInspector funcOI;
        protected transient PrimitiveObjectInspector numVectorsOI;
        protected transient BinaryObjectInspector ndvFieldOI;
        protected transient BytesWritable partialResult;
        protected transient BytesWritable result;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.funcOI = (PrimitiveObjectInspector)parameters[1];
                if (parameters.length > 2) {
                    this.numVectorsOI = (PrimitiveObjectInspector)parameters[2];
                }
            } else {
                this.ndvFieldOI = (BinaryObjectInspector)parameters[0];
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                this.partialResult = new BytesWritable();
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            this.result = new BytesWritable();
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            NumericStatsAgg myagg = (NumericStatsAgg)agg;
            if (myagg.numDV == null) {
                String func;
                int numVectors = 0;
                String string = func = parameters[1] == null ? "fm" : PrimitiveObjectInspectorUtils.getString(parameters[1], this.funcOI);
                if (parameters.length == 3) {
                    int n = numVectors = parameters[2] == null ? 0 : PrimitiveObjectInspectorUtils.getInt(parameters[2], this.numVectorsOI);
                    if (numVectors > 1024) {
                        throw new HiveException("The maximum allowed value for number of bit vectors  is 1024, but was passed " + numVectors + " bit vectors");
                    }
                }
                myagg.initNDVEstimator(func, numVectors);
            }
            if (parameters[0] != null) {
                myagg.update(parameters[0], this.inputOI);
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                NumericStatsAgg myagg = (NumericStatsAgg)agg;
                byte[] buf = this.ndvFieldOI.getPrimitiveJavaObject(partial);
                if (buf != null && buf.length != 0) {
                    if (myagg.numDV == null) {
                        myagg.numDV = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
                    } else {
                        myagg.numDV.mergeEstimators(NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serializePartial(this.partialResult);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serialize(this.result);
        }

        public abstract class NumericStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public NumDistinctValueEstimator numDV;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return this.numDV == null ? GenericUDAFComputeBitVector.lengthFor(model) : this.numDV.lengthFor(model);
            }

            protected void initNDVEstimator(String func, int numBitVectors) {
                this.numDV = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator((String)func, (int)numBitVectors);
            }

            protected abstract void update(Object var1, PrimitiveObjectInspector var2);

            protected Object serialize(BytesWritable result) {
                if (this.numDV != null) {
                    byte[] buf = this.numDV.serialize();
                    result.set(buf, 0, buf.length);
                }
                return result;
            }

            protected Object serializePartial(BytesWritable result) {
                if (this.numDV != null) {
                    byte[] buf = this.numDV.serialize();
                    result.set(buf, 0, buf.length);
                }
                return result;
            }

            public void reset() throws HiveException {
                this.numDV = null;
            }
        }
    }
}

