/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;

public class UniqueConstraint
implements Serializable {
    Map<String, List<UniqueConstraintCol>> uniqueConstraints;
    String tableName;
    String databaseName;

    public UniqueConstraint() {
    }

    public UniqueConstraint(List<SQLUniqueConstraint> uks, String tableName, String databaseName) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.uniqueConstraints = new TreeMap<String, List<UniqueConstraintCol>>();
        if (uks == null) {
            return;
        }
        for (SQLUniqueConstraint uk : uks) {
            if (!uk.getTable_db().equalsIgnoreCase(databaseName) || !uk.getTable_name().equalsIgnoreCase(tableName)) continue;
            UniqueConstraintCol currCol = new UniqueConstraintCol(uk.getColumn_name(), uk.getKey_seq());
            String constraintName = uk.getUk_name();
            if (this.uniqueConstraints.containsKey(constraintName)) {
                this.uniqueConstraints.get(constraintName).add(currCol);
                continue;
            }
            ArrayList<UniqueConstraintCol> currList = new ArrayList<UniqueConstraintCol>();
            currList.add(currCol);
            this.uniqueConstraints.put(constraintName, currList);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, List<UniqueConstraintCol>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Unique Constraints for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.uniqueConstraints != null && this.uniqueConstraints.size() > 0) {
            for (Map.Entry<String, List<UniqueConstraintCol>> me : this.uniqueConstraints.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey() + ",");
                List<UniqueConstraintCol> currCol = me.getValue();
                if (currCol != null && currCol.size() > 0) {
                    for (UniqueConstraintCol ukc : currCol) {
                        sb.append(" (Column Name: " + ukc.colName + ", Key Sequence: " + ukc.position + "),");
                    }
                    sb.setLength(sb.length() - 1);
                }
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isUniqueConstraintNotEmpty(UniqueConstraint info) {
        return info != null && !info.getUniqueConstraints().isEmpty();
    }

    public class UniqueConstraintCol {
        public String colName;
        public Integer position;

        public UniqueConstraintCol(String colName, Integer position) {
            this.colName = colName;
            this.position = position;
        }
    }
}

