/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.EnumSet;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.PartitionPruneRuleHelper;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;

public class HiveRelOptMaterialization
extends RelOptMaterialization {
    private final EnumSet<RewriteAlgorithm> scope;
    private final boolean sourceTablesUpdateDeleteModified;
    private final boolean sourceTablesCompacted;
    private final IncrementalRebuildMode rebuildMode;

    public HiveRelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable, List<String> qualifiedTableName, EnumSet<RewriteAlgorithm> scope, IncrementalRebuildMode rebuildMode) {
        this(tableRel, queryRel, starRelOptTable, qualifiedTableName, scope, false, false, rebuildMode);
    }

    private HiveRelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable, List<String> qualifiedTableName, EnumSet<RewriteAlgorithm> scope, boolean sourceTablesUpdateDeleteModified, boolean sourceTablesCompacted, IncrementalRebuildMode rebuildMode) {
        super(tableRel, queryRel, starRelOptTable, qualifiedTableName);
        this.scope = scope;
        this.sourceTablesUpdateDeleteModified = sourceTablesUpdateDeleteModified;
        this.sourceTablesCompacted = sourceTablesCompacted;
        this.rebuildMode = rebuildMode;
    }

    public EnumSet<RewriteAlgorithm> getScope() {
        return this.scope;
    }

    public boolean isSupported(EnumSet<RewriteAlgorithm> scope) {
        return !CollectionUtils.intersection(this.scope, scope).isEmpty();
    }

    public boolean isSourceTablesUpdateDeleteModified() {
        return this.sourceTablesUpdateDeleteModified;
    }

    public boolean isSourceTablesCompacted() {
        return this.sourceTablesCompacted;
    }

    public IncrementalRebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public HiveRelOptMaterialization updateInvalidation(Materialization materialization) {
        return new HiveRelOptMaterialization(this.tableRel, this.queryRel, this.starRelOptTable, this.qualifiedTableName, this.scope, materialization.isSourceTablesUpdateDeleteModified(), materialization.isSourceTablesCompacted(), this.rebuildMode);
    }

    public HiveRelOptMaterialization copyToNewCluster(RelOptCluster optCluster, PartitionPruneRuleHelper ruleHelper) {
        RelNode newViewScan = HiveMaterializedViewUtils.copyNodeNewCluster((RelOptCluster)optCluster, (RelNode)this.tableRel, (PartitionPruneRuleHelper)ruleHelper);
        return new HiveRelOptMaterialization(newViewScan, this.queryRel, null, this.qualifiedTableName, this.scope, this.sourceTablesUpdateDeleteModified, this.sourceTablesCompacted, this.rebuildMode);
    }

    public static enum IncrementalRebuildMode {
        AVAILABLE,
        INSERT_ONLY,
        NOT_AVAILABLE,
        UNKNOWN;

    }

    public static enum RewriteAlgorithm {
        TEXT,
        CALCITE;

        public static final EnumSet<RewriteAlgorithm> ALL;

        static {
            ALL = EnumSet.allOf(RewriteAlgorithm.class);
        }
    }
}

