/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.annotations.VisibleForTesting;
import hiveexec.com.google.common.base.Function;
import hiveexec.com.google.common.base.Preconditions;
import hiveexec.com.google.common.base.Splitter;
import hiveexec.com.google.common.collect.ImmutableList;
import hiveexec.com.google.common.collect.ImmutableMap;
import hiveexec.com.google.common.collect.Lists;
import hiveexec.com.google.common.collect.Maps;
import hiveexec.com.google.common.collect.Sets;
import hiveexec.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.jdo.JDODataStoreException;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.SynchronizedMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.CheckJDOException;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.metadata.Hive");
    private final String CLASS_NAME = Hive.class.getName();
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private SynchronizedMetaStoreClient syncMetaStoreClient;
    private UserGroupInformation owner;
    private boolean isAllowClose = true;
    private final ConcurrentHashMap<String, Long> metaCallTimeMap = new ConcurrentHashMap();
    private static ThreadLocalHive hiveDB = new ThreadLocalHive();
    private static final AtomicInteger didRegisterAllFuncs = new AtomicInteger(0);
    private static final int REG_FUNCS_NO = 0;
    private static final int REG_FUNCS_DONE = 2;
    private static final int REG_FUNCS_PENDING = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllFunctionsOnce() throws HiveException {
        boolean breakLoop = false;
        block21: while (!breakLoop) {
            int val = didRegisterAllFuncs.get();
            switch (val) {
                case 0: {
                    if (!didRegisterAllFuncs.compareAndSet(val, 1)) continue block21;
                    breakLoop = true;
                    continue block21;
                }
                case 1: {
                    AtomicInteger atomicInteger = didRegisterAllFuncs;
                    synchronized (atomicInteger) {
                        try {
                            didRegisterAllFuncs.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
            throw new AssertionError(val);
        }
        try {
            this.reloadFunctions();
            didRegisterAllFuncs.compareAndSet(1, 2);
        }
        catch (Exception e) {
            LOG.warn("Failed to register all functions.", (Throwable)e);
            didRegisterAllFuncs.compareAndSet(1, 0);
            throw new HiveException(e);
        }
        finally {
            AtomicInteger atomicInteger = didRegisterAllFuncs;
            synchronized (atomicInteger) {
                didRegisterAllFuncs.notifyAll();
            }
        }
    }

    public void reloadFunctions() throws HiveException {
        HashSet registryFunctions = new HashSet(FunctionRegistry.getFunctionNames((String)".+\\..+"));
        for (org.apache.hadoop.hive.metastore.api.Function function : this.getAllFunctions()) {
            String functionName = function.getFunctionName();
            try {
                LOG.info("Registering function " + functionName + " " + function.getClassName());
                String qualFunc = FunctionUtils.qualifyFunctionName(functionName, function.getDbName());
                FunctionRegistry.registerPermanentFunction((String)qualFunc, (String)function.getClassName(), (boolean)false, (FunctionInfo.FunctionResource[])FunctionUtils.toFunctionResource(function.getResourceUris()));
                registryFunctions.remove(qualFunc);
            }
            catch (Exception e) {
                LOG.warn("Failed to register persistent function " + functionName + ":" + function.getClassName() + ". Ignore and continue.");
            }
        }
        for (String functionName : registryFunctions) {
            try {
                FunctionRegistry.unregisterPermanentFunction((String)functionName);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister persistent function " + functionName + "on reload. Ignore and continue.");
            }
        }
    }

    public static Hive get(Configuration c, Class<?> clazz) throws HiveException {
        return Hive.get(c instanceof HiveConf ? (HiveConf)c : new HiveConf(c, clazz));
    }

    public static Hive get(HiveConf c) throws HiveException {
        return Hive.getInternal(c, false, false, true);
    }

    public static Hive getWithFastCheck(HiveConf c) throws HiveException {
        return Hive.getWithFastCheck(c, true);
    }

    public static Hive getWithFastCheck(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(c, false, true, doRegisterAllFns);
    }

    private static Hive getInternal(HiveConf c, boolean needsRefresh, boolean isFastCheck, boolean doRegisterAllFns) throws HiveException {
        Hive db = (Hive)hiveDB.get();
        if (db == null || !db.isCurrentUserOwner() || needsRefresh || c != null && !Hive.isCompatible(db, c, isFastCheck)) {
            if (db != null) {
                LOG.debug("Creating new db. db = " + db + ", needsRefresh = " + needsRefresh + ", db.isCurrentUserOwner = " + db.isCurrentUserOwner());
                Hive.closeCurrent();
            }
            db = Hive.create(c, doRegisterAllFns);
        }
        if (c != null) {
            db.conf = c;
        }
        return db;
    }

    private static Hive create(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        if (c == null) {
            c = Hive.createHiveConf();
        }
        c.set("fs.scheme.class", "dfs");
        Hive newdb = new Hive(c, doRegisterAllFns);
        if ((newdb.getHMSClientCapabilities() == null || newdb.getHMSClientCapabilities().length == 0) && c.get(HiveConf.ConfVars.METASTORE_CLIENT_CAPABILITIES.varname) != null) {
            String[] capabilities = c.get(HiveConf.ConfVars.METASTORE_CLIENT_CAPABILITIES.varname).split(",");
            newdb.setHMSClientCapabilities(capabilities);
            String hostName = "unknown";
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            newdb.setHMSClientIdentifier("Hiveserver2#" + HiveVersionInfo.getVersion() + "@" + hostName);
        }
        hiveDB.set(newdb);
        return newdb;
    }

    private static HiveConf createHiveConf() {
        SessionState session = SessionState.get();
        return session == null ? new HiveConf(Hive.class) : session.getConf();
    }

    public void setHMSClientCapabilities(String[] capabilities) {
        HiveMetaStoreClient.setProcessorCapabilities((String[])capabilities);
    }

    public void setHMSClientIdentifier(String id) {
        HiveMetaStoreClient.setProcessorIdentifier((String)id);
    }

    public String[] getHMSClientCapabilities() {
        return HiveMetaStoreClient.getProcessorCapabilities();
    }

    public String getHMSClientIdentifier() {
        return HiveMetaStoreClient.getProcessorIdentifier();
    }

    private static boolean isCompatible(Hive db, HiveConf c, boolean isFastCheck) {
        if (isFastCheck) {
            return !(db.metaStoreClient != null && !db.metaStoreClient.isSameConfObj((Configuration)c) || db.syncMetaStoreClient != null && !db.syncMetaStoreClient.isSameConfObj((Configuration)c));
        }
        return !(db.metaStoreClient != null && !db.metaStoreClient.isCompatibleWith((Configuration)c) || db.syncMetaStoreClient != null && !db.syncMetaStoreClient.isCompatibleWith((Configuration)c));
    }

    private boolean isCurrentUserOwner() throws HiveException {
        try {
            return this.owner == null || this.owner.equals((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new HiveException("Error getting current user: " + e.getMessage(), e);
        }
    }

    public static Hive getThreadLocal() {
        return (Hive)hiveDB.get();
    }

    public static Hive get() throws HiveException {
        return Hive.get(true);
    }

    @VisibleForTesting
    public static Hive get(IMetaStoreClient msc) throws HiveException, MetaException {
        Hive hive = Hive.get(true);
        hive.setMSC(msc);
        return hive;
    }

    public static Hive get(boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(null, false, false, doRegisterAllFns);
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        return Hive.getInternal(c, needsRefresh, false, true);
    }

    public static void set(Hive hive) {
        hiveDB.set(hive);
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        this.conf = c;
        if (doRegisterAllFns) {
            this.registerAllFunctionsOnce();
        }
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }

    public void setAllowClose(boolean allowClose) {
        this.isAllowClose = allowClose;
    }

    public boolean allowClose() {
        return this.isAllowClose;
    }

    public void close(boolean forceClose) {
        if (this.allowClose() || forceClose) {
            LOG.debug("Closing current thread's connection to Hive Metastore.");
            if (this.metaStoreClient != null) {
                this.metaStoreClient.close();
                this.metaStoreClient = null;
            }
            this.syncMetaStoreClient = null;
            if (this.owner != null) {
                this.owner = null;
            }
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, bucketCount, bucketCols, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols, Map<String, String> parameters) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = this.newTable(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        if (parameters != null) {
            tbl.setParameters(parameters);
        }
        this.createTable(tbl);
    }

    public void alterTable(Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        this.alterTable(newTbl.getCatName(), newTbl.getDbName(), newTbl.getTableName(), newTbl, cascade, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        String[] names = Utilities.getDbTableName((String)fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, false, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        String[] names = Utilities.getDbTableName((String)fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, cascade, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional, long writeId) throws HiveException {
        String[] names = Utilities.getDbTableName((String)fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, cascade, environmentContext, transactional, writeId);
    }

    public void alterTable(String catName, String dbName, String tblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        this.alterTable(catName, dbName, tblName, newTbl, cascade, environmentContext, transactional, 0L);
    }

    public void alterTable(String catName, String dbName, String tblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional, long replWriteId) throws HiveException {
        if (catName == null) {
            catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        }
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            newTbl.checkValidity(this.conf);
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            if (cascade) {
                environmentContext.putToProperties("CASCADE", "true");
            }
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                if (replWriteId > 0L) {
                    ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList(dbName + "." + tblName, new long[0], new BitSet(), replWriteId);
                    tableSnapshot = new AcidUtils.TableSnapshot(replWriteId, writeIds.writeToString());
                } else {
                    tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)newTbl, (String)dbName, (String)tblName, (boolean)true);
                }
                if (tableSnapshot != null) {
                    newTbl.getTTable().setWriteId(tableSnapshot.getWriteId());
                } else {
                    LOG.warn("Cannot get a table snapshot for " + tblName);
                }
            }
            this.getMSC().alter_table(catName, dbName, tblName, newTbl.getTTable(), environmentContext, tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
    }

    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws HiveException {
        try {
            this.getMSC().updateCreationMetadata(dbName, tableName, cm);
        }
        catch (TException e) {
            throw new HiveException("Unable to update creation metadata " + e.getMessage(), e);
        }
    }

    @Deprecated
    public void alterPartition(String tblName, Partition newPart, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        this.alterPartition(null, names[0], names[1], newPart, environmentContext, transactional);
    }

    public void alterPartition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        try {
            if (catName == null) {
                catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            }
            this.validatePartition(newPart);
            String location = newPart.getLocation();
            if (location != null) {
                location = Utilities.getQualifiedPath((HiveConf)this.conf, (Path)new Path(location));
                newPart.setLocation(location);
            }
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)newPart.getTable(), (boolean)true);
                if (tableSnapshot != null) {
                    newPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
                } else {
                    LOG.warn("Cannot get a table snapshot for " + tblName);
                }
            }
            this.getSynchronizedMSC().alter_partition(catName, dbName, tblName, newPart.getTPartition(), environmentContext, tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    private void validatePartition(Partition newPart) throws HiveException {
        if (newPart.getParameters() != null) {
            newPart.getParameters().remove("transient_lastDdlTime");
        }
        newPart.checkValidity();
    }

    public void alterPartitions(String tblName, List<Partition> newParts, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> newTParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        try {
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)newParts.get(0).getTable(), (boolean)true);
            }
            for (Partition tmpPart : newParts) {
                String location;
                if (tmpPart.getParameters() != null) {
                    tmpPart.getParameters().remove("transient_lastDdlTime");
                }
                if ((location = tmpPart.getLocation()) != null) {
                    location = Utilities.getQualifiedPath((HiveConf)this.conf, (Path)new Path(location));
                    tmpPart.setLocation(location);
                }
                newTParts.add(tmpPart.getTPartition());
            }
            this.getMSC().alter_partitions(names[0], names[1], newTParts, environmentContext, tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null, tableSnapshot != null ? tableSnapshot.getWriteId() : -1L);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void renamePartition(Table tbl, Map<String, String> oldPartSpec, Partition newPart, long replWriteId) throws HiveException {
        try {
            LinkedHashMap<String, String> newPartSpec = newPart.getSpec();
            if (oldPartSpec.keySet().size() != tbl.getPartCols().size() || newPartSpec.keySet().size() != tbl.getPartCols().size()) {
                throw new HiveException("Unable to rename partition to the same name: number of partition cols don't match. ");
            }
            if (!oldPartSpec.keySet().equals(newPartSpec.keySet())) {
                throw new HiveException("Unable to rename partition to the same name: old and new partition cols don't match. ");
            }
            ArrayList<String> pvals = new ArrayList<String>();
            for (FieldSchema field : tbl.getPartCols()) {
                String val = oldPartSpec.get(field.getName());
                if (val == null || val.length() == 0) {
                    throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
                }
                if (val == null) continue;
                pvals.add(val);
            }
            String validWriteIds = null;
            if (AcidUtils.isTransactionalTable((Table)tbl)) {
                AcidUtils.TableSnapshot tableSnapshot;
                if (replWriteId > 0L) {
                    ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList(tbl.getDbName() + "." + tbl.getTableName(), new long[0], new BitSet(), replWriteId);
                    tableSnapshot = new AcidUtils.TableSnapshot(replWriteId, writeIds.writeToString());
                } else {
                    tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl, (boolean)true);
                }
                if (tableSnapshot != null) {
                    newPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
                    validWriteIds = tableSnapshot.getValidWriteIdList();
                }
            }
            String catName = tbl.getCatalogName() != null ? tbl.getCatalogName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            this.getMSC().renamePartition(catName, tbl.getDbName(), tbl.getTableName(), pvals, newPart.getTPartition(), validWriteIds);
        }
        catch (InvalidOperationException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws HiveException {
        try {
            AcidUtils.TableSnapshot tableSnapshot;
            CreateTableAutomaticGrant grants;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tbl.getDbName())) {
                tbl.setDbName(SessionState.get().getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0 || tbl.getSd().getColsSize() == 0) {
                tbl.setFields(HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity(this.conf);
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null && (grants = ss.getCreateTableGrants()) != null) {
                principalPrivs.setUserPrivileges(grants.getUserGrants());
                principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                principalPrivs.setRolePrivileges(grants.getRoleGrants());
                tTbl.setPrivileges(principalPrivs);
            }
            if (tTbl.getWriteId() <= 0L && (tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl, (boolean)true)) != null) {
                tbl.getTTable().setWriteId(tableSnapshot.getWriteId());
            }
            if (primaryKeys == null && foreignKeys == null && uniqueConstraints == null && notNullConstraints == null && defaultConstraints == null && checkConstraints == null) {
                this.getMSC().createTable(tTbl);
            } else {
                this.getMSC().createTableWithConstraints(tTbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
            }
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        this.createTable(tbl, ifNotExists, null, null, null, null, null, null);
    }

    public static List<FieldSchema> getFieldsFromDeserializerForMsStorage(Table tbl, Deserializer deserializer) throws SerDeException, MetaException {
        List schema = HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)deserializer);
        for (FieldSchema field : schema) {
            field.setType("<derived from deserializer>");
        }
        return schema;
    }

    public void dropTable(String tableName, boolean ifPurge) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        this.dropTable(names[0], names[1], true, true, ifPurge);
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(tableName, false);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        this.dropTable(dbName, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (MetaException e) {
            int idx = ExceptionUtils.indexOfType((Throwable)e, SQLIntegrityConstraintViolationException.class);
            if (idx != -1 && ExceptionUtils.getThrowables((Throwable)e)[idx].getMessage().contains("MV_TABLES_USED")) {
                throw new HiveException("Cannot drop table since it is used by at least one materialized view definition. Please drop any materialized view that uses the table before dropping it", e);
            }
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void truncateTable(String dbDotTableName, Map<String, String> partSpec, Long writeId) throws HiveException {
        try {
            List<String> partNames;
            Table table = this.getTable(dbDotTableName, true);
            AcidUtils.TableSnapshot snapshot = null;
            if (AcidUtils.isTransactionalTable((Table)table)) {
                if (writeId <= 0L) {
                    snapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)table, (boolean)true);
                } else {
                    String fullTableName = AcidUtils.getFullTableName((String)table.getDbName(), (String)table.getTableName());
                    ValidWriteIdList writeIdList = this.getMSC().getValidWriteIds(fullTableName, writeId);
                    snapshot = new AcidUtils.TableSnapshot(writeId.longValue(), writeIdList.writeToString());
                }
            }
            List<String> list = partNames = null == partSpec ? null : this.getPartitionNames(table.getDbName(), table.getTableName(), partSpec, (short)-1);
            if (snapshot == null) {
                this.getMSC().truncateTable(table.getDbName(), table.getTableName(), partNames);
            } else {
                this.getMSC().truncateTable(table.getDbName(), table.getTableName(), partNames, snapshot.getValidWriteIdList(), snapshot.getWriteId());
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(tableName, true);
    }

    public Table getTable(String tableName, boolean throwException) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        return this.getTable(names[0], names[1], throwException);
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        if (tableName.contains(".")) {
            String[] names = Utilities.getDbTableName((String)tableName);
            return this.getTable(names[0], names[1], true);
        }
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(TableName tableName) throws HiveException {
        return this.getTable((String)ObjectUtils.firstNonNull((Object[])new String[]{tableName.getDb(), SessionState.get().getCurrentDatabase()}), tableName.getTable(), true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        return this.getTable(dbName, tableName, throwException, false);
    }

    public Table getTable(String dbName, String tableName, boolean throwException, boolean checkTransactional) throws HiveException {
        return this.getTable(dbName, tableName, throwException, checkTransactional, false);
    }

    public Table getTable(String dbName, String tableName, boolean throwException, boolean checkTransactional, boolean getColumnStats) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            if (checkTransactional) {
                long txnId;
                ValidWriteIdList validWriteIdList = null;
                long l = txnId = SessionState.get() != null && SessionState.get().getTxnMgr() != null ? SessionState.get().getTxnMgr().getCurrentTxnId() : 0L;
                if (txnId > 0L) {
                    validWriteIdList = AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, (String)dbName, (String)tableName);
                }
                tTable = this.getMSC().getTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, validWriteIdList != null ? validWriteIdList.toString() : null, getColumnStats, "hive", false);
            } else {
                tTable = this.getMSC().getTable(dbName, tableName, getColumnStats, "hive");
            }
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error("Table " + dbName + "." + tableName + " not found: " + e.getMessage());
                throw new InvalidTableException(tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName + ". " + e.getMessage(), e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            String sf;
            Map parameters = tTable.getSd().getParameters();
            String string = sf = parameters != null ? (String)parameters.get("serialization.format") : null;
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        return new Table(tTable);
    }

    private ValidWriteIdList getValidWriteIdList(String dbName, String tableName) throws LockException {
        long txnId;
        ValidWriteIdList validWriteIdList = null;
        long l = txnId = SessionState.get().getTxnMgr() != null ? SessionState.get().getTxnMgr().getCurrentTxnId() : 0L;
        if (txnId > 0L) {
            validWriteIdList = AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, (String)dbName, (String)tableName);
        }
        return validWriteIdList;
    }

    public List<String> getAllTables() throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), null, null);
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", null);
    }

    public List<Table> getAllTableObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", null);
    }

    public List<Table> getTableObjectsByType(String dbName, String pattern, TableType tableType) throws HiveException {
        return this.getTableObjects(dbName, pattern, tableType);
    }

    public List<String> getAllMaterializedViews(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getAllMaterializedViewObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getMaterializedViewObjectsByPattern(String dbName, String pattern) throws HiveException {
        return this.getTableObjects(dbName, pattern, TableType.MATERIALIZED_VIEW);
    }

    private List<Table> getTableObjects(String dbName, String pattern, TableType tableType) throws HiveException {
        try {
            return Lists.transform(this.getMSC().getTableObjectsByName(dbName, this.getTablesByType(dbName, pattern, tableType)), new Function<org.apache.hadoop.hive.metastore.api.Table, Table>(){

                @Override
                public Table apply(org.apache.hadoop.hive.metastore.api.Table table) {
                    return new Table(table);
                }
            });
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), tablePattern, null);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        return this.getTablesByType(dbName, tablePattern, null);
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        return this.getTablesByType(database, tablePattern, null);
    }

    public List<String> getTablesByType(String dbName, String pattern, TableType type) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getTablesByType");
        if (dbName == null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        try {
            List result = type != null ? (pattern != null ? this.getMSC().getTables(dbName, pattern, type) : this.getMSC().getTables(dbName, ".*", type)) : (pattern != null ? this.getMSC().getTables(dbName, pattern) : this.getMSC().getTables(dbName, ".*"));
            List list = result;
            return list;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getTablesByType", "HS2-cache");
        }
    }

    public List<HiveRelOptMaterialization> getPreprocessedMaterializedViewsFromRegistry(List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> materializedViews = HiveMaterializedViewsRegistry.get().getRewritingMaterializedViews();
        if (materializedViews.isEmpty()) {
            return new ArrayList<HiveRelOptMaterialization>();
        }
        return this.filterAugmentMaterializedViews(materializedViews, tablesUsed, txnMgr);
    }

    private List<HiveRelOptMaterialization> filterAugmentMaterializedViews(List<HiveRelOptMaterialization> materializedViews, List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        String validTxnsList = this.conf.get("hive.txn.valid.txns");
        ValidTxnWriteIdList currentTxnWriteIds = txnMgr.getValidWriteIds(tablesUsed, validTxnsList);
        boolean tryIncrementalRewriting = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_INCREMENTAL);
        long defaultTimeWindow = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (HiveRelOptMaterialization materialization : materializedViews) {
                Table materializedViewTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)materialization);
                Boolean outdated = HiveMaterializedViewUtils.isOutdatedMaterializedView((Table)materializedViewTable, (ValidTxnWriteIdList)currentTxnWriteIds, (long)defaultTimeWindow, tablesUsed, (boolean)false);
                if (outdated == null) continue;
                CreationMetadata creationMetadata = materializedViewTable.getCreationMetadata();
                if (outdated.booleanValue()) {
                    if (!tryIncrementalRewriting) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                        continue;
                    }
                    materialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation((HiveRelOptMaterialization)materialization, (String)validTxnsList, (ValidTxnWriteIdList)new ValidTxnWriteIdList(creationMetadata.getValidTxnList()));
                }
                result.addAll(HiveMaterializedViewUtils.deriveGroupingSetsMaterializedViews((HiveRelOptMaterialization)materialization));
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean validateMaterializedViewsFromRegistry(List<Table> cachedMaterializedViewTables, List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        long defaultTimeWindow = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
        String validTxnsList = this.conf.get("hive.txn.valid.txns");
        ValidTxnWriteIdList currentTxnWriteIds = txnMgr.getValidWriteIds(tablesUsed, validTxnsList);
        try {
            boolean result = true;
            for (Table cachedMaterializedViewTable : cachedMaterializedViewTables) {
                Table materializedViewTable = this.getTable(cachedMaterializedViewTable.getDbName(), cachedMaterializedViewTable.getTableName());
                if (materializedViewTable == null || !materializedViewTable.isRewriteEnabled()) {
                    HiveMaterializedViewsRegistry.get().dropMaterializedView(cachedMaterializedViewTable);
                    result = false;
                    continue;
                }
                Boolean outdated = HiveMaterializedViewUtils.isOutdatedMaterializedView((Table)cachedMaterializedViewTable, (ValidTxnWriteIdList)currentTxnWriteIds, (long)defaultTimeWindow, tablesUsed, (boolean)false);
                if (outdated == null) {
                    result = false;
                    continue;
                }
                if (outdated.booleanValue()) {
                    if (!cachedMaterializedViewTable.equals(materializedViewTable)) {
                        HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, this, cachedMaterializedViewTable, materializedViewTable);
                        result = false;
                        continue;
                    }
                    Materialization invalidationInfo = this.getMSC().getMaterializationInvalidationInfo(materializedViewTable.getCreationMetadata(), this.conf.get("hive.txn.valid.txns"));
                    if (invalidationInfo != null && !invalidationInfo.isSourceTablesUpdateDeleteModified() && !invalidationInfo.isSourceTablesCompacted()) continue;
                    result = false;
                    continue;
                }
                if (cachedMaterializedViewTable.equals(materializedViewTable)) continue;
                HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, this, cachedMaterializedViewTable, materializedViewTable);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveRelOptMaterialization> getPreprocessedMaterializedViews(List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        List<Table> materializedViewTables = this.getAllMaterializedViewObjectsForRewriting();
        if (materializedViewTables.isEmpty()) {
            return new ArrayList<HiveRelOptMaterialization>();
        }
        return this.getValidMaterializedViews(materializedViewTables, tablesUsed, false, true, txnMgr, EnumSet.of(HiveRelOptMaterialization.RewriteAlgorithm.CALCITE));
    }

    public HiveRelOptMaterialization getMaterializedViewForRebuild(String dbName, String materializedViewName, List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> validMaterializedViews = this.getValidMaterializedViews(ImmutableList.of(this.getTable(dbName, materializedViewName)), tablesUsed, true, false, txnMgr, HiveRelOptMaterialization.RewriteAlgorithm.ALL);
        if (validMaterializedViews.isEmpty()) {
            return null;
        }
        Preconditions.checkState(validMaterializedViews.size() == 1, "Returned more than a materialized view for rebuild");
        return validMaterializedViews.get(0);
    }

    private List<HiveRelOptMaterialization> getValidMaterializedViews(List<Table> materializedViewTables, List<String> tablesUsed, boolean forceMVContentsUpToDate, boolean expandGroupingSets, HiveTxnManager txnMgr, EnumSet<HiveRelOptMaterialization.RewriteAlgorithm> scope) throws HiveException {
        String validTxnsList = this.conf.get("hive.txn.valid.txns");
        ValidTxnWriteIdList currentTxnWriteIds = txnMgr.getValidWriteIds(tablesUsed, validTxnsList);
        boolean tryIncrementalRewriting = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_INCREMENTAL);
        boolean tryIncrementalRebuild = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL);
        long defaultTimeWindow = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (Table materializedViewTable : materializedViewTables) {
                HiveRelOptMaterialization hiveRelOptMaterialization;
                Table cachedMaterializedViewTable;
                HiveRelOptMaterialization relOptMaterialization;
                Boolean outdated = HiveMaterializedViewUtils.isOutdatedMaterializedView((Table)materializedViewTable, (ValidTxnWriteIdList)currentTxnWriteIds, (long)defaultTimeWindow, tablesUsed, (boolean)forceMVContentsUpToDate);
                if (outdated == null) continue;
                CreationMetadata creationMetadata = materializedViewTable.getCreationMetadata();
                Materialization invalidationInfo = null;
                if (outdated.booleanValue()) {
                    boolean ignore;
                    if (this.conf.getEngine() == HiveConf.Engine.IMPALA) {
                        ignore = true;
                    } else if (forceMVContentsUpToDate && !tryIncrementalRebuild) {
                        ignore = true;
                    } else if (!forceMVContentsUpToDate && !tryIncrementalRewriting) {
                        ignore = true;
                    } else {
                        invalidationInfo = this.getMSC().getMaterializationInvalidationInfo(creationMetadata, this.conf.get("hive.txn.valid.txns"));
                        boolean bl = ignore = invalidationInfo == null || invalidationInfo.isSourceTablesCompacted();
                    }
                    if (ignore) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                        continue;
                    }
                }
                if ((relOptMaterialization = HiveMaterializedViewsRegistry.get().getRewritingMaterializedView(materializedViewTable.getDbName(), materializedViewTable.getTableName(), scope)) != null && (cachedMaterializedViewTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)relOptMaterialization)).equals(materializedViewTable)) {
                    if (outdated.booleanValue()) {
                        relOptMaterialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation((HiveRelOptMaterialization)relOptMaterialization, (String)validTxnsList, (ValidTxnWriteIdList)new ValidTxnWriteIdList(creationMetadata.getValidTxnList()));
                    }
                    this.addToMaterializationList(expandGroupingSets, invalidationInfo, relOptMaterialization, result);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " was not in the cache or it is not supported by specified rewrite algorithm {}", scope);
                }
                if ((hiveRelOptMaterialization = HiveMaterializedViewsRegistry.get().createMaterialization(this.conf, this, materializedViewTable)) == null || !hiveRelOptMaterialization.isSupported(scope)) continue;
                relOptMaterialization = hiveRelOptMaterialization;
                HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, this, null, materializedViewTable);
                if (outdated.booleanValue()) {
                    relOptMaterialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation((HiveRelOptMaterialization)hiveRelOptMaterialization, (String)validTxnsList, (ValidTxnWriteIdList)new ValidTxnWriteIdList(creationMetadata.getValidTxnList()));
                }
                this.addToMaterializationList(expandGroupingSets, invalidationInfo, relOptMaterialization, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void addToMaterializationList(boolean expandGroupingSets, Materialization invalidationInfo, HiveRelOptMaterialization relOptMaterialization, List<HiveRelOptMaterialization> result) {
        if (expandGroupingSets) {
            List hiveRelOptMaterializationList = HiveMaterializedViewUtils.deriveGroupingSetsMaterializedViews((HiveRelOptMaterialization)relOptMaterialization);
            if (invalidationInfo != null) {
                for (HiveRelOptMaterialization materialization : hiveRelOptMaterializationList) {
                    result.add(materialization.updateInvalidation(invalidationInfo));
                }
            } else {
                result.addAll(hiveRelOptMaterializationList);
            }
        } else {
            result.add(invalidationInfo == null ? relOptMaterialization : relOptMaterialization.updateInvalidation(invalidationInfo));
        }
    }

    public List<Table> getAllMaterializedViewObjectsForRewriting() throws HiveException {
        try {
            return this.getMSC().getAllMaterializedViewObjectsForRewriting().stream().map(Table::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveRelOptMaterialization> getMaterializedViewsBySql(String querySql, List<String> tablesUsed, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> materializedViews = HiveMaterializedViewsRegistry.get().getRewritingMaterializedViews(querySql);
        if (materializedViews.isEmpty()) {
            return Collections.emptyList();
        }
        String validTxnsList = this.conf.get("hive.txn.valid.txns");
        ValidTxnWriteIdList currentTxnWriteIds = txnMgr.getValidWriteIds(tablesUsed, validTxnsList);
        long defaultTimeWindow = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (HiveRelOptMaterialization materialization : materializedViews) {
                Table materializedViewTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)materialization);
                Boolean outdated = HiveMaterializedViewUtils.isOutdatedMaterializedView((Table)materializedViewTable, (ValidTxnWriteIdList)currentTxnWriteIds, (long)defaultTimeWindow, tablesUsed, (boolean)false);
                if (outdated == null) {
                    LOG.debug("Unable to determine if Materialized view " + materializedViewTable.getFullyQualifiedName() + " contents are outdated. It may uses external tables?");
                    continue;
                }
                if (outdated.booleanValue()) {
                    LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                    continue;
                }
                result.add(materialization);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void validateDatabaseExists(String databaseName) throws SemanticException {
        boolean exists;
        try {
            exists = this.databaseExists(databaseName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName), e);
        }
        if (!exists) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName));
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getDatabase");
        try {
            Database database = this.getMSC().getDatabase(dbName);
            return database;
        }
        catch (NoSuchObjectException e) {
            Database database = null;
            return database;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getDatabase", "HS2-cache");
        }
    }

    public Database getDatabase(String catName, String dbName) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getDatabase2");
        try {
            Database database = this.getMSC().getDatabase(catName, dbName);
            return database;
        }
        catch (NoSuchObjectException e) {
            Database database = null;
            return database;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getDatabase2", "HS2-cache");
        }
    }

    public Database getDatabaseCurrent() throws HiveException {
        String currentDb = SessionState.get().getCurrentDatabase();
        return this.getDatabase(currentDb);
    }

    private AcidUtils.TableSnapshot getTableSnapshot(Table tbl, Long writeId) throws LockException {
        AcidUtils.TableSnapshot tableSnapshot = null;
        if (writeId != null && writeId > 0L) {
            ValidWriteIdList writeIds = AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, (String)tbl.getDbName(), (String)tbl.getTableName());
            tableSnapshot = new AcidUtils.TableSnapshot(writeId.longValue(), writeIds.writeToString());
        } else {
            tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl, (String)tbl.getDbName(), (String)tbl.getTableName(), (boolean)true);
        }
        return tableSnapshot;
    }

    public Partition loadPartition(Path loadPath, Table tbl, Map<String, String> partSpec, LoadTableDesc.LoadFileType loadFileType, boolean inheritTableSpecs, boolean inheritLocation, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        AcidUtils.TableSnapshot tableSnapshot;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin("MoveTask", "LoadPartition");
        Partition oldPart = this.getPartition(tbl, partSpec, false);
        boolean isTxnTable = AcidUtils.isTransactionalTable((Table)tbl);
        List<Path> newFiles = Collections.synchronizedList(new ArrayList());
        Partition newTPart = this.loadPartitionInternal(loadPath, tbl, partSpec, oldPart, loadFileType, inheritTableSpecs, inheritLocation, isSkewedStoreAsSubdir, isSrcLocal, isAcidIUDoperation, resetStatistics, writeId, stmtId, isInsertOverwrite, isTxnTable, newFiles, isDirectInsert);
        AcidUtils.TableSnapshot tableSnapshot2 = tableSnapshot = isTxnTable ? this.getTableSnapshot(tbl, writeId) : null;
        if (tableSnapshot != null) {
            newTPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
        }
        if (oldPart == null) {
            this.addPartitionToMetastore(newTPart, resetStatistics, tbl, tableSnapshot);
            if (isTxnTable && null != newFiles) {
                this.addWriteNotificationLog(tbl, partSpec, newFiles, writeId);
            }
        } else {
            try {
                this.setStatsPropAndAlterPartition(resetStatistics, tbl, newTPart, tableSnapshot);
            }
            catch (TException e) {
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
        }
        perfLogger.PerfLogEnd("MoveTask", "LoadPartition");
        return newTPart;
    }

    private Partition loadPartitionInternal(Path loadPath, Table tbl, Map<String, String> partSpec, Partition oldPart, LoadTableDesc.LoadFileType loadFileType, boolean inheritTableSpecs, boolean inheritLocation, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isTxnTable, List<Path> newFiles, boolean isDirectInsert) throws HiveException {
        Path tblDataLocationPath = tbl.getDataLocation();
        boolean isMmTableWrite = AcidUtils.isInsertOnlyTable(tbl.getParameters());
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isFullAcidTable = AcidUtils.isFullAcidTable((Table)tbl);
        try {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            Path oldPartPath = oldPart != null ? oldPart.getDataLocation() : null;
            Path newPartPath = null;
            if (inheritLocation) {
                FileSystem loadPathFS;
                FileSystem oldPartPathFS;
                newPartPath = Hive.genPartPathFromTable(tbl, partSpec, tblDataLocationPath);
                if (oldPart != null && FileUtils.equalsFileSystem(oldPartPathFS = oldPartPath.getFileSystem((Configuration)this.getConf()), loadPathFS = loadPath.getFileSystem((Configuration)this.getConf()))) {
                    newPartPath = oldPartPath;
                }
            } else {
                newPartPath = oldPartPath == null ? (newPartPath = Hive.genPartPathFromTable(tbl, partSpec, tblDataLocationPath)) : oldPartPath;
            }
            perfLogger.PerfLogBegin("MoveTask", "FileMoves");
            if ((isMmTableWrite || isDirectInsert || isFullAcidTable) && loadPath.equals((Object)newPartPath) || loadFileType == LoadTableDesc.LoadFileType.IGNORE) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("not moving " + loadPath + " to " + newPartPath + " (MM = " + isMmTableWrite + ", Direct insert = " + isDirectInsert + ")");
                }
                if (newFiles != null) {
                    if (!isMmTableWrite && !isDirectInsert) {
                        isInsertOverwrite = false;
                    }
                    this.listFilesCreatedByQuery(loadPath, writeId, stmtId, isInsertOverwrite, newFiles);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("maybe deleting stuff from " + oldPartPath + " (new " + newPartPath + ") for replace");
                }
            } else {
                boolean isManaged;
                Path destPath = newPartPath;
                if (isMmTableWrite) {
                    destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir((long)writeId) : AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
                }
                if (!isAcidIUDoperation && isFullAcidTable) {
                    destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("moving " + loadPath + " to " + destPath);
                }
                boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
                if (!isTxnTable && (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL || oldPart == null && !isAcidIUDoperation)) {
                    boolean isAutoPurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                    boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.shouldEnableCm((Database)Hive.get().getDatabase(tbl.getDbName()), (org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable());
                    this.replaceFiles(tbl.getPath(), loadPath, destPath, oldPartPath, this.getConf(), isSrcLocal, isAutoPurge, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged, isInsertOverwrite);
                } else {
                    FileSystem fs = destPath.getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged, false);
                }
            }
            perfLogger.PerfLogEnd("MoveTask", "FileMoves");
            Partition newTPart = oldPart != null ? oldPart : new Partition(tbl, partSpec, newPartPath);
            this.alterPartitionSpecInMemory(tbl, partSpec, newTPart.getTPartition(), inheritTableSpecs, newPartPath.toString());
            this.validatePartition(newTPart);
            if (null != oldPart && null != newFiles) {
                if (isTxnTable) {
                    this.addWriteNotificationLog(tbl, partSpec, newFiles, writeId);
                } else {
                    this.fireInsertEvent(tbl, partSpec, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
                }
            } else {
                LOG.debug("No new files were created, and is not a replace, or we're inserting into a partition that does not exist yet. Skipping generating INSERT event.");
            }
            if (resetStatistics) {
                StatsSetupConst.setBasicStatsState(newTPart.getParameters(), (String)"false");
            }
            if (isSkewedStoreAsSubdir) {
                org.apache.hadoop.hive.metastore.api.Partition newCreatedTpart = newTPart.getTPartition();
                SkewedInfo skewedInfo = newCreatedTpart.getSd().getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(newPartPath, skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
                newCreatedTpart.getSd().setSkewedInfo(skewedInfo);
            }
            if (!this.getConf().isAutogatherStatsEnabled()) {
                StatsSetupConst.setBasicStatsState(newTPart.getParameters(), (String)"false");
            }
            if (oldPart == null) {
                newTPart.getTPartition().setParameters(new HashMap());
                if (this.getConf().isAutogatherStatsEnabled()) {
                    StatsSetupConst.setStatsStateForCreateTable(newTPart.getParameters(), (List)MetaStoreUtils.getColumnNames(tbl.getCols()), (String)"true");
                }
                List filesForStats = null;
                filesForStats = isTxnTable ? AcidUtils.getAcidFilesForStats((Table)newTPart.getTable(), (Path)newPartPath, (Configuration)this.conf, null) : HiveStatsUtils.getFileStatusRecurse((Path)newPartPath, (int)-1, (FileSystem)newPartPath.getFileSystem((Configuration)this.conf));
                if (filesForStats != null) {
                    MetaStoreUtils.populateQuickStats((List)filesForStats, newTPart.getParameters());
                } else {
                    MetaStoreUtils.clearQuickStats(newTPart.getParameters());
                }
            }
            return newTPart;
        }
        catch (IOException | InvalidOperationException | MetaException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    private void addPartitionToMetastore(Partition newTPart, boolean resetStatistics, Table tbl, AcidUtils.TableSnapshot tableSnapshot) throws HiveException {
        try {
            LOG.debug("Adding new partition " + newTPart.getSpec());
            this.getSynchronizedMSC().add_partition(newTPart.getTPartition());
        }
        catch (AlreadyExistsException aee) {
            LOG.debug("Caught AlreadyExistsException, trying to alter partition instead");
            try {
                this.setStatsPropAndAlterPartition(resetStatistics, tbl, newTPart, tableSnapshot);
            }
            catch (TException e) {
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            try {
                FileSystem newPathFileSystem = newTPart.getPartitionPath().getFileSystem((Configuration)this.getConf());
                boolean isAutoPurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                FileStatus status = newPathFileSystem.getFileStatus(newTPart.getPartitionPath());
                Hive.trashFiles(newPathFileSystem, new FileStatus[]{status}, this.getConf(), isAutoPurge);
            }
            catch (IOException io) {
                LOG.error("Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
            }
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    private void addPartitionsToMetastore(List<Partition> partitions, boolean resetStatistics, Table tbl, List<AcidUtils.TableSnapshot> tableSnapshots) throws HiveException {
        try {
            if (partitions.isEmpty() || tableSnapshots.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                StringBuffer debugMsg = new StringBuffer("Adding new partitions ");
                partitions.forEach(partition -> debugMsg.append(partition.getSpec() + " "));
                LOG.debug(debugMsg.toString());
            }
            this.getSynchronizedMSC().add_partitions(partitions.stream().map(Partition::getTPartition).collect(Collectors.toList()));
        }
        catch (AlreadyExistsException aee) {
            LOG.debug("Caught AlreadyExistsException, trying to add partitions one by one.");
            assert (partitions.size() == tableSnapshots.size());
            for (int i = 0; i < partitions.size(); ++i) {
                this.addPartitionToMetastore(partitions.get(i), resetStatistics, tbl, tableSnapshots.get(i));
            }
        }
        catch (Exception e) {
            try {
                for (Partition partition2 : partitions) {
                    FileSystem newPathFileSystem = partition2.getPartitionPath().getFileSystem((Configuration)this.getConf());
                    boolean isAutoPurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                    FileStatus status = newPathFileSystem.getFileStatus(partition2.getPartitionPath());
                    Hive.trashFiles(newPathFileSystem, new FileStatus[]{status}, this.getConf(), isAutoPurge);
                }
            }
            catch (IOException io) {
                LOG.error("Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
            }
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    private static Path genPartPathFromTable(Table tbl, Map<String, String> partSpec, Path tblDataLocationPath) throws MetaException {
        Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartPath(partSpec));
        return new Path(tblDataLocationPath.toUri().getScheme(), tblDataLocationPath.toUri().getAuthority(), partPath.toUri().getPath());
    }

    private Path fixFullAcidPathForLoadData(LoadTableDesc.LoadFileType loadFileType, Path destPath, long writeId, int stmtId, Table tbl) throws HiveException {
        switch (loadFileType) {
            case REPLACE_ALL: {
                destPath = new Path(destPath, AcidUtils.baseDir((long)writeId));
                break;
            }
            case KEEP_EXISTING: {
                destPath = new Path(destPath, AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected " + LoadTableDesc.LoadFileType.class.getName() + " " + loadFileType);
            }
        }
        try {
            FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)SessionState.getSessionConf());
            if (!FileUtils.mkdir(fs, destPath, this.conf)) {
                LOG.warn(destPath + " already exists?!?!");
            }
        }
        catch (IOException e) {
            throw new HiveException("load: error while creating " + destPath + ";loadFileType=" + loadFileType, e);
        }
        return destPath;
    }

    public static void listFilesInsideAcidDirectory(Path acidDir, FileSystem srcFs, List<Path> newFiles) throws IOException {
        FileStatus[] acidFiles = srcFs.listStatus(acidDir);
        if (acidFiles == null) {
            LOG.debug("No files added by this query in: " + acidDir);
            return;
        }
        LOG.debug("Listing files under " + acidDir);
        for (FileStatus acidFile : acidFiles) {
            if (!acidFile.isDirectory()) {
                newFiles.add(acidFile.getPath());
                continue;
            }
            Hive.listFilesInsideAcidDirectory(acidFile.getPath(), srcFs, newFiles);
        }
    }

    private void listFilesCreatedByQuery(Path loadPath, long writeId, int stmtId, boolean isInsertOverwrite, List<Path> newFiles) throws HiveException {
        Path acidDir = new Path(loadPath, AcidUtils.baseOrDeltaSubdir((boolean)isInsertOverwrite, (long)writeId, (long)writeId, (int)stmtId));
        try {
            FileSystem srcFs = loadPath.getFileSystem((Configuration)this.conf);
            if (!srcFs.exists(acidDir) || !srcFs.isDirectory(acidDir)) {
                LOG.info("directory does not exist: " + acidDir);
                return;
            }
            Hive.listFilesInsideAcidDirectory(acidDir, srcFs, newFiles);
        }
        catch (IOException e) {
            LOG.error("Error listing files", (Throwable)e);
            throw new HiveException(e);
        }
    }

    private void setStatsPropAndAlterPartition(boolean resetStatistics, Table tbl, Partition newTPart, AcidUtils.TableSnapshot tableSnapshot) throws MetaException, TException {
        EnvironmentContext ec = new EnvironmentContext();
        if (!resetStatistics) {
            ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        LOG.debug("Altering existing partition " + newTPart.getSpec());
        this.getSynchronizedMSC().alter_partition(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), newTPart.getTPartition(), new EnvironmentContext(), tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
    }

    private void setStatsPropAndAlterPartitions(boolean resetStatistics, Table tbl, List<Partition> partitions, AcidUtils.TableSnapshot tableSnapshot) throws TException {
        if (partitions.isEmpty()) {
            return;
        }
        EnvironmentContext ec = new EnvironmentContext();
        if (!resetStatistics) {
            ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Altering existing partitions ");
            partitions.forEach(p -> sb.append(p.getSpec()));
            LOG.debug(sb.toString());
        }
        String validWriteIdList = null;
        long writeId = 0L;
        if (tableSnapshot != null) {
            validWriteIdList = tableSnapshot.getValidWriteIdList();
            writeId = tableSnapshot.getWriteId();
        }
        this.getSynchronizedMSC().alter_partitions(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), partitions.stream().map(Partition::getTPartition).collect(Collectors.toList()), ec, validWriteIdList, writeId);
    }

    private void walkDirTree(FileStatus fSta, FileSystem fSys, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) throws IOException {
        if (!fSta.isDir()) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB leaf " + fSta.getPath());
            }
            this.constructOneLBLocationMap(fSta, skewedColValueLocationMaps, newPartPath, skewedInfo);
            return;
        }
        FileStatus[] children = fSys.listStatus(fSta.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (children != null) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB dir " + fSta.getPath());
            }
            for (FileStatus child : children) {
                this.walkDirTree(child, fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
            }
        }
    }

    private void constructOneLBLocationMap(FileStatus fSta, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) {
        String partDirName;
        Path lbdPath = fSta.getPath().getParent();
        ArrayList<String> skewedValue = new ArrayList<String>();
        String lbDirName = FileUtils.unescapePathName(lbdPath.toString());
        String lbDirSuffix = lbDirName.replace(partDirName = FileUtils.unescapePathName(newPartPath.toString()), "");
        if (lbDirSuffix.startsWith("/")) {
            lbDirSuffix = lbDirSuffix.substring(1);
        }
        String[] dirNames = lbDirSuffix.split("/");
        int keysFound = 0;
        int dirsToTake = 0;
        int colCount = skewedInfo.getSkewedColNames().size();
        while (dirsToTake < dirNames.length && keysFound < colCount) {
            String dirName;
            if ((dirName = dirNames[dirsToTake++]).equalsIgnoreCase("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME")) {
                ++keysFound;
                continue;
            }
            String[] kv = dirName.split("=");
            if (kv.length == 2) {
                skewedValue.add(kv[1]);
                ++keysFound;
                continue;
            }
            LOG.warn("Skipping unknown directory " + dirName + " when expecting LB keys or default directory (from " + lbDirName + ")");
        }
        for (int i = 0; i < dirNames.length - dirsToTake; ++i) {
            lbdPath = lbdPath.getParent();
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Saving LB location " + lbdPath + " based on " + colCount + " keys and " + fSta.getPath());
        }
        if (skewedValue.size() > 0 && skewedValue.size() == colCount && !skewedColValueLocationMaps.containsKey(skewedValue)) {
            skewedColValueLocationMaps.put(skewedValue, lbdPath.toString());
        }
    }

    private Map<List<String>, String> constructListBucketingLocationMap(Path newPartPath, SkewedInfo skewedInfo) throws IOException, FileNotFoundException {
        HashMap<List<String>, String> skewedColValueLocationMaps = new HashMap<List<String>, String>();
        FileSystem fSys = newPartPath.getFileSystem((Configuration)this.conf);
        this.walkDirTree(fSys.getFileStatus(newPartPath), fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
        return skewedColValueLocationMaps;
    }

    private Set<Path> getValidPartitionsInPath(int numDP, int numLB, Path loadPath, Long writeId, int stmtId, boolean isMmTable, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        int partsToLoad;
        HashSet<Path> validPartitions = new HashSet<Path>();
        try {
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            if (!isMmTable && !isDirectInsert) {
                List leafStatus = HiveStatsUtils.getFileStatusRecurse((Path)loadPath, (int)numDP, (FileSystem)fs);
                for (FileStatus s : leafStatus) {
                    if (!s.isDirectory()) {
                        throw new HiveException("partition " + s.getPath() + " is not a directory!");
                    }
                    Path dpPath = s.getPath();
                    validPartitions.add(dpPath);
                }
            } else {
                Path[] leafStatus;
                Utilities.FILE_OP_LOGGER.trace("Looking for dynamic partitions in {} ({} levels)", (Object)loadPath, (Object)numDP);
                for (Path p : leafStatus = Utilities.getDirectInsertDirectoryCandidates((FileSystem)fs, (Path)loadPath, (int)numDP, null, (long)writeId, (int)-1, (Configuration)this.conf, (Boolean)isInsertOverwrite)) {
                    Path dpPath = p.getParent();
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Found DP " + dpPath);
                    }
                    validPartitions.add(dpPath);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if ((partsToLoad = validPartitions.size()) == 0) {
            LOG.warn("No partition is generated by dynamic partitioning");
        }
        if (partsToLoad > this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS)) {
            throw new HiveException("Number of dynamic partitions created is " + partsToLoad + ", which is more than " + this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS) + ". To solve this try to set " + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + " to at least " + partsToLoad + '.');
        }
        return validPartitions;
    }

    public Map<Map<String, String>, Partition> loadDynamicPartitions(Path loadPath, String tableName, Map<String, String> partSpec, LoadTableDesc.LoadFileType loadFileType, int numDP, int numLB, boolean isAcid, long writeId, int stmtId, boolean resetStatistics, AcidUtils.Operation operation, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        final class PartitionDetails {
            Map<String, String> fullSpec;
            Partition partition;
            List<Path> newFiles;
            boolean hasOldPartition = false;
            AcidUtils.TableSnapshot tableSnapshot;

            PartitionDetails() {
            }
        }
        PrintStream printStream;
        boolean inPlaceEligible;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin("MoveTask", "LoadDynamicPartitions");
        Table tbl = this.getTable(tableName);
        Set<Path> validPartitions = this.getValidPartitionsInPath(numDP, numLB, loadPath, writeId, stmtId, AcidUtils.isInsertOnlyTable(tbl.getParameters()), isInsertOverwrite, isDirectInsert);
        int partsToLoad = validPartitions.size();
        AtomicInteger partitionsLoaded = new AtomicInteger(0);
        boolean bl = inPlaceEligible = this.conf.getLong("fs.trash.interval", 0L) <= 0L && InPlaceUpdate.canRenderInPlace((HiveConf)this.conf) && !SessionState.getConsole().getIsSilent();
        if (inPlaceEligible) {
            SessionState.getConsole();
            printStream = SessionState.LogHelper.getInfoStream();
        } else {
            printStream = null;
        }
        PrintStream ps = printStream;
        SessionState parentSession = SessionState.get();
        LinkedList<Callable<Partition>> tasks = Lists.newLinkedList();
        Map partitionDetailsMap = Collections.synchronizedMap(new LinkedHashMap());
        validPartitions.forEach(partPath -> {
            LinkedHashMap<String, String> fullPartSpec = Maps.newLinkedHashMap(partSpec);
            String staticParts = Warehouse.makeDynamicPartName((Map)partSpec);
            Path computedPath = partPath;
            if (!staticParts.isEmpty()) {
                computedPath = new Path(new Path(partPath.getParent(), staticParts), partPath.getName());
            }
            if (!Warehouse.makeSpecFromName(fullPartSpec, (Path)computedPath, new HashSet(partSpec.keySet()))) {
                Utilities.FILE_OP_LOGGER.warn("Ignoring invalid DP directory " + partPath);
            } else {
                PartitionDetails details = new PartitionDetails();
                details.fullSpec = fullPartSpec;
                partitionDetailsMap.put(partPath, details);
            }
        });
        PartitionIterable partitionIterable = new PartitionIterable(Hive.get(), tbl, partSpec, this.conf.getInt(MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX.getVarname(), 300));
        for (Partition partition : partitionIterable) {
            partitionDetailsMap.entrySet().stream().filter(entry -> ((PartitionDetails)entry.getValue()).fullSpec.equals(partition.getSpec())).findAny().ifPresent(entry -> {
                ((PartitionDetails)entry.getValue()).partition = partition;
                ((PartitionDetails)entry.getValue()).hasOldPartition = true;
            });
        }
        boolean isTxnTable = AcidUtils.isTransactionalTable((Table)tbl);
        AcidUtils.TableSnapshot tableSnapshot = isTxnTable ? this.getTableSnapshot(tbl, writeId) : null;
        for (Map.Entry entry2 : partitionDetailsMap.entrySet()) {
            tasks.add(() -> {
                PartitionDetails partitionDetails = (PartitionDetails)entry2.getValue();
                Map<String, String> fullPartSpec = partitionDetails.fullSpec;
                try {
                    Object object;
                    SessionState.setCurrentSessionState((SessionState)parentSession);
                    LOG.info("New loading path = " + entry2.getKey() + " withPartSpec " + fullPartSpec);
                    ArrayList<Path> newFiles = Lists.newArrayList();
                    Partition oldPartition = partitionDetails.partition;
                    Partition partition = this.loadPartitionInternal((Path)entry2.getKey(), tbl, fullPartSpec, oldPartition, loadFileType, true, false, numLB > 0, false, isAcid, resetStatistics, writeId, stmtId, isInsertOverwrite, isTxnTable, newFiles, isDirectInsert);
                    if (tableSnapshot != null) {
                        partition.getTPartition().setWriteId(tableSnapshot.getWriteId());
                    }
                    partitionDetails.tableSnapshot = tableSnapshot;
                    if (oldPartition == null) {
                        partitionDetails.newFiles = newFiles;
                        partitionDetails.partition = partition;
                    }
                    if (inPlaceEligible) {
                        object = ps;
                        synchronized (object) {
                            InPlaceUpdate.rePositionCursor((PrintStream)ps);
                            partitionsLoaded.incrementAndGet();
                            InPlaceUpdate.reprintLine((PrintStream)ps, (String)("Loaded : " + partitionsLoaded.get() + "/" + partsToLoad + " partitions."));
                        }
                    }
                    object = partition;
                    return object;
                }
                catch (Exception e) {
                    LOG.error("Exception when loading partition with parameters  partPath=" + entry2.getKey() + ",  table=" + tbl.getTableName() + ",  partSpec=" + fullPartSpec + ",  loadFileType=" + loadFileType.toString() + ",  listBucketingLevel=" + numLB + ",  isAcid=" + isAcid + ",  resetStatistics=" + resetStatistics, (Throwable)e);
                    throw e;
                }
                finally {
                    Hive.closeCurrent();
                }
            });
        }
        int poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_LOAD_DYNAMIC_PARTITIONS_THREAD_COUNT.varname, 1);
        ExecutorService executor = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("load-dynamic-partitionsToAdd-%d").build());
        List<Object> futures = Lists.newLinkedList();
        LinkedHashMap<Map<String, String>, Partition> result = Maps.newLinkedHashMap();
        try {
            futures = executor.invokeAll(tasks);
            LOG.debug("Number of partitionsToAdd to be added is " + futures.size());
            for (Future future : futures) {
                Partition partition = (Partition)future.get();
                result.put(partition.getSpec(), partition);
            }
            this.addPartitionsToMetastore(partitionDetailsMap.entrySet().stream().filter(entry -> !((PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((PartitionDetails)entry.getValue()).partition).collect(Collectors.toList()), resetStatistics, tbl, partitionDetailsMap.entrySet().stream().filter(entry -> !((PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((PartitionDetails)entry.getValue()).tableSnapshot).collect(Collectors.toList()));
            for (Map.Entry entry2 : partitionDetailsMap.entrySet()) {
                PartitionDetails partitionDetails = (PartitionDetails)entry2.getValue();
                if (!isTxnTable || partitionDetails.newFiles == null) continue;
                this.addWriteNotificationLog(tbl, partitionDetails.fullSpec, partitionDetails.newFiles, writeId);
            }
            this.setStatsPropAndAlterPartitions(resetStatistics, tbl, partitionDetailsMap.entrySet().stream().filter(entry -> ((PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((PartitionDetails)entry.getValue()).partition).collect(Collectors.toList()), tableSnapshot);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HiveException("Exception when loading " + validPartitions.size() + " partitions in table " + tbl.getTableName() + " with loadPath=" + loadPath, e);
        }
        catch (TException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (Exception e) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Exception when loading partitionsToAdd with parameters ");
            stringBuffer.append("partPaths=");
            validPartitions.forEach(path -> logMsg.append(path + ", "));
            stringBuffer.append("table=" + tbl.getTableName() + ", ").append("partSpec=" + partSpec + ", ").append("loadFileType=" + loadFileType.toString() + ", ").append("listBucketingLevel=" + numLB + ", ").append("isAcid=" + isAcid + ", ").append("resetStatistics=" + resetStatistics);
            LOG.error(stringBuffer.toString(), (Throwable)e);
            throw e;
        }
        finally {
            LOG.debug("Cancelling " + futures.size() + " dynamic loading tasks");
            executor.shutdownNow();
        }
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST) && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVETESTMODEFAILLOADDYNAMICPARTITION)) {
            throw new HiveException(HiveConf.ConfVars.HIVETESTMODEFAILLOADDYNAMICPARTITION.name() + "=true");
        }
        try {
            if (isTxnTable) {
                List partNames = result.values().stream().map(Partition::getName).collect(Collectors.toList());
                this.getMSC().addDynamicPartitions(parentSession.getTxnMgr().getCurrentTxnId(), writeId, tbl.getDbName(), tbl.getTableName(), partNames, AcidUtils.toDataOperationType((AcidUtils.Operation)operation));
            }
            LOG.info("Loaded " + result.size() + "partitionsToAdd");
            perfLogger.PerfLogEnd("MoveTask", "LoadDynamicPartitions");
            return result;
        }
        catch (TException te) {
            LOG.error(StringUtils.stringifyException((Throwable)te));
            throw new HiveException("Exception updating metastore for acid table " + tableName + " with partitions " + result.values(), te);
        }
    }

    public void loadTable(Path loadPath, String tableName, LoadTableDesc.LoadFileType loadFileType, boolean isSrcLocal, boolean isSkewedStoreAsSubdir, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin("MoveTask", "LoadTable");
        List<Path> newFiles = null;
        Table tbl = this.getTable(tableName);
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isTxnTable = AcidUtils.isTransactionalTable((Table)tbl);
        boolean isMmTable = AcidUtils.isInsertOnlyTable((Table)tbl);
        boolean isFullAcidTable = AcidUtils.isFullAcidTable((Table)tbl);
        boolean isCompactionTable = AcidUtils.isCompactionTable(tbl.getParameters());
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
            newFiles = Collections.synchronizedList(new ArrayList());
        }
        if ((isMmTable || isDirectInsert || isFullAcidTable) && loadPath.equals((Object)tbl.getPath()) || loadFileType == LoadTableDesc.LoadFileType.IGNORE) {
            if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
                Utilities.FILE_OP_LOGGER.debug("not moving " + loadPath + " to " + tbl.getPath() + " (MM)");
            }
            if (newFiles != null) {
                if (!isMmTable && !isDirectInsert) {
                    isInsertOverwrite = false;
                }
                this.listFilesCreatedByQuery(loadPath, writeId, stmtId, isInsertOverwrite, newFiles);
            }
        } else {
            boolean isManaged;
            Path tblPath;
            Path destPath = tblPath = tbl.getPath();
            if (isMmTable) {
                destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir((long)writeId) : AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
            }
            if (!isAcidIUDoperation && isFullAcidTable) {
                destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
            }
            Utilities.FILE_OP_LOGGER.debug("moving " + loadPath + " to " + tblPath + " (replace = " + loadFileType + ")");
            perfLogger.PerfLogBegin("MoveTask", "FileMoves");
            boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
            if (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL && !isTxnTable) {
                boolean isAutopurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.shouldEnableCm((Database)this.getDatabase(tbl.getDbName()), (org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable());
                this.replaceFiles(tblPath, loadPath, destPath, tblPath, this.conf, isSrcLocal, isAutopurge, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged, isInsertOverwrite);
            } else {
                try {
                    FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged, isCompactionTable);
                }
                catch (IOException e) {
                    throw new HiveException("addFiles: filesystem error in check phase", e);
                }
            }
            perfLogger.PerfLogEnd("MoveTask", "FileMoves");
        }
        if (!this.getConf().isAutogatherStatsEnabled()) {
            LOG.debug("setting table statistics false for " + tbl.getDbName() + "." + tbl.getTableName());
            StatsSetupConst.setBasicStatsState(tbl.getParameters(), (String)"false");
        }
        if (resetStatistics) {
            LOG.debug("Clearing table statistics for " + tbl.getDbName() + "." + tbl.getTableName());
            StatsSetupConst.clearColumnStatsState(tbl.getParameters());
        }
        try {
            if (isSkewedStoreAsSubdir) {
                SkewedInfo skewedInfo = tbl.getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(tbl.getPath(), skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
            }
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        EnvironmentContext environmentContext = null;
        if (!resetStatistics) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        this.alterTable(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), tbl, false, environmentContext, true, writeId == null ? 0L : writeId);
        if (AcidUtils.isTransactionalTable((Table)tbl)) {
            this.addWriteNotificationLog(tbl, null, newFiles, writeId);
        } else {
            this.fireInsertEvent(tbl, null, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
        }
        perfLogger.PerfLogEnd("MoveTask", "LoadTable");
    }

    @VisibleForTesting
    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, partSpec, null);
            AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl);
            part.setWriteId(tableSnapshot != null ? tableSnapshot.getWriteId() : 0L);
            return new Partition(tbl, this.getMSC().add_partition(part));
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<Partition> createPartitions(AlterTableAddPartitionDesc addPartitionDesc) throws HiveException {
        String validWriteIdList;
        long writeId;
        Table tbl = this.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        int size = addPartitionDesc.getPartitionCount();
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> in = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(size);
        if (addPartitionDesc.getReplicationSpec().isInReplicationScope() && addPartitionDesc.getPartition(0).getWriteId() > 0L) {
            writeId = addPartitionDesc.getPartition(0).getWriteId();
            validWriteIdList = new ValidReaderWriteIdList(tbl.getDbName() + "." + tbl.getTableName(), new long[0], new BitSet(), writeId).writeToString();
        } else {
            AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl, (boolean)true);
            if (tableSnapshot != null && tableSnapshot.getWriteId() > 0L) {
                writeId = tableSnapshot.getWriteId();
                validWriteIdList = tableSnapshot.getValidWriteIdList();
            } else {
                writeId = -1L;
                validWriteIdList = null;
            }
        }
        for (int i = 0; i < size; ++i) {
            org.apache.hadoop.hive.metastore.api.Partition tmpPart = Hive.convertAddSpecToMetaPartition(tbl, addPartitionDesc.getPartition(i), this.conf);
            if (tmpPart != null && writeId > 0L) {
                tmpPart.setWriteId(writeId);
            }
            in.add(tmpPart);
        }
        ArrayList<Partition> out = new ArrayList<Partition>();
        try {
            if (!addPartitionDesc.getReplicationSpec().isInReplicationScope()) {
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(in, addPartitionDesc.isIfNotExists(), true)) {
                    out.add(new Partition(tbl, outPart));
                }
            } else {
                ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partsToAdd = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
                ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partsToAlter = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
                ArrayList<String> part_names = new ArrayList<String>();
                for (org.apache.hadoop.hive.metastore.api.Partition p : in) {
                    part_names.add(Warehouse.makePartName(tbl.getPartitionKeys(), (List)p.getValues()));
                    try {
                        org.apache.hadoop.hive.metastore.api.Partition ptn = this.getMSC().getPartition(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), p.getValues());
                        if (!addPartitionDesc.getReplicationSpec().allowReplacementInto(ptn.getParameters())) continue;
                        ReplicationSpec.copyLastReplId((Map)ptn.getParameters(), (Map)p.getParameters());
                        partsToAlter.add(p);
                    }
                    catch (NoSuchObjectException nsoe) {
                        partsToAdd.add(p);
                    }
                }
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(partsToAdd, addPartitionDesc.isIfNotExists(), true)) {
                    out.add(new Partition(tbl, outPart));
                }
                EnvironmentContext ec = new EnvironmentContext();
                if (!AcidUtils.isTransactionalTable((Table)tbl)) {
                    ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
                }
                this.getMSC().alter_partitions(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), partsToAlter, ec, validWriteIdList, writeId);
                GetPartitionsByNamesRequest partsRequest = new GetPartitionsByNamesRequest();
                partsRequest.setDb_name(MetaStoreUtils.prependCatalogToDbName((String)addPartitionDesc.getDbName(), (Configuration)this.conf));
                partsRequest.setTbl_name(addPartitionDesc.getTableName());
                partsRequest.setNames(part_names);
                partsRequest.setValidWriteIdList(validWriteIdList);
                List partitions = this.getMSC().getPartitionsByNames(partsRequest).getPartitions();
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : partitions) {
                    out.add(new Partition(tbl, outPart));
                }
            }
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return out;
    }

    public static org.apache.hadoop.hive.metastore.api.Partition convertAddSpecToMetaPartition(Table tbl, AlterTableAddPartitionDesc.PartitionDesc addSpec, HiveConf conf) throws HiveException {
        Path location;
        Path path = location = addSpec.getLocation() != null ? new Path(tbl.getPath(), addSpec.getLocation()) : null;
        if (location != null) {
            location = new Path(Utilities.getQualifiedPath((HiveConf)conf, (Path)location));
        }
        org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, addSpec.getPartSpec(), location);
        if (addSpec.getPartParams() != null) {
            part.setParameters(addSpec.getPartParams());
        }
        if (addSpec.getInputFormat() != null) {
            part.getSd().setInputFormat(addSpec.getInputFormat());
        }
        if (addSpec.getOutputFormat() != null) {
            part.getSd().setOutputFormat(addSpec.getOutputFormat());
        }
        if (addSpec.getNumBuckets() != -1) {
            part.getSd().setNumBuckets(addSpec.getNumBuckets());
        }
        if (addSpec.getCols() != null) {
            part.getSd().setCols(addSpec.getCols());
        }
        if (addSpec.getSerializationLib() != null) {
            part.getSd().getSerdeInfo().setSerializationLib(addSpec.getSerializationLib());
        }
        if (addSpec.getSerdeParams() != null) {
            part.getSd().getSerdeInfo().setParameters(addSpec.getSerdeParams());
        }
        if (addSpec.getBucketCols() != null) {
            part.getSd().setBucketCols(addSpec.getBucketCols());
        }
        if (addSpec.getSortCols() != null) {
            part.getSd().setSortCols(addSpec.getSortCols());
        }
        if (addSpec.getColStats() != null) {
            part.setColStats(addSpec.getColStats());
            part.setWriteId(addSpec.getWriteId());
        }
        return part;
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null, true);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs) throws HiveException {
        tbl.validatePartColumnNames(partSpec, true);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) || val != null && val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    LOG.debug("creating partition for table " + tbl.getTableName() + " with partition spec : " + partSpec);
                    try {
                        tpart = this.getSynchronizedMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.debug("Caught already exists exception, trying to alter partition instead");
                        tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
                        this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    }
                    catch (Exception e) {
                        if (CheckJDOException.isJDODataStoreException(e)) {
                            LOG.debug("Caught JDO exception, trying to alter partition instead");
                            tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
                            if (tpart == null) {
                                throw e;
                            }
                            this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                        }
                        throw e;
                    }
                } else {
                    this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    this.fireInsertEvent(tbl, partSpec, true, null);
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    private void alterPartitionSpec(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        this.alterPartitionSpecInMemory(tbl, partSpec, tpart, inheritTableSpecs, partPath);
        this.alterPartition(tbl.getCatalogName(), tbl.getDbName(), tbl.getTableName(), new Partition(tbl, tpart), null, true);
    }

    private void alterPartitionSpecInMemory(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        LOG.debug("altering partition for table " + tbl.getTableName() + " with partition spec : " + partSpec);
        if (inheritTableSpecs) {
            tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
            tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
            tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
            tpart.getSd().getSerdeInfo().setParameters(tbl.getTTable().getSd().getSerdeInfo().getParameters());
            tpart.getSd().setBucketCols(tbl.getBucketCols());
            tpart.getSd().setNumBuckets(tbl.getNumBuckets());
            tpart.getSd().setSortCols(tbl.getSortCols());
        }
        if (partPath == null || partPath.trim().equals("")) {
            throw new HiveException("new partition path should not be null or empty.");
        }
        tpart.getSd().setLocation(partPath);
    }

    public void addWriteNotificationLog(Table tbl, Map<String, String> partitionSpec, List<Path> newFiles, Long writeId) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("write notification log is ignored as dml event logging is disabled");
            return;
        }
        if (tbl.isTemporary()) {
            LOG.debug("write notification log is ignored as " + tbl.getTableName() + " is temporary : " + writeId);
            return;
        }
        if (newFiles == null || newFiles.isEmpty()) {
            LOG.debug("write notification log is ignored as file list is empty");
            return;
        }
        LOG.debug("adding write notification log for operation " + writeId + " table " + tbl.getCompleteName() + "partition " + partitionSpec + " list of files " + newFiles);
        try {
            Long txnId = SessionState.get().getTxnMgr().getCurrentTxnId();
            ArrayList<String> partitionVals = null;
            if (partitionSpec != null && !partitionSpec.isEmpty()) {
                partitionVals = new ArrayList<String>();
                for (FieldSchema fs : tbl.getPartitionKeys()) {
                    partitionVals.add(partitionSpec.get(fs.getName()));
                }
            }
            Hive.addWriteNotificationLog(this.conf, tbl, partitionVals, txnId, writeId, newFiles);
        }
        catch (IOException | TException e) {
            throw new HiveException(e);
        }
    }

    public static void addWriteNotificationLog(HiveConf conf, Table tbl, List<String> partitionVals, Long txnId, Long writeId, List<Path> newFiles) throws IOException, HiveException, TException {
        FileSystem fileSystem = tbl.getDataLocation().getFileSystem((Configuration)conf);
        InsertEventRequestData insertData = new InsertEventRequestData();
        insertData.setReplace(true);
        WriteNotificationLogRequest rqst = new WriteNotificationLogRequest(txnId.longValue(), writeId.longValue(), tbl.getDbName(), tbl.getTableName(), insertData);
        Hive.addInsertFileInformation(newFiles, fileSystem, insertData);
        rqst.setPartitionVals(partitionVals);
        Hive.get(conf).getSynchronizedMSC().addWriteNotificationLog(rqst);
    }

    private void fireInsertEvent(Table tbl, Map<String, String> partitionSpec, boolean replace, List<Path> newFiles) throws HiveException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("Firing dml insert event");
            if (tbl.isTemporary()) {
                LOG.debug("Not firing dml insert event as " + tbl.getTableName() + " is temporary");
                return;
            }
            try {
                FileSystem fileSystem = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                FireEventRequestData data = new FireEventRequestData();
                InsertEventRequestData insertData = new InsertEventRequestData();
                insertData.setReplace(replace);
                data.setInsertData(insertData);
                if (newFiles != null && !newFiles.isEmpty()) {
                    Hive.addInsertFileInformation(newFiles, fileSystem, insertData);
                } else {
                    insertData.setFilesAdded(new ArrayList());
                }
                FireEventRequest rqst = new FireEventRequest(true, data);
                rqst.setDbName(tbl.getDbName());
                rqst.setTableName(tbl.getTableName());
                if (partitionSpec != null && partitionSpec.size() > 0) {
                    ArrayList<String> partVals = new ArrayList<String>(partitionSpec.size());
                    for (FieldSchema fs : tbl.getPartitionKeys()) {
                        partVals.add(partitionSpec.get(fs.getName()));
                    }
                    rqst.setPartitionVals(partVals);
                }
                this.getSynchronizedMSC().fireListenerEvent(rqst);
            }
            catch (IOException | TException e) {
                throw new HiveException(e);
            }
        }
    }

    private static void addInsertFileInformation(List<Path> newFiles, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        LinkedList<Path> directories = null;
        for (Path p : newFiles) {
            if (fileSystem.isDirectory(p)) {
                if (directories == null) {
                    directories = new LinkedList<Path>();
                }
                directories.add(p);
                continue;
            }
            Hive.addInsertNonDirectoryInformation(p, fileSystem, insertData);
        }
        if (directories == null) {
            return;
        }
        while (!directories.isEmpty()) {
            Path dir = (Path)directories.poll();
            FileStatus[] contents = fileSystem.listStatus(dir);
            if (contents == null) continue;
            for (FileStatus status : contents) {
                if (status.isDirectory()) {
                    directories.add(status.getPath());
                    continue;
                }
                Hive.addInsertNonDirectoryInformation(status.getPath(), fileSystem, insertData);
            }
        }
    }

    private static void addInsertNonDirectoryInformation(Path p, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        insertData.addToFilesAdded(p.toString());
        FileChecksum cksum = fileSystem.getFileChecksum(p);
        String acidDirPath = AcidUtils.getFirstLevelAcidDirPath((Path)p.getParent(), (FileSystem)fileSystem);
        if (cksum != null) {
            String checksumString = StringUtils.byteToHexString((byte[])cksum.getBytes(), (int)0, (int)cksum.getLength());
            insertData.addToFilesAddedChecksum(checksumString);
        } else {
            insertData.addToFilesAddedChecksum("");
        }
        if (acidDirPath != null) {
            insertData.addToSubDirectoryList(acidDirPath);
        }
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partitionValues, boolean deleteData) throws HiveException {
        return this.dropPartition(dbName, tableName, partitionValues, PartitionDropOptions.instance().deleteData(deleteData));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partitionValues, PartitionDropOptions options) throws HiveException {
        try {
            return this.getMSC().dropPartition(dbName, tableName, partitionValues, options);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<Partition> dropPartitions(String dbName, String tableName, List<Pair<Integer, byte[]>> partitionExpressions, PartitionDropOptions dropOptions) throws HiveException {
        try {
            Table table = this.getTable(dbName, tableName);
            List partitions = this.getMSC().dropPartitions(dbName, tableName, partitionExpressions, dropOptions);
            return Hive.convertFromMetastore(table, partitions);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<String> getPartitionNames(String tblName, short max) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        return this.getPartitionNames(names[0], names[1], max);
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (NoSuchObjectException nsoe) {
            return Lists.newArrayList();
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        List names = null;
        Table t = this.getTable(dbName, tblName);
        List pvals = MetaStoreUtils.getPvals(t.getPartCols(), partSpec);
        try {
            GetPartitionNamesPsRequest req = new GetPartitionNamesPsRequest();
            req.setTblName(tblName);
            req.setDbName(dbName);
            req.setPartValues(pvals);
            req.setMaxParts(max);
            if (AcidUtils.isTransactionalTable((Table)t)) {
                ValidWriteIdList validWriteIdList = this.getValidWriteIdList(dbName, tblName);
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(t.getTTable().getId());
            }
            GetPartitionNamesPsResponse res = this.getMSC().listPartitionNamesRequest(req);
            names = res.getNames();
        }
        catch (NoSuchObjectException nsoe) {
            return Lists.newArrayList();
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> getPartitions(Table tbl) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getPartitions");
        try {
            if (tbl.isPartitioned()) {
                List tParts;
                try {
                    GetPartitionsPsWithAuthRequest req = new GetPartitionsPsWithAuthRequest();
                    req.setTblName(tbl.getTableName());
                    req.setDbName(tbl.getDbName());
                    req.setUserName(Hive.getUserName());
                    req.setMaxParts((short)-1);
                    req.setGroupNames(this.getGroupNames());
                    if (AcidUtils.isTransactionalTable((Table)tbl)) {
                        ValidWriteIdList validWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                        req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                        req.setId(tbl.getTTable().getId());
                    }
                    GetPartitionsPsWithAuthResponse res = this.getMSC().listPartitionsWithAuthInfoRequest(req);
                    tParts = res.getPartitions();
                }
                catch (Exception e) {
                    LOG.error(StringUtils.stringifyException((Throwable)e));
                    throw new HiveException(e);
                }
                ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    parts.add(new Partition(tbl, tpart));
                }
                ArrayList<Partition> arrayList = parts;
                return arrayList;
            }
            List<Partition> list = Collections.singletonList(new Partition(tbl));
            return list;
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getPartitions", "HS2-cache");
        }
    }

    public Set<Partition> getAllPartitionsOf(Table tbl) throws HiveException {
        List tParts;
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet(new Partition(tbl));
        }
        try {
            tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getTableName(), (short)-1);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        LinkedHashSet<Partition> parts = new LinkedHashSet<Partition>(tParts.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
            parts.add(new Partition(tbl, tpart));
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getPartitions2");
        try {
            if (!tbl.isPartitioned()) {
                throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
            }
            List partialPvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partialPartSpec);
            List partitions = null;
            try {
                partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, limit, Hive.getUserName(), this.getGroupNames());
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
            for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
                qlPartitions.add(new Partition(tbl, p));
            }
            ArrayList<Partition> arrayList = qlPartitions;
            return arrayList;
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getPartitions2", "HS2-cache");
        }
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        return this.getPartitions(tbl, partialPartSpec, (short)-1);
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List<String> names = this.getPartitionNames(tbl.getDbName(), tbl.getTableName(), partialPartSpec, (short)-1);
        List<Partition> partitions = this.getPartitionsByNames(tbl, names);
        return partitions;
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames) throws HiveException {
        return this.getPartitionsByNames(tbl, partNames, false);
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames, boolean getColStats) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        int nParts = partNames.size();
        int nBatches = nParts / batchSize;
        try {
            GetPartitionsByNamesRequest request = new GetPartitionsByNamesRequest();
            request.setDb_name(MetaStoreUtils.prependCatalogToDbName((String)tbl.getDbName(), (Configuration)this.conf));
            request.setTbl_name(tbl.getTableName());
            request.setGet_col_stats(getColStats);
            request.setEngine("hive");
            if (AcidUtils.isTransactionalTable((Table)tbl)) {
                ValidWriteIdList vWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                request.setValidWriteIdList(vWriteIdList != null ? vWriteIdList.toString() : null);
                request.setId(tbl.getTTable().getId());
            }
            for (int i = 0; i < nBatches; ++i) {
                List<String> partNamesBatch = partNames.subList(i * batchSize, (i + 1) * batchSize);
                request.setNames(partNamesBatch);
                List tParts = this.getMSC().getPartitionsByNames(request).getPartitions();
                if (tParts == null) continue;
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
            if (nParts > nBatches * batchSize) {
                List<String> partNamesBatch = partNames.subList(nBatches * batchSize, nParts);
                request.setNames(partNamesBatch);
                List tParts = this.getMSC().getPartitionsByNames(request).getPartitions();
                if (tParts != null) {
                    for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                        partitions.add(new Partition(tbl, tpart));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return partitions;
    }

    public List<Partition> getPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List tParts = this.getMSC().listPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter, (short)-1);
        return Hive.convertFromMetastore(tbl, tParts);
    }

    private static List<Partition> convertFromMetastore(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws HiveException {
        if (partitions == null) {
            return new ArrayList<Partition>();
        }
        ArrayList<Partition> results = new ArrayList<Partition>(partitions.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tPart : partitions) {
            results.add(new Partition(tbl, tPart));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPartitionsByExpr(Table tbl, ExprNodeGenericFuncDesc expr, HiveConf conf, List<Partition> result) throws HiveException, TException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getPartitionsByExpr");
        try {
            assert (result != null);
            byte[] exprBytes = SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)expr);
            String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
            ArrayList<org.apache.hadoop.hive.metastore.api.Partition> msParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
            boolean hasUnknownParts = this.getMSC().listPartitionsByExpr(tbl.getDbName(), tbl.getTableName(), exprBytes, defaultPartitionName, (short)-1, msParts);
            result.addAll(Hive.convertFromMetastore(tbl, msParts));
            boolean bl = hasUnknownParts;
            return bl;
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getPartitionsByExpr", "HS2-cache");
        }
    }

    public int getNumPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        int numParts = this.getMSC().getNumPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter);
        return numParts;
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws HiveException {
        try {
            this.getMSC().validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RolePrincipalGrant> getRoleGrantInfoForPrincipal(String principalName, PrincipalType principalType) throws HiveException {
        try {
            GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
            GetRoleGrantsForPrincipalResponse resp = this.getMSC().get_role_grants_for_principal(req);
            return resp.getPrincipalGrants();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static void copyFiles(final HiveConf conf, final FileSystem destFs, FileStatus[] srcs, final FileSystem srcFs, final Path destf, final boolean isSrcLocal, final boolean isOverwrite, final List<Path> newFiles, boolean acidRename, boolean isManaged, boolean isCompactionTable) throws HiveException {
        HdfsUtils.HadoopFileStatus fullDestStatus;
        try {
            fullDestStatus = new HdfsUtils.HadoopFileStatus((Configuration)conf, destFs, destf);
        }
        catch (IOException e1) {
            throw new HiveException(e1);
        }
        if (!fullDestStatus.getFileStatus().isDirectory()) {
            throw new HiveException(destf + " is not a directory.");
        }
        LinkedList<Future<Pair<Path, Path>>> futures = new LinkedList<Future<Pair<Path, Path>>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
        int taskId = 0;
        Arrays.sort(srcs);
        String configuredOwner = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        for (FileStatus src : srcs) {
            Object[] files;
            if (src.isDirectory()) {
                try {
                    files = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                }
                catch (IOException e) {
                    if (null != pool) {
                        pool.shutdownNow();
                    }
                    throw new HiveException(e);
                }
            } else {
                files = new FileStatus[]{src};
            }
            if (isCompactionTable && HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE)) {
                try {
                    AcidUtils.OrcAcidVersion.writeVersionFile((Path)destf, (FileSystem)destFs);
                }
                catch (IOException e) {
                    if (null != pool) {
                        pool.shutdownNow();
                    }
                    throw new HiveException(e);
                }
            }
            final SessionState parentSession = SessionState.get();
            Arrays.sort(files);
            for (Object srcFile : files) {
                final Path srcP = srcFile.getPath();
                boolean needToCopy = Hive.needToCopy(conf, srcP, destf, srcFs, destFs, configuredOwner, isManaged);
                final boolean isRenameAllowed = !needToCopy && !isSrcLocal;
                final String msg = "Unable to move source " + srcP + " to destination " + destf;
                if (null == pool) {
                    try {
                        Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, acidRename ? taskId++ : -1);
                        if (null == newFiles) continue;
                        newFiles.add(destPath);
                        continue;
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg, "Failed to move: {}");
                    }
                }
                final int finalTaskId = acidRename ? taskId++ : -1;
                futures.add(pool.submit(new Callable<Pair<Path, Path>>(){

                    @Override
                    public Pair<Path, Path> call() throws HiveException {
                        SessionState.setCurrentSessionState((SessionState)parentSession);
                        try {
                            Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, finalTaskId);
                            if (null != newFiles) {
                                newFiles.add(destPath);
                            }
                            return Pair.of((Object)srcP, (Object)destPath);
                        }
                        catch (Exception e) {
                            throw Hive.getHiveException(e, msg);
                        }
                    }
                }));
            }
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    Pair pair = (Pair)future.get();
                    LOG.debug("Moved src: {}, to dest: {}", (Object)((Path)pair.getLeft()).toString(), (Object)((Path)pair.getRight()).toString());
                }
                catch (Exception e) {
                    throw Hive.handlePoolException(pool, e);
                }
            }
        }
    }

    private static boolean isSubDir(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, boolean isSrcLocal) {
        if (srcf == null) {
            LOG.debug("The source path is null for isSubDir method.");
            return false;
        }
        String fullF1 = Hive.getQualifiedPathWithoutSchemeAndAuthority(srcf, srcFs).toString() + "/";
        String fullF2 = Hive.getQualifiedPathWithoutSchemeAndAuthority(destf, destFs).toString() + "/";
        boolean isInTest = HiveConf.getBoolVar(srcFs.getConf(), HiveConf.ConfVars.HIVE_IN_TEST);
        LOG.debug("The source path is " + fullF1 + " and the destination path is " + fullF2);
        if (isInTest) {
            return fullF1.startsWith(fullF2);
        }
        String schemaSrcf = srcf.toUri().getScheme();
        String schemaDestf = destf.toUri().getScheme();
        if (schemaDestf == null && isSrcLocal) {
            LOG.debug("The source file is in the local while the dest not.");
            return false;
        }
        if (schemaSrcf != null && schemaDestf != null && !schemaSrcf.equals(schemaDestf)) {
            LOG.debug("The source path's schema is " + schemaSrcf + " and the destination path's schema is " + schemaDestf + ".");
            return false;
        }
        LOG.debug("The source path is " + fullF1 + " and the destination path is " + fullF2);
        return fullF1.startsWith(fullF2);
    }

    private static Path getQualifiedPathWithoutSchemeAndAuthority(Path srcf, FileSystem fs) {
        Path currentWorkingDir = fs.getWorkingDirectory();
        Path path = srcf.makeQualified(srcf.toUri(), currentWorkingDir);
        return ShimLoader.getHadoopShims().getPathWithoutSchemeAndAuthority(path);
    }

    private static String getPathName(int taskId) {
        return Utilities.replaceTaskId((String)"000000", (int)taskId) + "_0";
    }

    private static Path mvFile(HiveConf conf, FileSystem sourceFs, Path sourcePath, FileSystem destFs, Path destDirPath, boolean isSrcLocal, boolean isOverwrite, boolean isRenameAllowed, int taskId) throws IOException {
        String fullname = sourcePath.getName();
        String name = taskId == -1 ? FilenameUtils.getBaseName((String)sourcePath.getName()) : Hive.getPathName(taskId);
        String type = FilenameUtils.getExtension((String)sourcePath.getName());
        Path destFilePath = new Path(destDirPath, taskId == -1 ? fullname : name);
        int counter = 1;
        while (destFs.exists(destFilePath)) {
            if (isOverwrite) {
                destFs.delete(destFilePath, false);
                break;
            }
            destFilePath = new Path(destDirPath, name + "_copy_" + counter + (taskId == -1 && !type.isEmpty() ? "." + type : ""));
            ++counter;
        }
        if (isRenameAllowed) {
            destFs.rename(sourcePath, destFilePath);
        } else if (isSrcLocal) {
            destFs.copyFromLocalFile(sourcePath, destFilePath);
        } else {
            if (!FileUtils.copy(sourceFs, sourcePath, destFs, destFilePath, false, false, conf)) {
                LOG.error("Copy failed for source: " + sourcePath + " to destination: " + destFilePath);
                throw new IOException("File copy failed.");
            }
            try {
                if (!sourceFs.delete(sourcePath, true)) {
                    LOG.warn("Delete source failed for source: " + sourcePath + " during copy to destination: " + destFilePath);
                }
            }
            catch (Exception e) {
                LOG.warn("Delete source failed for source: " + sourcePath + " during copy to destination: " + destFilePath, (Throwable)e);
            }
        }
        return destFilePath;
    }

    public static void clearDestForSubDirSrc(HiveConf conf, Path dest, Path src, boolean isSrcLocal) throws IOException {
        FileSystem destFS = dest.getFileSystem((Configuration)conf);
        FileSystem srcFS = src.getFileSystem((Configuration)conf);
        if (Hive.isSubDir(src, dest, srcFS, destFS, isSrcLocal)) {
            FileStatus[] existingFiles;
            Path fullDestPath;
            Path fullSrcPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(src, srcFS);
            if (fullSrcPath.equals((Object)(fullDestPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(dest, destFS)))) {
                return;
            }
            Path parent = fullSrcPath;
            while (!parent.getParent().equals((Object)fullDestPath)) {
                parent = parent.getParent();
            }
            for (FileStatus fileStatus : existingFiles = destFS.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.getPath().getName().equals(parent.getName())) continue;
                destFS.delete(fileStatus.getPath(), true);
            }
        }
    }

    public static void listNewFilesRecursively(FileSystem destFs, Path dest, List<Path> newFiles) throws HiveException {
        try {
            for (FileStatus fileStatus : destFs.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.isDirectory()) {
                    Hive.listNewFilesRecursively(destFs, fileStatus.getPath(), newFiles);
                    continue;
                }
                newFiles.add(fileStatus.getPath());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get source file statuses", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
    }

    public void recycleDirToCmPath(Path dataPath, boolean isPurge) throws HiveException {
        try {
            CmRecycleRequest request = new CmRecycleRequest(dataPath.toString(), isPurge);
            this.getSynchronizedMSC().recycleDirToCmPath(request);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static void deleteAndRename(FileSystem destFs, Path destFile, FileStatus srcStatus, Path destPath) throws IOException {
        try {
            destFs.delete(destFile);
            LOG.info("Deleted destination file" + destFile.toUri());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (!destFs.rename(srcStatus.getPath(), destFile)) {
            throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest:" + destPath + " returned false");
        }
    }

    public static boolean moveFile(HiveConf conf, Path srcf, final Path destf, boolean replace, boolean isSrcLocal, boolean isManaged) throws HiveException {
        FileSystem srcFs;
        FileSystem destFs;
        try {
            destFs = destf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get dest fs", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get src fs", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
        String configuredOwner = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        boolean srcIsSubDirOfDest = Hive.isSubDir(srcf, destf, srcFs, destFs, isSrcLocal);
        boolean destIsSubDirOfSrc = Hive.isSubDir(destf, srcf, destFs, srcFs, false);
        String msg = "Unable to move source " + srcf + " to destination " + destf;
        try {
            if (replace) {
                try {
                    if (replace && !srcIsSubDirOfDest) {
                        destFs.delete(destf, true);
                        LOG.debug("The path " + destf.toString() + " is deleted");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            final SessionState parentSession = SessionState.get();
            if (isSrcLocal) {
                destFs.copyFromLocalFile(srcf, destf);
                return true;
            }
            if (Hive.needToCopy(conf, srcf, destf, srcFs, destFs, configuredOwner, isManaged)) {
                LOG.debug("Copying source " + srcf + " to " + destf + " because HDFS encryption zones are different.");
                return FileUtils.copy(srcf.getFileSystem((Configuration)conf), srcf, destf.getFileSystem((Configuration)conf), destf, true, replace, conf);
            }
            if (srcIsSubDirOfDest || destIsSubDirOfSrc) {
                ExecutorService pool;
                FileStatus[] srcs = destFs.listStatus(srcf, FileUtils.HIDDEN_FILES_PATH_FILTER);
                LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
                ExecutorService executorService = pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
                if (destIsSubDirOfSrc && !destFs.exists(destf)) {
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Creating " + destf);
                    }
                    destFs.mkdirs(destf);
                }
                for (final FileStatus srcStatus : srcs) {
                    final Path destFile = new Path(destf, srcStatus.getPath().getName());
                    final String poolMsg = "Unable to move source " + srcStatus.getPath() + " to destination " + destFile;
                    if (null == pool) {
                        Hive.deleteAndRename(destFs, destFile, srcStatus, destf);
                        continue;
                    }
                    futures.add(pool.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws HiveException {
                            SessionState.setCurrentSessionState((SessionState)parentSession);
                            try {
                                Hive.deleteAndRename(destFs, destFile, srcStatus, destf);
                            }
                            catch (Exception e) {
                                throw Hive.getHiveException(e, poolMsg);
                            }
                            return null;
                        }
                    }));
                }
                if (null != pool) {
                    pool.shutdown();
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            throw Hive.handlePoolException(pool, e);
                        }
                    }
                }
                return true;
            }
            return destFs.rename(srcf, destf);
        }
        catch (Exception e) {
            throw Hive.getHiveException(e, msg);
        }
    }

    private static HiveException getHiveException(Exception e, String msg) {
        return Hive.getHiveException(e, msg, null);
    }

    private static HiveException handlePoolException(ExecutorService pool, Exception e) {
        HiveException he = null;
        if (e instanceof HiveException) {
            he = (HiveException)e;
            if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
                if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                    LOG.error("Failed to move: {}", (Object)he.getMessage());
                } else {
                    LOG.error("Failed to move: {}", (Object)he.getRemoteErrorMsg());
                }
            }
        } else {
            LOG.error("Failed to move: {}", (Object)e.getMessage());
            he = new HiveException(e.getCause());
        }
        pool.shutdownNow();
        return he;
    }

    private static HiveException getHiveException(Exception e, String msg, String logMsg) {
        String hiveErrMsg = null;
        hiveErrMsg = e.getMessage() != null ? String.format("%s%s%s", msg, ": ", Splitter.on(System.getProperty("line.separator")).split(e.getMessage()).iterator().next()) : msg;
        ErrorMsg errorMsg = ErrorMsg.getErrorMsg(e);
        if (logMsg != null) {
            LOG.info(String.format(logMsg, e.getMessage()));
        }
        if (errorMsg != ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
            return new HiveException((Throwable)e, e.getMessage(), errorMsg, hiveErrMsg);
        }
        return new HiveException(msg, e);
    }

    private static boolean needToCopy(HiveConf conf, Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, String configuredOwner, boolean isManaged) throws HiveException {
        block12: {
            if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                return true;
            }
            if (isManaged && !configuredOwner.isEmpty() && srcFs instanceof DistributedFileSystem) {
                try {
                    FileStatus srcs = srcFs.getFileStatus(srcf);
                    String runningUser = UserGroupInformation.getLoginUser().getShortUserName();
                    boolean isOwned = FileUtils.isOwnerOfFileHierarchy(srcFs, srcs, configuredOwner, false);
                    if (configuredOwner.equals(runningUser)) {
                        if (!isOwned || !FileUtils.isActionPermittedForFileHierarchy(srcFs, srcs, configuredOwner, FsAction.WRITE, false)) {
                            return true;
                        }
                        break block12;
                    }
                    if (!isOwned) {
                        throw new HiveException("Load Data failed for " + srcf + " as the file is not owned by " + configuredOwner + " and load data is also not ran as " + configuredOwner);
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new HiveException("Could not fetch FileStatus for source file");
                }
                catch (HiveException e) {
                    throw new HiveException(e);
                }
                catch (Exception e) {
                    throw new HiveException(" Failed in looking up Permissions on file + " + srcf);
                }
            }
        }
        if (!DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf)) {
            return false;
        }
        HadoopShims.HdfsEncryptionShim srcHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(srcFs, conf);
        HadoopShims.HdfsEncryptionShim destHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(destFs, conf);
        try {
            return srcHdfsEncryptionShim != null && destHdfsEncryptionShim != null && (srcHdfsEncryptionShim.isPathEncrypted(srcf) || destHdfsEncryptionShim.isPathEncrypted(destf)) && !srcHdfsEncryptionShim.arePathsOnSameEncryptionZone(srcf, destf, destHdfsEncryptionShim);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    protected static void copyFiles(HiveConf conf, Path srcf, Path destf, FileSystem fs, boolean isSrcLocal, boolean isAcidIUD, boolean isOverwrite, List<Path> newFiles, boolean isBucketed, boolean isFullAcidTable, boolean isManaged, boolean isCompactionTable) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        try {
            if (!fs.exists(destf)) {
                FileUtils.mkdir(fs, destf, conf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
            srcs = srcFs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase. " + e.getMessage(), e);
        }
        if (srcs == null) {
            LOG.info("No sources specified to move: " + srcf);
            return;
        }
        if (isAcidIUD) {
            Hive.moveAcidFiles(srcFs, srcs, destf, newFiles);
        } else {
            Hive.copyFiles(conf, fs, srcs, srcFs, destf, isSrcLocal, isOverwrite, newFiles, isFullAcidTable && !isBucketed, isManaged, isCompactionTable);
        }
    }

    public static void moveAcidFiles(FileSystem fs, FileStatus[] stats, Path dst, List<Path> newFiles) throws HiveException {
        HashSet<Path> createdDeltaDirs = new HashSet<Path>();
        for (FileStatus stat : stats) {
            Path srcPath = stat.getPath();
            LOG.debug("Acid move Looking for original buckets in " + srcPath);
            FileStatus[] origBucketStats = null;
            try {
                origBucketStats = fs.listStatus(srcPath, AcidUtils.originalBucketFilter);
                if (origBucketStats == null || origBucketStats.length == 0) {
                    FileStatus[] unionSubdirs = fs.globStatus(new Path(srcPath, "HIVE_UNION_SUBDIR_[0-9]*"));
                    ArrayList buckets = new ArrayList();
                    for (FileStatus unionSubdir : unionSubdirs) {
                        Collections.addAll(buckets, fs.listStatus(unionSubdir.getPath(), AcidUtils.originalBucketFilter));
                    }
                    origBucketStats = buckets.toArray(new FileStatus[buckets.size()]);
                }
            }
            catch (IOException e) {
                String msg = "Unable to look for bucket files in src path " + srcPath.toUri().toString();
                LOG.error(msg);
                throw new HiveException(msg, e);
            }
            LOG.debug("Acid move found " + origBucketStats.length + " original buckets");
            for (FileStatus origBucketStat : origBucketStats) {
                Path origBucketPath = origBucketStat.getPath();
                Hive.moveAcidFiles("delta_", AcidUtils.deltaFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
                Hive.moveAcidFiles("delete_delta_", AcidUtils.deleteEventDeltaDirFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
                Hive.moveAcidFiles("base_", AcidUtils.baseFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
            }
        }
    }

    private static void moveAcidFiles(String deltaFileType, PathFilter pathFilter, FileSystem fs, Path dst, Path origBucketPath, Set<Path> createdDeltaDirs, List<Path> newFiles) throws HiveException {
        LOG.debug("Acid move looking for " + deltaFileType + " files in bucket " + origBucketPath);
        FileStatus[] deltaStats = null;
        try {
            deltaStats = fs.listStatus(origBucketPath, pathFilter);
        }
        catch (IOException e) {
            throw new HiveException("Unable to look for " + deltaFileType + " files in original bucket " + origBucketPath.toUri().toString(), e);
        }
        LOG.debug("Acid move found " + deltaStats.length + " " + deltaFileType + " files");
        for (FileStatus deltaStat : deltaStats) {
            Path deltaPath = deltaStat.getPath();
            Path deltaDest = new Path(dst, deltaPath.getName());
            try {
                if (!createdDeltaDirs.contains(deltaDest)) {
                    try {
                        if (fs.mkdirs(deltaDest)) {
                            try {
                                fs.rename(AcidUtils.OrcAcidVersion.getVersionFilePath((Path)deltaStat.getPath()), AcidUtils.OrcAcidVersion.getVersionFilePath((Path)deltaDest));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        createdDeltaDirs.add(deltaDest);
                    }
                    catch (IOException swallowIt) {
                        LOG.info("Unable to create " + deltaFileType + " directory " + deltaDest + ", assuming it already exists: " + swallowIt.getMessage());
                    }
                }
                FileStatus[] bucketStats = fs.listStatus(deltaPath, AcidUtils.bucketFileFilter);
                LOG.debug("Acid move found " + bucketStats.length + " bucket files");
                for (FileStatus bucketStat : bucketStats) {
                    Path bucketSrc = bucketStat.getPath();
                    Path bucketDest = new Path(deltaDest, bucketSrc.getName());
                    String msg = "Unable to move source " + bucketSrc + " to destination " + bucketDest;
                    LOG.info("Moving bucket " + bucketSrc.toUri().toString() + " to " + bucketDest.toUri().toString());
                    try {
                        fs.rename(bucketSrc, bucketDest);
                        if (newFiles == null) continue;
                        newFiles.add(bucketDest);
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg);
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException("Error moving acid files " + e.getMessage(), e);
            }
        }
    }

    private void replaceFiles(Path tablePath, Path srcf, Path destf, Path oldPath, HiveConf conf, boolean isSrcLocal, boolean purge, List<Path> newFiles, PathFilter deletePathFilter, boolean isNeedRecycle, boolean isManaged, boolean isInsertOverwrite) throws HiveException {
        try {
            FileStatus[] srcs;
            FileSystem destFs = destf.getFileSystem((Configuration)conf);
            try {
                FileSystem srcFs = srcf.getFileSystem((Configuration)conf);
                srcs = srcFs.globStatus(srcf);
            }
            catch (IOException e) {
                throw new HiveException("Getting globStatus " + srcf.toString(), e);
            }
            if (oldPath != null && (srcs != null || isInsertOverwrite)) {
                this.deleteOldPathForReplace(destf, oldPath, conf, purge, deletePathFilter, isNeedRecycle);
            }
            if (srcs == null) {
                LOG.info("No sources specified to move: " + srcf);
                return;
            }
            boolean destfExist = FileUtils.mkdir(destFs, destf, conf);
            if (!destfExist) {
                throw new IOException("Directory " + destf.toString() + " does not exist and could not be created.");
            }
            if (srcs.length == 1 && srcs[0].isDirectory()) {
                if (!Hive.moveFile(conf, srcs[0].getPath(), destf, true, isSrcLocal, isManaged)) {
                    throw new IOException("Error moving: " + srcf + " into: " + destf);
                }
                if (null != newFiles) {
                    Hive.listNewFilesRecursively(destFs, destf, newFiles);
                }
            } else {
                for (FileStatus src : srcs) {
                    Path destFile = new Path(destf, src.getPath().getName());
                    if (!Hive.moveFile(conf, src.getPath(), destFile, true, isSrcLocal, isManaged)) {
                        throw new IOException("Error moving: " + srcf + " into: " + destf);
                    }
                    if (null == newFiles) continue;
                    newFiles.add(destFile);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    private void deleteOldPathForReplace(Path destPath, Path oldPath, HiveConf conf, boolean purge, PathFilter pathFilter, boolean isNeedRecycle) throws HiveException {
        Utilities.FILE_OP_LOGGER.debug("Deleting old paths for replace in " + destPath + " and old path " + oldPath);
        boolean isOldPathUnderDestf = false;
        try {
            FileSystem oldFs = oldPath.getFileSystem((Configuration)conf);
            FileSystem destFs = destPath.getFileSystem((Configuration)conf);
            isOldPathUnderDestf = Hive.isSubDir(oldPath, destPath, oldFs, destFs, false);
            if (isOldPathUnderDestf) {
                this.cleanUpOneDirectoryForReplace(oldPath, oldFs, pathFilter, conf, purge, isNeedRecycle);
            }
        }
        catch (IOException e) {
            if (isOldPathUnderDestf) {
                throw new HiveException("Directory " + oldPath.toString() + " could not be cleaned up.", e);
            }
            LOG.warn("Directory " + oldPath.toString() + " cannot be cleaned: " + e, (Throwable)e);
        }
    }

    public void cleanUpOneDirectoryForReplace(Path path, FileSystem fs, PathFilter pathFilter, HiveConf conf, boolean purge, boolean isNeedRecycle) throws IOException, HiveException {
        FileStatus[] statuses;
        if (isNeedRecycle && conf.getBoolVar(HiveConf.ConfVars.REPLCMENABLED)) {
            this.recycleDirToCmPath(path, purge);
        }
        if ((statuses = fs.listStatus(path, pathFilter)) == null || statuses.length == 0) {
            return;
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            String s = "Deleting files under " + path + " for replace: ";
            for (FileStatus file : statuses) {
                s = s + file.getPath().getName() + ", ";
            }
            Utilities.FILE_OP_LOGGER.trace(s);
        }
        if (!Hive.trashFiles(fs, statuses, conf, purge)) {
            throw new HiveException("Old path " + path + " has not been cleaned up.");
        }
    }

    public static boolean trashFiles(final FileSystem fs, FileStatus[] statuses, final Configuration conf, final boolean purge) throws IOException {
        boolean result = true;
        if (statuses == null || statuses.length == 0) {
            return false;
        }
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Delete-Thread-%d").build()) : null;
        final SessionState parentSession = SessionState.get();
        for (final FileStatus status : statuses) {
            if (null == pool) {
                result &= FileUtils.moveToTrash(fs, status.getPath(), conf, purge);
                continue;
            }
            futures.add(pool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SessionState.setCurrentSessionState((SessionState)parentSession);
                    return FileUtils.moveToTrash(fs, status.getPath(), conf, purge);
                }
            }));
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    result &= ((Boolean)future.get()).booleanValue();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Failed to delete: ", (Throwable)e);
                    pool.shutdownNow();
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static boolean isHadoop1() {
        return ShimLoader.getMajorVersion().startsWith("0.20");
    }

    public List<Partition> exchangeTablePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws HiveException {
        try {
            List partitions = this.getMSC().exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
            return Hive.convertFromMetastore(this.getTable(destDb, destinationTableName), partitions);
        }
        catch (Exception ex) {
            LOG.error(StringUtils.stringifyException((Throwable)ex));
            throw new HiveException(ex);
        }
    }

    private IMetaStoreClient createMetaStoreClient(boolean allowEmbedded) throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                HiveStorageHandler storageHandler = Hive.this.createStorageHandler(tbl);
                return storageHandler == null ? null : storageHandler.getMetaHook();
            }
        };
        if (this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            return new SessionHiveMetaStoreClient(this.conf, hookLoader, allowEmbedded);
        }
        return RetryingMetaStoreClient.getProxy((Configuration)this.conf, (HiveMetaHookLoader)hookLoader, this.metaCallTimeMap, (String)SessionHiveMetaStoreClient.class.getName(), (boolean)allowEmbedded);
    }

    @Nullable
    private HiveStorageHandler createStorageHandler(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
        try {
            if (tbl == null) {
                return null;
            }
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler(this.conf, (String)tbl.getParameters().get("storage_handler"));
            return storageHandler;
        }
        catch (HiveException ex) {
            LOG.error(StringUtils.stringifyException((Throwable)ex));
            throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized SynchronizedMetaStoreClient getSynchronizedMSC() throws MetaException {
        if (this.syncMetaStoreClient == null) {
            this.syncMetaStoreClient = new SynchronizedMetaStoreClient(this.getMSC(true, false));
        }
        return this.syncMetaStoreClient;
    }

    @VisibleForTesting
    public synchronized void setMSC(IMetaStoreClient client) throws MetaException {
        this.metaStoreClient = client;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC() throws MetaException {
        return this.getMSC(true, false);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC(boolean allowEmbedded, boolean forceCreate) throws MetaException {
        if (this.metaStoreClient == null || forceCreate) {
            try {
                this.owner = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error getting current user: " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw new MetaException(msg + "\n" + StringUtils.stringifyException((Throwable)e));
            }
            try {
                this.metaStoreClient = this.createMetaStoreClient(allowEmbedded);
            }
            catch (RuntimeException ex) {
                for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof JDODataStoreException) || t.getMessage() == null || !t.getMessage().contains("autoCreate")) continue;
                    LOG.error("Cannot initialize metastore due to autoCreate error", t);
                    throw new SchemaException("Hive metastore database is not initialized. Please use schematool (e.g. ./schematool -initSchema -dbType ...) to create the schema. If needed, don't forget to include the option to auto-create the underlying database in your JDBC connection string (e.g. ?createDatabaseIfNotExist=true for mysql)");
                }
                throw ex;
            }
            String metaStoreUris = this.conf.getVar(HiveConf.ConfVars.METASTOREURIS);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)metaStoreUris)) {
                this.metaStoreClient = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)this.metaStoreClient);
            }
        }
        return this.metaStoreClient;
    }

    private static String getUserName() {
        return SessionState.getUserFromAuthenticator();
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return HiveMetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws HiveException {
        try {
            ColumnStatistics colStat = (ColumnStatistics)request.getColStats().get(0);
            ColumnStatisticsDesc statsDesc = colStat.getStatsDesc();
            if (request.getWriteId() <= 0L || request.getValidWriteIdList() == null) {
                Table tbl = this.getTable(statsDesc.getDbName(), statsDesc.getTableName());
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl, (boolean)true);
                request.setValidWriteIdList(tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
                request.setWriteId(tableSnapshot != null ? tableSnapshot.getWriteId() : 0L);
            }
            return this.getMSC().setPartitionColumnStatistics(request);
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, boolean checkTransactional) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getTableColumnStatistics");
        List retv = null;
        try {
            Object tbl;
            if (checkTransactional) {
                tbl = this.getTable(dbName, tableName);
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl);
                retv = this.getMSC().getTableColumnStatistics(dbName, tableName, colNames, this.conf.getEngine().getStatsField(), tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
            } else {
                retv = this.getMSC().getTableColumnStatistics(dbName, tableName, colNames, this.conf.getEngine().getStatsField());
            }
            tbl = retv;
            return tbl;
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getTableColumnStatistics", "HS2-cache");
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, boolean checkTransactional) throws HiveException {
        String writeIdList = null;
        try {
            if (checkTransactional) {
                Table tbl = this.getTable(dbName, tableName);
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl);
                writeIdList = tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null;
            }
            return this.getMSC().getPartitionColumnStatistics(dbName, tableName, partNames, colNames, this.conf.getEngine().getStatsField(), writeIdList);
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames, boolean checkTransactional) {
        return this.getAggrColStatsFor(dbName, tblName, colNames, partNames, checkTransactional, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames, boolean checkTransactional, long originalRowCount, long prunedRowCount) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getAggrColStatsFor");
        String writeIdList = null;
        try {
            if (checkTransactional) {
                Table tbl = this.getTable(dbName, tblName);
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, (Table)tbl);
                writeIdList = tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null;
                AggrStats aggrStats = this.getMSC().getAggrColStatsFor(dbName, tblName, colNames, partNames, this.conf.getEngine().getStatsField(), writeIdList);
                return aggrStats;
            }
            if (this.conf.getEngine() == HiveConf.Engine.IMPALA) {
                double selectivity;
                List colStats = this.getMSC().getTableColumnStatistics(dbName, tblName, colNames, this.conf.getEngine().getStatsField());
                double d = selectivity = originalRowCount == -1L ? 1.0 : (double)prunedRowCount / (double)originalRowCount;
                if (selectivity != 1.0) {
                    ArrayList<ColumnStatisticsObj> adjustedColStats = new ArrayList<ColumnStatisticsObj>();
                    for (ColumnStatisticsObj statsObj : colStats) {
                        adjustedColStats.add(this.getAdjustedColStats(statsObj, selectivity, prunedRowCount));
                    }
                    AggrStats aggrStats = new AggrStats(adjustedColStats, (long)partNames.size());
                    return aggrStats;
                }
                AggrStats aggrStats = new AggrStats(colStats, (long)partNames.size());
                return aggrStats;
            }
            AggrStats colStats = this.getMSC().getAggrColStatsFor(dbName, tblName, colNames, partNames, this.conf.getEngine().getStatsField(), null);
            return colStats;
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            AggrStats aggrStats = new AggrStats(new ArrayList(), 0L);
            return aggrStats;
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getAggrColStatsFor", "HS2-cache");
        }
    }

    private ColumnStatisticsObj getAdjustedColStats(ColumnStatisticsObj statsObj, double selectivity, long prunedRowCount) throws HiveException {
        ColumnStatisticsData._Fields type = (ColumnStatisticsData._Fields)statsObj.getStatsData().getSetField();
        ColumnStatisticsObj statsObjCopy = new ColumnStatisticsObj(statsObj);
        switch (type) {
            case BOOLEAN_STATS: {
                BooleanColumnStatsData boolStats = statsObjCopy.getStatsData().getBooleanStats();
                if (boolStats.isSetNumNulls()) {
                    boolStats.setNumNulls((long)(selectivity * (double)boolStats.getNumNulls()));
                }
                if (boolStats.isSetNumFalses()) {
                    boolStats.setNumFalses((long)(selectivity * (double)boolStats.getNumFalses()));
                }
                if (!boolStats.isSetNumTrues()) break;
                boolStats.setNumTrues((long)(selectivity * (double)boolStats.getNumTrues()));
                break;
            }
            case LONG_STATS: {
                LongColumnStatsData longStats = statsObjCopy.getStatsData().getLongStats();
                if (longStats.isSetNumNulls()) {
                    longStats.setNumNulls((long)(selectivity * (double)longStats.getNumNulls()));
                }
                if (!longStats.isSetNumDVs()) break;
                longStats.setNumDVs(Math.min(longStats.getNumDVs(), prunedRowCount));
                break;
            }
            case DOUBLE_STATS: {
                DoubleColumnStatsData doubleStats = statsObjCopy.getStatsData().getDoubleStats();
                if (doubleStats.isSetNumNulls()) {
                    doubleStats.setNumNulls((long)(selectivity * (double)doubleStats.getNumNulls()));
                }
                if (!doubleStats.isSetNumDVs()) break;
                doubleStats.setNumDVs(Math.min(doubleStats.getNumDVs(), prunedRowCount));
                break;
            }
            case STRING_STATS: {
                StringColumnStatsData stringStats = statsObjCopy.getStatsData().getStringStats();
                if (stringStats.isSetNumNulls()) {
                    stringStats.setNumNulls((long)(selectivity * (double)stringStats.getNumNulls()));
                }
                if (!stringStats.isSetNumDVs()) break;
                stringStats.setNumDVs(Math.min(stringStats.getNumDVs(), prunedRowCount));
                break;
            }
            case BINARY_STATS: {
                BinaryColumnStatsData binaryStats = statsObjCopy.getStatsData().getBinaryStats();
                if (!binaryStats.isSetNumNulls()) break;
                binaryStats.setNumNulls((long)(selectivity * (double)binaryStats.getNumNulls()));
                break;
            }
            case DECIMAL_STATS: {
                DecimalColumnStatsData decimalStats = statsObjCopy.getStatsData().getDecimalStats();
                if (decimalStats.isSetNumNulls()) {
                    decimalStats.setNumNulls((long)(selectivity * (double)decimalStats.getNumNulls()));
                }
                if (!decimalStats.isSetNumDVs()) break;
                decimalStats.setNumDVs(Math.min(decimalStats.getNumDVs(), prunedRowCount));
                break;
            }
            case DATE_STATS: {
                DateColumnStatsData dateStats = statsObjCopy.getStatsData().getDateStats();
                if (dateStats.isSetNumNulls()) {
                    dateStats.setNumNulls((long)(selectivity * (double)dateStats.getNumNulls()));
                }
                if (!dateStats.isSetNumDVs()) break;
                dateStats.setNumDVs(Math.min(dateStats.getNumDVs(), prunedRowCount));
                break;
            }
            default: {
                throw new HiveException("Unsupported type");
            }
        }
        return statsObjCopy;
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws HiveException {
        try {
            return this.getMSC().deleteTableColumnStatistics(dbName, tableName, colName, "hive");
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws HiveException {
        try {
            return this.getMSC().deletePartitionColumnStatistics(dbName, tableName, partName, colName, "hive");
        }
        catch (Exception e) {
            LOG.debug(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Table newTable(String tableName) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        return new Table(names[0], names[1]);
    }

    public String getDelegationToken(String owner, String renewer) throws HiveException {
        try {
            return this.getMSC().getDelegationToken(owner, renewer);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void cancelDelegationToken(String tokenStrForm) throws HiveException {
        try {
            this.getMSC().cancelDelegationToken(tokenStrForm);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    @Deprecated
    public void compact(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        this.compact2(dbname, tableName, partName, compactType, tblproperties);
    }

    public CompactionResponse compact2(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        try {
            CompactionType cr = null;
            if ("major".equalsIgnoreCase(compactType)) {
                cr = CompactionType.MAJOR;
            } else if ("minor".equalsIgnoreCase(compactType)) {
                cr = CompactionType.MINOR;
            } else {
                throw new RuntimeException("Unknown compaction type " + compactType);
            }
            return this.getMSC().compact2(dbname, tableName, partName, cr, tblproperties);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public ShowCompactResponse showCompactions() throws HiveException {
        try {
            return this.getMSC().showCompactions();
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public GetOpenTxnsInfoResponse showTransactions() throws HiveException {
        try {
            return this.getMSC().showTxns();
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void abortTransactions(List<Long> txnids) throws HiveException {
        try {
            this.getMSC().abortTxns(txnids);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createFunction(org.apache.hadoop.hive.metastore.api.Function func) throws HiveException {
        try {
            this.getMSC().createFunction(func);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void alterFunction(String dbName, String funcName, org.apache.hadoop.hive.metastore.api.Function newFunction) throws HiveException {
        try {
            this.getMSC().alterFunction(dbName, funcName, newFunction);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void dropFunction(String dbName, String funcName) throws HiveException {
        try {
            this.getMSC().dropFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Function getFunction(String dbName, String funcName) throws HiveException {
        try {
            return this.getMSC().getFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Function> getAllFunctions() throws HiveException {
        try {
            List functions = this.getMSC().getAllFunctions().getFunctions();
            return functions == null ? new ArrayList() : functions;
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws HiveException {
        try {
            return this.getMSC().getFunctions(dbName, pattern);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void setMetaConf(String propName, String propValue) throws HiveException {
        try {
            this.getMSC().setMetaConf(propName, propValue);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public String getMetaConf(String propName) throws HiveException {
        try {
            return this.getMSC().getMetaConf(propName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void clearMetaCallTiming() {
        this.metaCallTimeMap.clear();
    }

    public static ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn("Caught exception attempting to write metadata call information " + he, (Throwable)he);
            return null;
        }
    }

    public ImmutableMap<String, Long> dumpAndClearMetaCallTiming(String phase) {
        boolean phaseInfoLogged = false;
        if (LOG.isInfoEnabled()) {
            phaseInfoLogged = this.logDumpPhase(phase);
            LOG.info("Total time spent in each metastore function (ms): " + this.metaCallTimeMap);
            for (Map.Entry<String, Long> callTime : this.metaCallTimeMap.entrySet()) {
                if (callTime.getValue() <= 1000L) continue;
                if (!phaseInfoLogged) {
                    phaseInfoLogged = this.logDumpPhase(phase);
                }
                LOG.info("Total time spent in this metastore function was greater than 1000ms : " + callTime);
            }
        }
        ImmutableMap<String, Long> result = ImmutableMap.copyOf(this.metaCallTimeMap);
        this.metaCallTimeMap.clear();
        return result;
    }

    private boolean logDumpPhase(String phase) {
        LOG.info("Dumping metastore api call timing information for : " + phase + " phase");
        return true;
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            return this.getMSC().getFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws HiveException {
        try {
            return this.getMSC().getFileMetadataBySarg(fileIds, sarg, doGetFooters);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void clearFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            this.getMSC().clearFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws HiveException {
        try {
            this.getMSC().putFileMetadata(fileIds, metadata);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws HiveException {
        try {
            boolean willCache = this.getMSC().cacheFileMetadata(dbName, tableName, partName, allParts);
            if (!willCache) {
                throw new HiveException("Caching file metadata is not supported by metastore or for this file format");
            }
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropConstraint(dbName, tableName, constraintName);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLPrimaryKey> getPrimaryKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getPrimaryKeys(new PrimaryKeysRequest(dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLForeignKey> getForeignKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getForeignKeys(new ForeignKeysRequest(null, null, dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLUniqueConstraint> getUniqueConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getUniqueConstraints(new UniqueConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLNotNullConstraint> getNotNullConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLDefaultConstraint> getDefaultConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLCheckConstraint> getCheckConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrimaryKeyInfo getPrimaryKeys(String dbName, String tblName) throws HiveException {
        return this.getPrimaryKeys(dbName, tblName, false);
    }

    public PrimaryKeyInfo getReliablePrimaryKeys(String dbName, String tblName) throws HiveException {
        return this.getPrimaryKeys(dbName, tblName, true);
    }

    private PrimaryKeyInfo getPrimaryKeys(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getPrimaryKeys");
        try {
            List primaryKeys = this.getMSC().getPrimaryKeys(new PrimaryKeysRequest(dbName, tblName));
            if (onlyReliable && primaryKeys != null && !primaryKeys.isEmpty()) {
                primaryKeys = primaryKeys.stream().filter(pk -> pk.isRely_cstr()).collect(Collectors.toList());
            }
            PrimaryKeyInfo primaryKeyInfo = new PrimaryKeyInfo(primaryKeys, tblName, dbName);
            return primaryKeyInfo;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getPrimaryKeys", "HS2-cache");
        }
    }

    public ForeignKeyInfo getForeignKeys(String dbName, String tblName) throws HiveException {
        return this.getForeignKeys(dbName, tblName, false);
    }

    public ForeignKeyInfo getReliableForeignKeys(String dbName, String tblName) throws HiveException {
        return this.getForeignKeys(dbName, tblName, true);
    }

    private ForeignKeyInfo getForeignKeys(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getForeignKeys");
        try {
            List foreignKeys = this.getMSC().getForeignKeys(new ForeignKeysRequest(null, null, dbName, tblName));
            if (onlyReliable && foreignKeys != null && !foreignKeys.isEmpty()) {
                foreignKeys = foreignKeys.stream().filter(fk -> fk.isRely_cstr()).collect(Collectors.toList());
            }
            ForeignKeyInfo foreignKeyInfo = new ForeignKeyInfo(foreignKeys, tblName, dbName);
            return foreignKeyInfo;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getForeignKeys", "HS2-cache");
        }
    }

    public UniqueConstraint getUniqueConstraints(String dbName, String tblName) throws HiveException {
        return this.getUniqueConstraints(dbName, tblName, false);
    }

    public UniqueConstraint getReliableUniqueConstraints(String dbName, String tblName) throws HiveException {
        return this.getUniqueConstraints(dbName, tblName, true);
    }

    private UniqueConstraint getUniqueConstraints(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getUniqueConstraints");
        try {
            List uniqueConstraints = this.getMSC().getUniqueConstraints(new UniqueConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (onlyReliable && uniqueConstraints != null && !uniqueConstraints.isEmpty()) {
                uniqueConstraints = uniqueConstraints.stream().filter(uk -> uk.isRely_cstr()).collect(Collectors.toList());
            }
            UniqueConstraint uniqueConstraint = new UniqueConstraint(uniqueConstraints, tblName, dbName);
            return uniqueConstraint;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getUniqueConstraints", "HS2-cache");
        }
    }

    public NotNullConstraint getNotNullConstraints(String dbName, String tblName) throws HiveException {
        return this.getNotNullConstraints(dbName, tblName, false);
    }

    public NotNullConstraint getReliableNotNullConstraints(String dbName, String tblName) throws HiveException {
        return this.getNotNullConstraints(dbName, tblName, true);
    }

    public NotNullConstraint getEnabledNotNullConstraints(String dbName, String tblName) throws HiveException {
        try {
            List notNullConstraints = this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                notNullConstraints = notNullConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new NotNullConstraint(notNullConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public CheckConstraint getEnabledCheckConstraints(String dbName, String tblName) throws HiveException {
        try {
            List checkConstraints = this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                checkConstraints = checkConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new CheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public DefaultConstraint getEnabledDefaultConstraints(String dbName, String tblName) throws HiveException {
        try {
            List defaultConstraints = this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
                defaultConstraints = defaultConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new DefaultConstraint(defaultConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private NotNullConstraint getNotNullConstraints(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.CLASS_NAME, "getNotNullConstraints");
        try {
            List notNullConstraints = this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (onlyReliable && notNullConstraints != null && !notNullConstraints.isEmpty()) {
                notNullConstraints = notNullConstraints.stream().filter(nnc -> nnc.isRely_cstr()).collect(Collectors.toList());
            }
            NotNullConstraint notNullConstraint = new NotNullConstraint(notNullConstraints, tblName, dbName);
            return notNullConstraint;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            perfLogger.PerfLogEnd(this.CLASS_NAME, "getNotNullConstraints", "HS2-cache");
        }
    }

    public DefaultConstraint getDefaultConstraints(String dbName, String tblName) throws HiveException {
        try {
            List defaultConstraints = this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
                defaultConstraints = defaultConstraints.stream().collect(Collectors.toList());
            }
            return new DefaultConstraint(defaultConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public CheckConstraint getCheckConstraints(String dbName, String tblName) throws HiveException {
        try {
            List checkConstraints = this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                checkConstraints = checkConstraints.stream().collect(Collectors.toList());
            }
            return new CheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addPrimaryKey(primaryKeyCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addForeignKey(foreignKeyCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addUniqueConstraint(uniqueConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addNotNullConstraint(notNullConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addDefaultConstraint(defaultConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addCheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName, boolean ifNotExists) throws HiveException {
        try {
            this.getMSC().createResourcePlan(resourcePlan, copyFromName);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException((Throwable)e, ErrorMsg.RESOURCE_PLAN_ALREADY_EXISTS, resourcePlan.getName());
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan getResourcePlan(String rpName) throws HiveException {
        try {
            return this.getMSC().getResourcePlan(rpName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<WMResourcePlan> getAllResourcePlans() throws HiveException {
        try {
            return this.getMSC().getAllResourcePlans();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropResourcePlan(String rpName, boolean ifExists) throws HiveException {
        try {
            this.getMSC().dropResourcePlan(rpName);
        }
        catch (NoSuchObjectException e) {
            if (!ifExists) {
                throw new HiveException((Throwable)e, ErrorMsg.RESOURCE_PLAN_NOT_EXISTS, rpName);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan alterResourcePlan(String rpName, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws HiveException {
        try {
            return this.getMSC().alterResourcePlan(rpName, resourcePlan, canActivateDisabled, isForceDeactivate, isReplace);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan getActiveResourcePlan() throws HiveException {
        try {
            return this.getMSC().getActiveResourcePlan();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMValidateResourcePlanResponse validateResourcePlan(String rpName) throws HiveException {
        try {
            return this.getMSC().validateResourcePlan(rpName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            this.getMSC().createWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void alterWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            this.getMSC().alterWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMTrigger(String rpName, String triggerName) throws HiveException {
        try {
            this.getMSC().dropWMTrigger(rpName, triggerName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createWMPool(WMPool pool) throws HiveException {
        try {
            this.getMSC().createWMPool(pool);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void alterWMPool(WMNullablePool pool, String poolPath) throws HiveException {
        try {
            this.getMSC().alterWMPool(pool, poolPath);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMPool(String resourcePlanName, String poolPath) throws HiveException {
        try {
            this.getMSC().dropWMPool(resourcePlanName, poolPath);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws HiveException {
        try {
            this.getMSC().createOrUpdateWMMapping(mapping, isUpdate);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMMapping(WMMapping mapping) throws HiveException {
        try {
            this.getMSC().dropWMMapping(mapping);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop) throws HiveException {
        try {
            this.getMSC().createOrDropTriggerToPoolMapping(resourcePlanName, triggerName, poolPath, shouldDrop);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Nullable
    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws HiveException {
        try {
            HiveStorageHandler storageHandler = this.createStorageHandler(table.getTTable());
            return storageHandler == null ? null : storageHandler.getStorageHandlerInfo(table.getTTable());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static class SchemaException
    extends MetaException {
        private static final long serialVersionUID = 1L;

        public SchemaException(String message) {
            super(message);
        }
    }

    private static class ThreadLocalHive
    extends ThreadLocal<Hive> {
        private ThreadLocalHive() {
        }

        @Override
        protected Hive initialValue() {
            return null;
        }

        @Override
        public synchronized void set(Hive hiveObj) {
            Hive currentHive = (Hive)this.get();
            if (currentHive != hiveObj) {
                this.remove();
                super.set(hiveObj);
            }
        }

        @Override
        public synchronized void remove() {
            Hive currentHive = (Hive)this.get();
            if (currentHive != null) {
                currentHive.close(false);
                super.remove();
            }
        }
    }
}

