/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;

public class CheckConstraint
implements Serializable {
    Map<String, List<CheckConstraintCol>> checkConstraints;
    List<String> checkExpressionList;
    String tableName;
    String databaseName;

    public CheckConstraint() {
    }

    public CheckConstraint(List<SQLCheckConstraint> checkConstraintsList) {
        this.checkConstraints = new TreeMap<String, List<CheckConstraintCol>>();
        this.checkExpressionList = new ArrayList<String>();
        if (checkConstraintsList == null) {
            return;
        }
        if (!checkConstraintsList.isEmpty()) {
            this.tableName = checkConstraintsList.get(0).getTable_name();
            this.databaseName = checkConstraintsList.get(0).getTable_db();
        }
        for (SQLCheckConstraint uk : checkConstraintsList) {
            String colName = uk.getColumn_name();
            String check_expression = uk.getCheck_expression();
            this.checkExpressionList.add(check_expression);
            CheckConstraintCol currCol = new CheckConstraintCol(colName, check_expression);
            String constraintName = uk.getDc_name();
            if (this.checkConstraints.containsKey(constraintName)) {
                this.checkConstraints.get(constraintName).add(currCol);
                continue;
            }
            ArrayList<CheckConstraintCol> currList = new ArrayList<CheckConstraintCol>();
            currList.add(currCol);
            this.checkConstraints.put(constraintName, currList);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<String> getCheckExpressionList() {
        return this.checkExpressionList;
    }

    public Map<String, List<CheckConstraintCol>> getCheckConstraints() {
        return this.checkConstraints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Check Constraints for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.checkConstraints != null && this.checkConstraints.size() > 0) {
            for (Map.Entry<String, List<CheckConstraintCol>> me : this.checkConstraints.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey() + ",");
                List<CheckConstraintCol> currCol = me.getValue();
                if (currCol != null && currCol.size() > 0) {
                    for (CheckConstraintCol ukc : currCol) {
                        sb.append(" (Column Name: " + ukc.colName + ", Check Expression : " + ukc.checkExpression + "),");
                    }
                    sb.setLength(sb.length() - 1);
                }
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isCheckConstraintNotEmpty(CheckConstraint info) {
        return info != null && !info.getCheckConstraints().isEmpty();
    }

    public class CheckConstraintCol {
        public String colName;
        public String checkExpression;

        public CheckConstraintCol(String colName, String checkExpression) {
            this.colName = colName;
            this.checkExpression = checkExpression;
        }
    }
}

