/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprDoubleScalarLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int arg1Column;
    protected final double arg2Scalar;
    protected final int arg3Column;

    public IfExprDoubleScalarLongColumn(int arg1Column, double arg2Scalar, int arg3Column, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Column = arg3Column;
    }

    public IfExprDoubleScalarLongColumn() {
        this.arg1Column = -1;
        this.arg2Scalar = 0.0;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        LongColumnVector arg3ColVector = (LongColumnVector)batch.cols[this.arg3Column];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        long[] vector3 = arg3ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : (double)vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : (double)vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : (double)vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : (double)vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", val " + this.arg2Scalar + ", " + this.getColumnParamString(2, this.arg3Column);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"long"), VectorExpressionDescriptor.ArgumentType.getType((String)"double"), VectorExpressionDescriptor.ArgumentType.getType((String)"long")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

