/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColLessEqualDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public DecimalColLessEqualDecimalColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public DecimalColLessEqualDecimalColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outputVector[0] = vector1[0].compareTo(vector2[0]) <= 0 ? 1L : 0L;
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[0].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[0].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            HiveDecimalWritable value2 = vector2[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i].compareTo(value2) <= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i].compareTo(value2) <= 0 ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = vector1[i].compareTo(vector2[i]) <= 0 ? 1L : 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = vector1[i].compareTo(vector2[i]) <= 0 ? 1L : 0L;
            }
        }
        NullUtil.setNullDataEntriesLong(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL, VectorExpressionDescriptor.ArgumentType.DECIMAL}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

