/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColEqualLongScalar;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class Decimal64ColEqualDecimal64Scalar
extends LongColEqualLongScalar {
    private static final long serialVersionUID = 1L;

    public Decimal64ColEqualDecimal64Scalar(int colNum, long value, int outputColumnNum) {
        super(colNum, value, outputColumnNum);
    }

    public Decimal64ColEqualDecimal64Scalar() {
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.inputTypeInfos[0];
        HiveDecimalWritable writable = new HiveDecimalWritable();
        writable.deserialize64(this.value, decimalTypeInfo.scale());
        return this.getColumnParamString(0, this.colNum) + ", decimal64Val " + this.value + ", decimalVal " + writable.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

