/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class Decimal64ColDivideDecimal64Scalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private static final long[] powerOfTenTable = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final int colNum;
    private final long value;

    public Decimal64ColDivideDecimal64Scalar(int colNum, long value, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = value;
    }

    public Decimal64ColDivideDecimal64Scalar() {
        this.colNum = -1;
        this.value = 0L;
    }

    private long roundingDivision(long divident, long divisor, long absDivisor) {
        long absDivident = Math.abs(divident);
        boolean differentSigns = divident > 0L ^ divisor > 0L;
        long remainder = absDivident % absDivisor;
        long result = absDivident / absDivisor;
        if (remainder * 2L >= absDivisor) {
            ++result;
        }
        if (differentSigns) {
            return -1L * result;
        }
        return result;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        Decimal64ColumnVector inputColVector = (Decimal64ColumnVector)batch.cols[this.colNum];
        Decimal64ColumnVector outputColVector = (Decimal64ColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        long outputDecimal64AbsMax = HiveDecimalWritable.getDecimal64AbsMax(outputColVector.precision);
        int outputScale = ((DecimalTypeInfo)this.outputTypeInfo).scale();
        long scaleFactor = powerOfTenTable[outputScale];
        long absValue = Math.abs(this.value);
        if (this.value == 0L) {
            outputColVector.noNulls = false;
            outputColVector.isRepeating = true;
            outputIsNull[0] = true;
            NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                long result = this.roundingDivision(vector[0] * scaleFactor, this.value, absValue);
                if (Math.abs(result) > outputDecimal64AbsMax) {
                    outputIsNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[0] = result;
                }
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = result = this.roundingDivision(vector[i] * scaleFactor, this.value, absValue);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputVector[i] = result = this.roundingDivision(vector[i] * scaleFactor, this.value, absValue);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long result;
                    outputVector[i] = result = this.roundingDivision(vector[i] * scaleFactor, this.value, absValue);
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    long result;
                    outputIsNull[i] = false;
                    outputVector[i] = result = this.roundingDivision(vector[i] * scaleFactor, this.value, absValue);
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    long result;
                    outputIsNull[i] = false;
                    outputVector[i] = result = this.roundingDivision(vector[i] * scaleFactor, this.value, absValue);
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.inputTypeInfos[0];
        HiveDecimalWritable writable = new HiveDecimalWritable();
        writable.deserialize64(this.value, decimalTypeInfo.scale());
        return this.getColumnParamString(0, this.colNum) + ", decimal64Val " + this.value + ", decimalVal " + writable.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

