/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateColSubtractIntervalYearMonthColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;
    private final transient Date scratchDate1 = new Date(0L);
    private final transient HiveIntervalYearMonth scratchIntervalYearMonth2 = new HiveIntervalYearMonth();
    private final transient Date outputDate = new Date(0L);
    private final transient DateTimeMath dtm = new DateTimeMath();

    public DateColSubtractIntervalYearMonthColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public DateColSubtractIntervalYearMonthColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        long[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[0]));
            this.scratchIntervalYearMonth2.set((int)vector2[0]);
            this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
            outputVector[0] = DateWritableV2.dateToDays(this.outputDate);
        } else if (inputColVector1.isRepeating) {
            this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[0]));
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                }
            }
        } else if (inputColVector2.isRepeating) {
            this.scratchIntervalYearMonth2.set((int)vector2[0]);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchDate1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(this.scratchDate1, this.scratchIntervalYearMonth2, this.outputDate);
                outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
            }
        }
        NullUtil.setNullDataEntriesLong(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"date"), VectorExpressionDescriptor.ArgumentType.getType((String)"interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

