/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Description(name="compute_bit_vector_hll", value="_FUNC_(x) - Computes bit vector for NDV computation")
public class VectorUDAFComputeBitVectorLong
extends VectorAggregateExpression {
    public VectorUDAFComputeBitVectorLong() {
    }

    public VectorUDAFComputeBitVectorLong(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        block12: {
            Aggregation myagg;
            int batchSize;
            LongColumnVector inputColumn;
            block13: {
                block11: {
                    this.inputExpression.evaluate(batch);
                    inputColumn = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
                    batchSize = batch.size;
                    if (batchSize == 0) {
                        return;
                    }
                    myagg = (Aggregation)agg;
                    myagg.prepare();
                    if (!inputColumn.noNulls) break block11;
                    if (inputColumn.isRepeating) {
                        myagg.estimator.addToEstimator(inputColumn.vector[0]);
                    } else if (batch.selectedInUse) {
                        for (int i = 0; i < batchSize; ++i) {
                            int s = batch.selected[i];
                            myagg.estimator.addToEstimator(inputColumn.vector[s]);
                        }
                    } else {
                        for (int i = 0; i < batchSize; ++i) {
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    }
                    break block12;
                }
                if (!inputColumn.isRepeating) break block13;
                if (inputColumn.isNull[0]) break block12;
                myagg.estimator.addToEstimator(inputColumn.vector[0]);
                break block12;
            }
            if (batch.selectedInUse) {
                for (int i = 0; i < batchSize; ++i) {
                    int s = batch.selected[i];
                    if (inputColumn.isNull[s]) continue;
                    myagg.estimator.addToEstimator(inputColumn.vector[s]);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (inputColumn.isNull[i]) continue;
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            }
        }
    }

    private Aggregation getAggregation(VectorAggregationBufferRow[] sets, int rowid, int bufferIndex) {
        VectorAggregationBufferRow bufferRow = sets[rowid];
        Aggregation myagg = (Aggregation)bufferRow.getAggregationBuffer(bufferIndex);
        myagg.prepare();
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        block14: {
            int batchSize;
            LongColumnVector inputColumn;
            block15: {
                block13: {
                    this.inputExpression.evaluate(batch);
                    inputColumn = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
                    batchSize = batch.size;
                    if (batchSize == 0) {
                        return;
                    }
                    if (!inputColumn.noNulls) break block13;
                    if (inputColumn.isRepeating) {
                        for (int i = 0; i < batchSize; ++i) {
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[0]);
                        }
                    } else if (batch.selectedInUse) {
                        for (int i = 0; i < batchSize; ++i) {
                            int s = batch.selected[i];
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[s]);
                        }
                    } else {
                        for (int i = 0; i < batchSize; ++i) {
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    }
                    break block14;
                }
                if (!inputColumn.isRepeating) break block15;
                if (inputColumn.isNull[0]) break block14;
                for (int i = 0; i < batchSize; ++i) {
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[0]);
                }
                break block14;
            }
            if (batch.selectedInUse) {
                for (int i = 0; i < batchSize; ++i) {
                    int s = batch.selected[i];
                    if (inputColumn.isNull[s]) continue;
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[s]);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (inputColumn.isNull[i]) continue;
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            }
        }
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        return Aggregation.FIXED_SIZE;
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("compute_bit_vector_hll") && outputColVectorType == ColumnVector.Type.BYTES && inputColVectorType == ColumnVector.Type.LONG && (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        BytesColumnVector outputCol = (BytesColumnVector)batch.cols[columnNum];
        if (myagg.estimator == null) {
            outputCol.isNull[batchIndex] = true;
            outputCol.noNulls = false;
        } else {
            outputCol.isNull[batchIndex] = false;
            outputCol.isRepeating = false;
            byte[] outputbuf = myagg.estimator.serialize();
            outputCol.setRef(batchIndex, outputbuf, 0, outputbuf.length);
        }
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long FIXED_SIZE = HyperLogLog.builder().setSizeOptimized().build().lengthFor(null);
        HyperLogLog estimator;

        Aggregation() {
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.estimator = null;
        }

        public void prepare() {
            if (this.estimator == null) {
                this.estimator = HyperLogLog.builder().setSizeOptimized().build();
            }
        }
    }
}

