/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLogUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Description(name="compute_bit_vector_hll", value="_FUNC_(x) - Computes bit vector for NDV computation")
public class VectorUDAFComputeBitVectorFinal
extends VectorAggregateExpression {
    public VectorUDAFComputeBitVectorFinal() {
    }

    public VectorUDAFComputeBitVectorFinal(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        BytesColumnVector inputColumn = (BytesColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColumn.isRepeating) {
            if (!inputColumn.isNull[0] && inputColumn.length[0] > 0) {
                myagg.prepare();
                HyperLogLog mergingHLL = HyperLogLogUtils.deserializeHLL((byte[])inputColumn.vector[0], (int)inputColumn.start[0], (int)inputColumn.length[0]);
                myagg.estimator.mergeEstimators((NumDistinctValueEstimator)mergingHLL);
            }
        } else {
            for (int i = 0; i < batchSize; ++i) {
                int s = i;
                if (batch.selectedInUse) {
                    s = batch.selected[i];
                }
                if (inputColumn.isNull[s] || inputColumn.length[s] <= 0) continue;
                myagg.prepare();
                HyperLogLog mergingHLL = HyperLogLogUtils.deserializeHLL((byte[])inputColumn.vector[s], (int)inputColumn.start[s], (int)inputColumn.length[s]);
                myagg.estimator.mergeEstimators((NumDistinctValueEstimator)mergingHLL);
            }
        }
    }

    private Aggregation getAggregation(VectorAggregationBufferRow[] sets, int rowid, int bufferIndex) {
        VectorAggregationBufferRow bufferRow = sets[rowid];
        Aggregation myagg = (Aggregation)bufferRow.getAggregationBuffer(bufferIndex);
        myagg.prepare();
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        block5: {
            int batchSize;
            BytesColumnVector inputColumn;
            block4: {
                this.inputExpression.evaluate(batch);
                inputColumn = (BytesColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
                batchSize = batch.size;
                if (batchSize == 0) {
                    return;
                }
                if (!inputColumn.isRepeating) break block4;
                if (inputColumn.isNull[0] || inputColumn.length[0] <= 0) break block5;
                for (int i = 0; i < batchSize; ++i) {
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    HyperLogLog mergingHLL = HyperLogLogUtils.deserializeHLL((byte[])inputColumn.vector[0], (int)inputColumn.start[0], (int)inputColumn.length[0]);
                    myagg.estimator.mergeEstimators((NumDistinctValueEstimator)mergingHLL);
                }
                break block5;
            }
            for (int i = 0; i < batchSize; ++i) {
                int s = i;
                if (batch.selectedInUse) {
                    s = batch.selected[i];
                }
                if (inputColumn.isNull[s] || inputColumn.length[s] <= 0) continue;
                Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                HyperLogLog mergingHLL = HyperLogLogUtils.deserializeHLL((byte[])inputColumn.vector[s], (int)inputColumn.start[s], (int)inputColumn.length[s]);
                myagg.estimator.mergeEstimators((NumDistinctValueEstimator)mergingHLL);
            }
        }
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        return Aggregation.FIXED_SIZE;
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("compute_bit_vector_hll") && outputColVectorType == ColumnVector.Type.BYTES && inputColVectorType == ColumnVector.Type.BYTES && (mode == GenericUDAFEvaluator.Mode.PARTIAL2 || mode == GenericUDAFEvaluator.Mode.FINAL);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        BytesColumnVector outputCol = (BytesColumnVector)batch.cols[columnNum];
        if (myagg.estimator == null) {
            outputCol.isNull[batchIndex] = true;
            outputCol.noNulls = false;
        } else {
            outputCol.isNull[batchIndex] = false;
            outputCol.isRepeating = false;
            byte[] outputbuf = myagg.estimator.serialize();
            outputCol.setRef(batchIndex, outputbuf, 0, outputbuf.length);
        }
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long FIXED_SIZE = HyperLogLog.builder().setSizeOptimized().build().lengthFor(null);
        HyperLogLog estimator;

        Aggregation() {
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.estimator = null;
        }

        public void prepare() {
            if (this.estimator == null) {
                this.estimator = HyperLogLog.builder().setSizeOptimized().build();
            }
        }
    }
}

