/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldString;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;

public final class VectorUDFUnixTimeStampString
extends VectorUDFTimestampFieldString {
    private static final long serialVersionUID = 1L;
    private transient SimpleDateFormat format;
    private transient ZoneId timeZone;

    public VectorUDFUnixTimeStampString(int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum, -1, -1);
    }

    public VectorUDFUnixTimeStampString() {
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        if (this.timeZone == null) {
            String timeZoneStr = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone(timeZoneStr);
            this.format = VectorUDFUnixTimeStampString.getFormatter(this.timeZone);
        }
    }

    @Override
    protected long getField(byte[] bytes, int start, int length) throws ParseException {
        Date date = null;
        try {
            date = this.format.parse(Text.decode((byte[])bytes, (int)start, (int)length));
        }
        catch (CharacterCodingException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return date.getTime() / 1000L;
    }

    private static SimpleDateFormat getFormatter(ZoneId timeZone) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone(timeZone));
        return format;
    }
}

