/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseCol;

public class VectorUDFMapIndexLongCol
extends VectorUDFMapIndexBaseCol {
    public VectorUDFMapIndexLongCol() {
    }

    public VectorUDFMapIndexLongCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(mapColumnNum, indexColumnNum, outputColumnNum);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.getColumnParamString(1, this.getIndexColumnNum());
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }

    @Override
    public int findInMap(ColumnVector indexColumnVector, int indexBatchIndex, MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        long[] keys = ((LongColumnVector)mapColumnVector.keys).vector;
        long index = ((LongColumnVector)indexColumnVector).vector[indexBatchIndex];
        for (int i = 0; i < count; ++i) {
            if (index != keys[offset + i]) continue;
            return offset + i;
        }
        return -1;
    }
}

