/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;
    protected boolean isPositive = true;
    private final transient Text text = new Text();
    private final transient DateParser dateParser = new DateParser();
    private transient PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;

    public VectorUDFDateAddColCol(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public VectorUDFDateAddColCol() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.primitiveCategory = ((PrimitiveTypeInfo)this.inputTypeInfos[0]).getPrimitiveCategory();
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector1 = batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        NullUtil.propagateNullsColCol(inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outV, batch.selected, batch.size, batch.selectedInUse);
        switch (this.primitiveCategory) {
            case DATE: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateDate(inputColVector1, 0, vector2[0]);
                    break;
                }
                if (inputColVector1.isRepeating) {
                    this.evaluateRepeatedDate(inputColVector1, vector2, outV, batch.selectedInUse, batch.selected, n);
                    break;
                }
                if (inputColVector2.isRepeating) {
                    long repeatedNumDays = vector2[0];
                    if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputVector[i] = this.evaluateDate(inputColVector1, i, repeatedNumDays);
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            outputVector[i] = this.evaluateDate(inputColVector1, i, repeatedNumDays);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateTimestamp(inputColVector1, 0, vector2[0]);
                    break;
                }
                if (inputColVector1.isRepeating) {
                    this.evaluateRepeatedTimestamp(inputColVector1, vector2, outV, batch.selectedInUse, batch.selected, n);
                    break;
                }
                if (inputColVector2.isRepeating) {
                    long repeatedNumDays = vector2[0];
                    if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputVector[i] = this.evaluateTimestamp(inputColVector1, i, repeatedNumDays);
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            outputVector[i] = this.evaluateTimestamp(inputColVector1, i, repeatedNumDays);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    this.evaluateString((BytesColumnVector)inputColVector1, outV, 0, vector2[0]);
                    break;
                }
                if (inputColVector1.isRepeating) {
                    this.evaluateRepeatedString((BytesColumnVector)inputColVector1, vector2, outV, batch.selectedInUse, batch.selected, n);
                    break;
                }
                if (inputColVector2.isRepeating) {
                    long repeatedNumDays = vector2[0];
                    if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            this.evaluateString((BytesColumnVector)inputColVector1, outV, i, repeatedNumDays);
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            this.evaluateString((BytesColumnVector)inputColVector1, outV, i, repeatedNumDays);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluateString((BytesColumnVector)inputColVector1, outV, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        this.evaluateString((BytesColumnVector)inputColVector1, outV, i, vector2[i]);
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.primitiveCategory.name());
            }
        }
    }

    protected void evaluateRepeatedCommon(long days, long[] vector2, LongColumnVector outputVector, boolean selectedInUse, int[] selected, int n) {
        if (this.isPositive) {
            if (selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector.vector[i] = days + vector2[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector.vector[i] = days + vector2[i];
                }
            }
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector.vector[i] = days - vector2[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector.vector[i] = days - vector2[i];
            }
        }
    }

    protected long evaluateDate(ColumnVector columnVector, int index, long numDays) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        long days = lcv.vector[index];
        days = this.isPositive ? (days += numDays) : (days -= numDays);
        return days;
    }

    protected void evaluateRepeatedDate(ColumnVector columnVector, long[] vector2, LongColumnVector outputVector, boolean selectedInUse, int[] selected, int n) {
        if (columnVector.isNull[0]) {
            outputVector.noNulls = false;
            outputVector.isNull[0] = true;
            outputVector.isRepeating = true;
            return;
        }
        LongColumnVector lcv = (LongColumnVector)columnVector;
        long days = lcv.vector[0];
        this.evaluateRepeatedCommon(days, vector2, outputVector, selectedInUse, selected, n);
    }

    protected long evaluateTimestamp(ColumnVector columnVector, int index, long numDays) {
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        long days = DateWritableV2.millisToDays(tcv.getTime(index));
        days = this.isPositive ? (days += numDays) : (days -= numDays);
        return days;
    }

    protected void evaluateRepeatedTimestamp(ColumnVector columnVector, long[] vector2, LongColumnVector outputVector, boolean selectedInUse, int[] selected, int n) {
        if (columnVector.isNull[0]) {
            outputVector.noNulls = false;
            outputVector.isNull[0] = true;
            outputVector.isRepeating = true;
            return;
        }
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        long days = DateWritableV2.millisToDays(tcv.getTime(0));
        this.evaluateRepeatedCommon(days, vector2, outputVector, selectedInUse, selected, n);
    }

    protected void evaluateString(BytesColumnVector inputColumnVector1, LongColumnVector outputVector, int index, long numDays) {
        if (inputColumnVector1.isNull[index]) {
            outputVector.noNulls = false;
            outputVector.isNull[index] = true;
        } else {
            this.text.set(inputColumnVector1.vector[index], inputColumnVector1.start[index], inputColumnVector1.length[index]);
            Date hDate = new Date();
            boolean parsed = this.dateParser.parseDate(this.text.toString(), hDate);
            if (!parsed) {
                outputVector.noNulls = false;
                outputVector.isNull[index] = true;
                return;
            }
            long days = DateWritableV2.millisToDays(hDate.toEpochMilli());
            days = this.isPositive ? (days += numDays) : (days -= numDays);
            outputVector.vector[index] = days;
        }
    }

    protected void evaluateRepeatedString(BytesColumnVector inputColumnVector1, long[] vector2, LongColumnVector outputVector, boolean selectedInUse, int[] selected, int n) {
        if (inputColumnVector1.isNull[0]) {
            outputVector.noNulls = false;
            outputVector.isNull[0] = true;
            outputVector.isRepeating = true;
            return;
        }
        this.text.set(inputColumnVector1.vector[0], inputColumnVector1.start[0], inputColumnVector1.length[0]);
        Date date = new Date();
        boolean parsed = this.dateParser.parseDate(this.text.toString(), date);
        if (!parsed) {
            outputVector.noNulls = false;
            outputVector.isNull[0] = true;
            outputVector.isRepeating = true;
            return;
        }
        long days = DateWritableV2.millisToDays(date.toEpochMilli());
        this.evaluateRepeatedCommon(days, vector2, outputVector, selectedInUse, selected, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN});
        return b.build();
    }
}

