/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprLongColumnLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int arg1Column;
    protected final int arg2Column;
    protected final int arg3Column;

    public IfExprLongColumnLongColumn(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Column = arg3Column;
    }

    public IfExprLongColumnLongColumn() {
        this.arg1Column = -1;
        this.arg2Column = -1;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        boolean[] arg1IsNull = arg1ColVector.isNull;
        LongColumnVector arg2ColVector = (LongColumnVector)batch.cols[this.arg2Column];
        LongColumnVector arg3ColVector = (LongColumnVector)batch.cols[this.arg3Column];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        long[] vector2 = arg2ColVector.vector;
        long[] vector3 = arg3ColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1IsNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (vector1[i] - 1L ^ 0xFFFFFFFFFFFFFFFFL) & vector2[i] | vector1[i] - 1L & vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (vector1[i] - 1L ^ 0xFFFFFFFFFFFFFFFFL) & vector2[i] | vector1[i] - 1L & vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1IsNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1IsNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        }
        arg2ColVector.unFlatten();
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", " + this.getColumnParamString(1, this.arg2Column) + ", " + this.getColumnParamString(1, this.arg3Column);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"long"), VectorExpressionDescriptor.ArgumentType.getType((String)"int_date_interval_year_month"), VectorExpressionDescriptor.ArgumentType.getType((String)"int_date_interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

