/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FuncRandNoSeed
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final Random random;

    public FuncRandNoSeed(int outputColumnNum) {
        super(outputColumnNum);
        this.random = new Random();
    }

    public FuncRandNoSeed() {
        this.random = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        int n = batch.size;
        double[] outputVector = outputColVector.vector;
        outputColVector.isRepeating = false;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        if (batch.selectedInUse) {
            if (!outputColVector.noNulls) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outputVector[i] = this.random.nextDouble();
                }
            } else {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.random.nextDouble();
                }
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                outputVector[i] = this.random.nextDouble();
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(0).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.NONE}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.NONE}).build();
    }

    @Override
    public String vectorExpressionParameters() {
        return null;
    }
}

