/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class FuncLongToString
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int inputColumn;
    protected byte[] bytes;

    FuncLongToString(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    FuncLongToString() {
        this.inputColumn = -1;
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.bytes = new byte[64];
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.initBuffer();
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.prepareResult(0, vector, outputColVector);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.prepareResult(i, vector, outputColVector);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.prepareResult(i, vector, outputColVector);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.prepareResult(i, vector, outputColVector);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.prepareResult(i, vector, outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.prepareResult(i, vector, outputColVector);
                }
            }
        }
    }

    abstract void prepareResult(int var1, long[] var2, BytesColumnVector var3);

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN}).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).build();
    }
}

