/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class FilterDecimal64ColumnNotBetween
extends FilterLongColumnNotBetween {
    private static final long serialVersionUID = 1L;

    public FilterDecimal64ColumnNotBetween(int colNum, long leftValue, long rightValue) {
        super(colNum, leftValue, rightValue);
    }

    public FilterDecimal64ColumnNotBetween() {
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo1 = (DecimalTypeInfo)this.inputTypeInfos[1];
        HiveDecimalWritable writable1 = new HiveDecimalWritable();
        writable1.deserialize64(this.leftValue, decimalTypeInfo1.scale());
        DecimalTypeInfo decimalTypeInfo2 = (DecimalTypeInfo)this.inputTypeInfos[2];
        HiveDecimalWritable writable2 = new HiveDecimalWritable();
        writable2.deserialize64(this.rightValue, decimalTypeInfo2.scale());
        return this.getColumnParamString(0, this.colNum) + ", decimal64LeftVal " + this.leftValue + ", decimalLeftVal " + writable1.toString() + ", decimal64RightVal " + this.rightValue + ", decimalRightVal " + writable2.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

