/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateColSubtractDateScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private final Timestamp value;
    private final transient Timestamp scratchTimestamp1 = new Timestamp(0L);
    private final transient DateTimeMath dtm = new DateTimeMath();

    public DateColSubtractDateScalar(int colNum, long value, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = new Timestamp(0L);
        this.value.setTime(DateWritableV2.daysToMillis((int)value));
    }

    public DateColSubtractDateScalar() {
        this.colNum = -1;
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector1.isRepeating) {
            if (inputColVector1.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[0]));
                this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                        this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                        this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritableV2.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", val " + Date.ofEpochMilli(this.value.getTime());
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"date"), VectorExpressionDescriptor.ArgumentType.getType((String)"date")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

