/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressionsSupportDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

@VectorizedExpressionsSupportDecimal64
public class CastLongToDecimal64
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int inputColumn;
    private static final long[] powerOfTenTable = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public CastLongToDecimal64(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    public CastLongToDecimal64() {
        this.inputColumn = -1;
    }

    protected void scaleUp(Decimal64ColumnVector outV, LongColumnVector inV, int i, long scaleFactor) {
        outV.vector[i] = inV.vector[i] * scaleFactor;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        Decimal64ColumnVector outputColVector = (Decimal64ColumnVector)batch.cols[this.outputColumnNum];
        int outputScale = ((DecimalTypeInfo)this.outputTypeInfo).scale();
        long scaleFactor = powerOfTenTable[outputScale];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.scaleUp(outputColVector, inputColVector, 0, scaleFactor);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.scaleUp(outputColVector, inputColVector, i, scaleFactor);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.scaleUp(outputColVector, inputColVector, i, scaleFactor);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.scaleUp(outputColVector, inputColVector, i, scaleFactor);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.scaleUp(outputColVector, inputColVector, i, scaleFactor);
                }
            } else {
                System.arraycopy(inputColVector.isNull, 0, outputColVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.scaleUp(outputColVector, inputColVector, i, scaleFactor);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN});
        return b.build();
    }
}

