/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransportException;

public final class TByteBuffer
extends TEndpointTransport {
    private final ByteBuffer byteBuffer;

    public TByteBuffer(TConfiguration configuration, ByteBuffer byteBuffer) throws TTransportException {
        super(configuration);
        this.byteBuffer = byteBuffer;
        this.updateKnownMessageSize(byteBuffer.capacity());
    }

    public TByteBuffer(ByteBuffer byteBuffer) throws TTransportException {
        this(new TConfiguration(), byteBuffer);
    }

    public boolean isOpen() {
        return true;
    }

    public void open() {
    }

    public void close() {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        this.checkReadBytesAvailable(len);
        int n = Math.min(this.byteBuffer.remaining(), len);
        if (n > 0) {
            try {
                this.byteBuffer.get(buf, off, n);
            }
            catch (BufferUnderflowException e) {
                throw new TTransportException("Unexpected end of input buffer", (Throwable)e);
            }
        }
        return n;
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.byteBuffer.put(buf, off, len);
        }
        catch (BufferOverflowException e) {
            throw new TTransportException("Not enough room in output buffer", (Throwable)e);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public TByteBuffer clear() {
        this.byteBuffer.clear();
        return this;
    }

    public TByteBuffer flip() {
        this.byteBuffer.flip();
        return this;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(data);
        return data;
    }
}

