/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibUtil.class);

    public static void loadLibrary(String libFileName) {
        ArrayList<String> candidates = new ArrayList<String>(Arrays.asList(System.getProperty("java.library.path").split(":")));
        try {
            String myPath = NativeLibUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (myPath.toString().endsWith("fe/target/classes/") || myPath.toString().endsWith("fe/target/eclipse-classes/")) {
                candidates.add(myPath + "../../../be/build/latest/service/");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to get path for NativeLibUtil class", (Throwable)e);
        }
        for (String path : candidates) {
            File libFile = new File(path + File.separator + libFileName);
            if (!libFile.exists()) continue;
            System.load(libFile.getPath());
            return;
        }
        throw new RuntimeException("Failed to load " + libFileName + " from any candidate location:\n" + Joiner.on((String)"\n").join(candidates));
    }
}

