/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.util.DebugUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreUtil.class);
    public static final int CREATE_MAX_COMMENT_LENGTH = 256;
    public static final int MAX_PROPERTY_KEY_LENGTH = 256;
    public static final int MAX_PROPERTY_VALUE_LENGTH = 4000;
    public static final int MAX_OWNER_LENGTH = 128;
    public static final short DEFAULT_MAX_PARTITIONS_PER_RPC = 1000;
    private static short maxPartitionsPerRpc_ = (short)1000;
    public static final String NULL_PARTITION_KEY_VALUE_CONF_KEY = "hive.exec.default.partition.name";
    public static final String DEFAULT_NULL_PARTITION_KEY_VALUE = "__HIVE_DEFAULT_PARTITION__";
    public static final String HIVE_METASTORE_URIS_KEY = "hive.metastore.uris";
    public static final String DEFAULT_HIVE_METASTORE_URIS = "";
    public static final String hiveMetastoreUris_;

    public static String getNullPartitionKeyValue(IMetaStoreClient client) throws ConfigValSecurityException, TException {
        return client.getConfigValue(NULL_PARTITION_KEY_VALUE_CONF_KEY, DEFAULT_NULL_PARTITION_KEY_VALUE);
    }

    public static String getHiveMetastoreUris() {
        return hiveMetastoreUris_;
    }

    public static String getMetastoreConfigValue(IMetaStoreClient client, String config, String defaultVal) throws TException {
        return client.getConfigValue(config, defaultVal);
    }

    public static List<Partition> fetchAllPartitions(IMetaStoreClient client, Table msTbl, int numRetries) throws TException {
        String dbName = msTbl.getDbName();
        String tblName = msTbl.getTableName();
        Preconditions.checkArgument((numRetries >= 0 ? 1 : 0) != 0);
        int retryAttempt = 0;
        while (true) {
            try {
                List partNames = client.listPartitionNames(dbName, tblName, (short)-1);
                return MetaStoreUtil.fetchPartitionsByName(client, partNames, msTbl);
            }
            catch (MetaException e) {
                if (retryAttempt < numRetries) {
                    LOG.error(String.format("Error fetching partitions for table: %s.%s. Retry attempt: %d/%d", dbName, tblName, retryAttempt, numRetries), (Throwable)e);
                    ++retryAttempt;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static List<Partition> fetchPartitionsByName(IMetaStoreClient client, List<String> partNames, Table msTbl) throws TException {
        LOG.info("Fetching {} partitions for: {}.{} using partition batch size: {}", new Object[]{partNames.size(), msTbl.getDbName(), msTbl.getTableName(), maxPartitionsPerRpc_});
        ArrayList fetchedPartitions = Lists.newArrayList();
        int numDone = 0;
        for (int i = 0; i < partNames.size(); i += maxPartitionsPerRpc_) {
            List<String> partsToFetch = partNames.subList(i, Math.min(i + maxPartitionsPerRpc_, partNames.size()));
            List partitions = client.getPartitionsByNames(msTbl.getDbName(), msTbl.getTableName(), partsToFetch);
            boolean foundEmptyPartitionVals = false;
            for (Partition partition : partitions) {
                if (!partition.getValues().isEmpty()) continue;
                LOG.error("Received partition with empty values: {}.\nRefetching the partition.", (Object)partition);
                foundEmptyPartitionVals = true;
                break;
            }
            if (foundEmptyPartitionVals) {
                partitions = client.getPartitionsByNames(msTbl.getDbName(), msTbl.getTableName(), partsToFetch);
            }
            MetaStoreUtil.replaceSchemaFromTable(partitions, msTbl);
            fetchedPartitions.addAll(partitions);
            LOG.info("Fetched {}/{} partitions for table {}.{}", new Object[]{numDone += partitions.size(), partNames.size(), msTbl.getDbName(), msTbl.getTableName()});
        }
        if (DebugUtils.hasDebugAction(BackendConfig.INSTANCE.debugActions(), "mock_empty_partition_values")) {
            for (Partition msPart : fetchedPartitions) {
                msPart.getValues().clear();
            }
        }
        return fetchedPartitions;
    }

    public static List<Partition> addPartitions(IMetaStoreClient client, Table tbl, List<Partition> partitions, boolean ifNotExists, boolean needResults) throws TException {
        List addedPartitions = client.add_partitions(partitions, ifNotExists, needResults);
        MetaStoreUtil.replaceSchemaFromTable(addedPartitions, tbl);
        return addedPartitions;
    }

    public static void replaceSchemaFromTable(List<Partition> partitions, Table msTbl) {
        for (Partition p : partitions) {
            p.getSd().setCols(msTbl.getSd().getCols());
        }
    }

    public static StorageDescriptor shallowCopyStorageDescriptor(StorageDescriptor other) {
        return new StorageDescriptor(other.getCols(), other.getLocation(), other.getInputFormat(), other.getOutputFormat(), other.isCompressed(), other.getNumBuckets(), other.getSerdeInfo(), other.getBucketCols(), other.getSortCols(), other.getParameters());
    }

    public static void checkShortProperty(String name, String property, int length) throws AnalysisException {
        if (property.length() > length) {
            throw new AnalysisException(name + " length must be <= " + length + ": " + property.length());
        }
    }

    public static void checkShortPropertyMap(String mapName, Map<String, String> propertyMap) throws AnalysisException {
        if (null != propertyMap) {
            for (Map.Entry<String, String> property : propertyMap.entrySet()) {
                MetaStoreUtil.checkShortProperty(mapName + " key", property.getKey(), 256);
                MetaStoreUtil.checkShortProperty(mapName + " value", property.getValue(), 4000);
            }
        }
    }

    public static String findTblPropKeyCaseInsensitive(Map<String, String> propertyMap, String propertyKey) {
        Preconditions.checkNotNull(propertyMap);
        Preconditions.checkNotNull((Object)propertyKey);
        for (String key : propertyMap.keySet()) {
            if (key == null || !key.equalsIgnoreCase(propertyKey)) continue;
            return key;
        }
        return null;
    }

    public static String replaceValueInCsvList(String input, String toReplace, String replaceWith) {
        Iterable inputList = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)input);
        ArrayList outputList = Lists.newArrayList();
        for (String elem : inputList) {
            if (elem.equalsIgnoreCase(toReplace)) {
                outputList.add(replaceWith);
                continue;
            }
            outputList.add(elem);
        }
        return Joiner.on((String)",").join((Iterable)outputList);
    }

    public static String removeValueFromCsvList(String inputCsv, String toRemove) {
        Iterable inputList = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)inputCsv);
        ArrayList outputList = Lists.newArrayList();
        for (String elem : inputList) {
            if (elem.equalsIgnoreCase(toRemove)) continue;
            outputList.add(elem);
        }
        return Joiner.on((String)",").join((Iterable)outputList);
    }

    public static String intersectCsvListWithColumNames(String leftCsv, List<TColumn> rightCols) {
        Iterable leftCols = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)leftCsv);
        HashSet rightColNames = Sets.newHashSet();
        for (TColumn c : rightCols) {
            rightColNames.add(c.getColumnName().toLowerCase());
        }
        ArrayList outputList = Lists.newArrayList();
        for (String leftCol : leftCols) {
            if (!rightColNames.contains(leftCol.toLowerCase())) continue;
            outputList.add(leftCol);
        }
        return Joiner.on((String)",").join((Iterable)outputList);
    }

    public static List<String> getPartValsFromName(Table msTbl, String partName) throws MetaException, CatalogException {
        Preconditions.checkNotNull((Object)msTbl);
        LinkedHashMap hm = Warehouse.makeSpecFromName((String)partName);
        ArrayList partVals = Lists.newArrayList();
        for (FieldSchema field : msTbl.getPartitionKeys()) {
            String key = field.getName();
            String val = (String)hm.get(key);
            if (val == null) {
                throw new CatalogException("Incomplete partition name - missing " + key);
            }
            partVals.add(val);
        }
        return partVals;
    }

    public static boolean isBucketedTable(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        return msTbl.getSd().getNumBuckets() > 0;
    }

    public static boolean canStoreMinmaxInHMS(Type type) {
        return type.isIntegerType() || type.isFloatingPointType() || type.isDecimal() || type.isDate();
    }

    static {
        HiveConf hiveConf = new HiveConf(HdfsTable.class);
        String strValue = hiveConf.get(MetastoreShim.metastoreBatchRetrieveObjectsMaxConfigKey());
        if (strValue != null) {
            try {
                maxPartitionsPerRpc_ = Short.parseShort(strValue);
            }
            catch (NumberFormatException e) {
                LOG.error("Error parsing max partition batch size from HiveConfig: ", (Throwable)e);
            }
        }
        if (maxPartitionsPerRpc_ <= 0) {
            LOG.error(String.format("Invalid value for max partition batch size: %d. Using default: %d", maxPartitionsPerRpc_, (short)1000));
            maxPartitionsPerRpc_ = (short)1000;
        }
        hiveMetastoreUris_ = hiveConf.get(HIVE_METASTORE_URIS_KEY, DEFAULT_HIVE_METASTORE_URIS);
    }

    public static class TableInsertEventInfo {
        private final List<InsertEventRequestData> insertEventRequestData_;
        private final List<List<String>> insertEventPartVals_;
        private final long txnId_;
        private final long writeId_;
        private final boolean isTransactional_;

        public TableInsertEventInfo(List<InsertEventRequestData> insertEventInfos_, List<List<String>> insertEventPartVals_, boolean isTransactional, long txnId, long writeId) {
            Preconditions.checkState((insertEventInfos_.size() == insertEventPartVals_.size() ? 1 : 0) != 0);
            this.insertEventRequestData_ = insertEventInfos_;
            this.insertEventPartVals_ = insertEventPartVals_;
            this.txnId_ = txnId;
            this.writeId_ = writeId;
            this.isTransactional_ = isTransactional;
        }

        public boolean isTransactional() {
            return this.isTransactional_;
        }

        public List<InsertEventRequestData> getInsertEventReqData() {
            return this.insertEventRequestData_;
        }

        public List<List<String>> getInsertEventPartVals() {
            return this.insertEventPartVals_;
        }

        public long getTxnId() {
            return this.txnId_;
        }

        public long getWriteId() {
            return this.writeId_;
        }
    }
}

