/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MathUtil.class);

    public static long saturatingMultiply(long a, long b) {
        return LongMath.saturatedMultiply((long)a, (long)b);
    }

    public static long saturatingAdd(long a, long b) {
        return LongMath.saturatedAdd((long)a, (long)b);
    }

    public static long addCardinalities(long cardinality1, long cardinality2) {
        Preconditions.checkArgument((cardinality1 >= -1L ? 1 : 0) != 0, (String)"cardinality1 is invalid: %s", (long)cardinality1);
        Preconditions.checkArgument((cardinality2 >= -1L ? 1 : 0) != 0, (String)"cardinality2 is invalid: %s", (long)cardinality2);
        if (cardinality1 == -1L || cardinality2 == -1L) {
            return -1L;
        }
        try {
            return LongMath.checkedAdd((long)cardinality1, (long)cardinality2);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when adding longs: " + cardinality1 + ", " + cardinality2);
            return Long.MAX_VALUE;
        }
    }

    public static long multiplyCardinalities(long cardinality1, long cardinality2) {
        Preconditions.checkArgument((cardinality1 >= -1L ? 1 : 0) != 0, (String)"cardinality1 is invalid: %s", (long)cardinality1);
        Preconditions.checkArgument((cardinality2 >= -1L ? 1 : 0) != 0, (String)"cardinality2 is invalid: %s", (long)cardinality2);
        if (cardinality1 == -1L || cardinality2 == -1L) {
            return -1L;
        }
        try {
            return LongMath.checkedMultiply((long)cardinality1, (long)cardinality2);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when multiplying longs: " + cardinality1 + ", " + cardinality2);
            return Long.MAX_VALUE;
        }
    }

    public static long smallestValidCardinality(long cardinality1, long cardinality2) {
        Preconditions.checkArgument((cardinality1 >= -1L ? 1 : 0) != 0, (String)"cardinality1 is invalid: %s", (long)cardinality1);
        Preconditions.checkArgument((cardinality2 >= -1L ? 1 : 0) != 0, (String)"cardinality2 is invalid: %s", (long)cardinality2);
        if (cardinality1 >= 0L) {
            if (cardinality2 >= 0L) {
                return Math.min(cardinality1, cardinality2);
            }
            return cardinality1;
        }
        return Math.max(-1L, cardinality2);
    }
}

