/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TGetHadoopGroupsRequest;
import org.apache.impala.thrift.TGetHadoopGroupsResponse;
import org.apache.impala.thrift.TLogLevel;
import org.apache.impala.thrift.TPoolConfig;
import org.apache.impala.thrift.TPoolConfigParams;
import org.apache.impala.thrift.TResolveRequestPoolParams;
import org.apache.impala.thrift.TResolveRequestPoolResult;
import org.apache.impala.util.GlogAppender;
import org.apache.impala.util.RequestPoolService;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniRequestPoolService {
    static final Logger LOG = LoggerFactory.getLogger(JniRequestPoolService.class);
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private final RequestPoolService requestPoolService_;
    private static final Configuration CONF = new Configuration();
    private static final Groups GROUPS = Groups.getUserToGroupsMappingService((Configuration)CONF);

    public JniRequestPoolService(byte[] thriftBackendConfig, String fsAllocationPath, String sitePath, boolean isBackendTest, boolean isAdmissiond) throws ImpalaException {
        Preconditions.checkNotNull((Object)fsAllocationPath);
        TBackendGflags cfg = new TBackendGflags();
        JniUtil.deserializeThrift(protocolFactory_, cfg, thriftBackendConfig);
        if (isAdmissiond) {
            GlogAppender.Install(TLogLevel.values()[cfg.impala_log_lvl], TLogLevel.values()[cfg.non_impala_java_vlog]);
            LOG.info("GlogAppender installed for AdmissionD.");
            LOG.info(JniUtil.getJavaVersion());
        }
        BackendConfig.create(cfg, false);
        this.requestPoolService_ = RequestPoolService.getInstance(fsAllocationPath, sitePath, isBackendTest);
    }

    public void start() {
        this.requestPoolService_.start();
    }

    public byte[] resolveRequestPool(byte[] thriftResolvePoolParams) throws ImpalaException {
        TResolveRequestPoolParams resolvePoolParams = new TResolveRequestPoolParams();
        JniUtil.deserializeThrift(protocolFactory_, resolvePoolParams, thriftResolvePoolParams);
        TResolveRequestPoolResult result = this.requestPoolService_.resolveRequestPool(resolvePoolParams);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getPoolConfig(byte[] thriftPoolConfigParams) throws ImpalaException {
        TPoolConfigParams poolConfigParams = new TPoolConfigParams();
        JniUtil.deserializeThrift(protocolFactory_, poolConfigParams, thriftPoolConfigParams);
        TPoolConfig result = this.requestPoolService_.getPoolConfig(poolConfigParams.getPool());
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public static byte[] getHadoopGroupsInternal(byte[] serializedRequest) throws ImpalaException {
        TGetHadoopGroupsRequest request = new TGetHadoopGroupsRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        TGetHadoopGroupsResponse result = new TGetHadoopGroupsResponse();
        String user = request.getUser();
        String injectedGroups = BackendConfig.INSTANCE.getInjectedGroupMembersDebugOnly();
        if (StringUtils.isEmpty((CharSequence)injectedGroups)) {
            try {
                result.setGroups(GROUPS.getGroups(user));
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("No groups found for user")) {
                    result.setGroups(Collections.emptyList());
                }
                LOG.error("Error getting Hadoop groups for user: " + request.getUser(), (Throwable)e);
                throw new InternalException(e.getMessage());
            }
        } else {
            List<String> groups = JniUtil.decodeInjectedGroups(injectedGroups, user);
            LOG.info("getHadoopGroups returns injected groups " + groups + " for user " + user);
            result.setGroups(groups);
        }
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getHadoopGroups(byte[] serializedRequest) throws ImpalaException {
        return JniRequestPoolService.getHadoopGroupsInternal(serializedRequest);
    }
}

