/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnType;

public class IcebergSchemaConverter {
    private static ThreadLocal<Integer> iThreadLocal = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return 0;
        }
    };

    public static org.apache.impala.catalog.Type toImpalaType(Type t) throws ImpalaRuntimeException {
        switch (t.typeId()) {
            case BOOLEAN: {
                return org.apache.impala.catalog.Type.BOOLEAN;
            }
            case INTEGER: {
                return org.apache.impala.catalog.Type.INT;
            }
            case LONG: {
                return org.apache.impala.catalog.Type.BIGINT;
            }
            case FLOAT: {
                return org.apache.impala.catalog.Type.FLOAT;
            }
            case DOUBLE: {
                return org.apache.impala.catalog.Type.DOUBLE;
            }
            case STRING: {
                return org.apache.impala.catalog.Type.STRING;
            }
            case DATE: {
                return org.apache.impala.catalog.Type.DATE;
            }
            case BINARY: {
                return org.apache.impala.catalog.Type.BINARY;
            }
            case TIMESTAMP: {
                return org.apache.impala.catalog.Type.TIMESTAMP;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)t;
                return ScalarType.createDecimalType(decimal.precision(), decimal.scale());
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)t;
                return new ArrayType(IcebergSchemaConverter.toImpalaType(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)t;
                return new MapType(IcebergSchemaConverter.toImpalaType(mapType.keyType()), IcebergSchemaConverter.toImpalaType(mapType.valueType()));
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)t;
                ArrayList<StructField> structFields = new ArrayList<StructField>();
                List nestedFields = structType.fields();
                for (Types.NestedField nestedField : nestedFields) {
                    structFields.add(new IcebergStructField(nestedField.name(), IcebergSchemaConverter.toImpalaType(nestedField.type()), nestedField.doc(), nestedField.fieldId()));
                }
                return new StructType(structFields);
            }
        }
        throw new ImpalaRuntimeException(String.format("Iceberg type '%s' is not supported in Impala", t.typeId()));
    }

    public static List<FieldSchema> convertToHiveSchema(Schema schema) throws ImpalaRuntimeException {
        ArrayList<FieldSchema> ret = new ArrayList<FieldSchema>();
        for (Types.NestedField column : schema.columns()) {
            org.apache.impala.catalog.Type colType = IcebergSchemaConverter.toImpalaType(column.type());
            ret.add(new FieldSchema(column.name().toLowerCase(), colType.toSql().toLowerCase(), column.doc()));
        }
        return ret;
    }

    public static List<Column> convertToImpalaSchema(Schema schema) throws ImpalaRuntimeException {
        ArrayList<Column> ret = new ArrayList<Column>();
        int pos = 0;
        for (Types.NestedField column : schema.columns()) {
            org.apache.impala.catalog.Type colType = IcebergSchemaConverter.toImpalaType(column.type());
            int keyId = -1;
            int valueId = -1;
            if (colType.isMapType()) {
                Types.MapType mapType = (Types.MapType)column.type();
                keyId = mapType.keyId();
                valueId = mapType.valueId();
            }
            ret.add(new IcebergColumn(column.name(), colType, column.doc(), pos++, column.fieldId(), keyId, valueId, column.isOptional()));
        }
        return ret;
    }

    public static Schema convertToIcebergSchema(Table table) {
        ArrayList columns = Lists.newArrayList((Iterable)table.getSd().getCols());
        columns.addAll(table.getPartitionKeys());
        return HiveSchemaUtil.convert((List)columns, (boolean)false);
    }

    public static PartitionSpec createIcebergPartitionSpec(Table table, Schema schema) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)schema);
        for (FieldSchema partitionKey : table.getPartitionKeys()) {
            specBuilder.identity(partitionKey.getName());
        }
        return specBuilder.build();
    }

    public static Schema genIcebergSchema(List<TColumn> columns, List<String> primaryKeyColumnNames) throws ImpalaRuntimeException {
        iThreadLocal.set(1);
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        HashMap<String, Integer> colNameToFieldId = new HashMap<String, Integer>();
        for (TColumn column : columns) {
            Types.NestedField icebergField = IcebergSchemaConverter.createIcebergField(column);
            fields.add(icebergField);
            colNameToFieldId.put(icebergField.name(), icebergField.fieldId());
        }
        if (primaryKeyColumnNames == null || primaryKeyColumnNames.isEmpty()) {
            return new Schema(fields);
        }
        HashSet identifierFieldIds = new HashSet();
        for (String pkColName : primaryKeyColumnNames) {
            if (!colNameToFieldId.containsKey(pkColName)) {
                throw new ImpalaRuntimeException("Invalid primary key column name: " + pkColName);
            }
            identifierFieldIds.add(colNameToFieldId.get(pkColName));
        }
        return new Schema(fields, identifierFieldIds);
    }

    private static Types.NestedField createIcebergField(TColumn column) throws ImpalaRuntimeException {
        Type icebergType = IcebergSchemaConverter.fromImpalaColumnType(column.getColumnType());
        if (column.isIs_nullable()) {
            return Types.NestedField.optional((int)IcebergSchemaConverter.nextId(), (String)column.getColumnName(), (Type)icebergType, (String)column.getComment());
        }
        return Types.NestedField.required((int)IcebergSchemaConverter.nextId(), (String)column.getColumnName(), (Type)icebergType, (String)column.getComment());
    }

    public static Type fromImpalaColumnType(TColumnType colType) throws ImpalaRuntimeException {
        return IcebergSchemaConverter.fromImpalaType(org.apache.impala.catalog.Type.fromThrift(colType));
    }

    public static Type fromImpalaType(org.apache.impala.catalog.Type t) throws ImpalaRuntimeException {
        if (t.isScalarType()) {
            ScalarType st = (ScalarType)t;
            switch (st.getPrimitiveType()) {
                case BOOLEAN: {
                    return Types.BooleanType.get();
                }
                case INT: {
                    return Types.IntegerType.get();
                }
                case BIGINT: {
                    return Types.LongType.get();
                }
                case FLOAT: {
                    return Types.FloatType.get();
                }
                case DOUBLE: {
                    return Types.DoubleType.get();
                }
                case STRING: {
                    return Types.StringType.get();
                }
                case DATE: {
                    return Types.DateType.get();
                }
                case BINARY: {
                    return Types.BinaryType.get();
                }
                case TIMESTAMP: {
                    return Types.TimestampType.withoutZone();
                }
                case DECIMAL: {
                    return Types.DecimalType.of((int)st.decimalPrecision(), (int)st.decimalScale());
                }
            }
            throw new ImpalaRuntimeException(String.format("Type %s is not supported in Iceberg", t.toSql()));
        }
        if (t.isArrayType()) {
            ArrayType at = (ArrayType)t;
            return Types.ListType.ofRequired((int)IcebergSchemaConverter.nextId(), (Type)IcebergSchemaConverter.fromImpalaType(at.getItemType()));
        }
        if (t.isMapType()) {
            MapType mt = (MapType)t;
            return Types.MapType.ofRequired((int)IcebergSchemaConverter.nextId(), (int)IcebergSchemaConverter.nextId(), (Type)IcebergSchemaConverter.fromImpalaType(mt.getKeyType()), (Type)IcebergSchemaConverter.fromImpalaType(mt.getValueType()));
        }
        if (t.isStructType()) {
            StructType st = (StructType)t;
            ArrayList<Types.NestedField> icebergFields = new ArrayList<Types.NestedField>();
            for (StructField field : st.getFields()) {
                icebergFields.add(Types.NestedField.required((int)IcebergSchemaConverter.nextId(), (String)field.getName(), (Type)IcebergSchemaConverter.fromImpalaType(field.getType()), (String)field.getComment()));
            }
            return Types.StructType.of(icebergFields);
        }
        throw new ImpalaRuntimeException(String.format("Type %s is not supported in Iceberg", t.toSql()));
    }

    private static int nextId() {
        int nextId = iThreadLocal.get();
        iThreadLocal.set(nextId + 1);
        return nextId;
    }
}

