/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TIcebergOptimizationMode;

public class IcebergOptimizeFileFilter {
    public static FileFilteringResult filterFilesBySize(FilterArgs args) {
        TIcebergOptimizationMode mode;
        List<DataFile> selectedFiles = new ArrayList<DataFile>();
        if (args.fileSizeThreshold_ > 0L) {
            int hashValue;
            HashMap<Integer, Pair> filesPerPartition = new HashMap<Integer, Pair>();
            for (DataFile dataFile : ((FilterArgs)args).filesToFilter_.dataFilesWithoutDeletes) {
                Pair partition;
                if (dataFile.fileSizeInBytes() >= args.fileSizeThreshold_) continue;
                hashValue = dataFile.partition().hashCode();
                Pair pair = partition = filesPerPartition.computeIfAbsent(hashValue, k -> new Pair(0, new ArrayList()));
                Integer.valueOf((Integer)pair.first + 1);
                pair.first = pair.first;
                ((List)partition.second).add(dataFile);
            }
            for (DataFile dataFile : ((FilterArgs)args).filesToFilter_.dataFilesWithDeletes) {
                hashValue = dataFile.partition().hashCode();
                if (filesPerPartition.get(hashValue) == null) continue;
                Pair pair = (Pair)filesPerPartition.get(hashValue);
                Integer.valueOf((Integer)pair.first + 1);
                pair.first = pair.first;
            }
            for (Pair partition : filesPerPartition.values()) {
                if ((Integer)partition.first <= 1) continue;
                selectedFiles.addAll((Collection)partition.second);
            }
        } else if (args.fileSizeThreshold_ < 0L) {
            Preconditions.checkState((args.fileSizeThreshold_ == -1L ? 1 : 0) != 0);
            selectedFiles = ((FilterArgs)args).filesToFilter_.dataFilesWithoutDeletes;
        }
        if ((mode = IcebergOptimizeFileFilter.calculateOptimizationMode(args.filesToFilter_, selectedFiles)) != TIcebergOptimizationMode.PARTIAL) {
            selectedFiles.clear();
        }
        return new FileFilteringResult(mode, selectedFiles);
    }

    private static TIcebergOptimizationMode calculateOptimizationMode(GroupedContentFiles filesToFilter, List<DataFile> selectedFiles) {
        if (selectedFiles.isEmpty() && filesToFilter.dataFilesWithDeletes.isEmpty()) {
            Preconditions.checkState((filesToFilter.positionDeleteFiles.isEmpty() && filesToFilter.equalityDeleteFiles.isEmpty() ? 1 : 0) != 0);
            return TIcebergOptimizationMode.NOOP;
        }
        if (selectedFiles.size() == filesToFilter.dataFilesWithoutDeletes.size()) {
            return TIcebergOptimizationMode.REWRITE_ALL;
        }
        return TIcebergOptimizationMode.PARTIAL;
    }

    public static class FilterArgs {
        private final long fileSizeThreshold_;
        private final GroupedContentFiles filesToFilter_;

        public FilterArgs(GroupedContentFiles filesToFilter, long fileSizeThreshold) {
            this.filesToFilter_ = filesToFilter;
            this.fileSizeThreshold_ = fileSizeThreshold;
        }
    }

    public static class FileFilteringResult {
        private final TIcebergOptimizationMode optimizationMode_;
        private final List<DataFile> selectedFilesWithoutDeletes_;

        public FileFilteringResult(TIcebergOptimizationMode mode, List<DataFile> selectedFiles) {
            this.optimizationMode_ = mode;
            this.selectedFilesWithoutDeletes_ = selectedFiles;
        }

        public TIcebergOptimizationMode getOptimizationMode() {
            return this.optimizationMode_;
        }

        public List<DataFile> getSelectedFilesWithoutDeletes() {
            return this.selectedFilesWithoutDeletes_;
        }
    }
}

