/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.impala.common.Pair;
import org.apache.impala.util.IntArrayList;
import org.apache.impala.util.IntIterator;

public abstract class Graph {
    public abstract int numVertices();

    public abstract IntIterator dstIter(int var1);

    public String print() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numVertices(); ++i) {
            IntIterator dstIter = this.dstIter(i);
            if (!dstIter.hasNext()) continue;
            sb.append(i).append(" => ");
            while (dstIter.hasNext()) {
                sb.append(dstIter.next()).append(", ");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static int[] collectIdxsFromBitSet(BitSet bs) {
        int[] result = new int[bs.cardinality()];
        int i = 0;
        int j = bs.nextSetBit(0);
        while (j != -1) {
            result[i++] = j;
            j = bs.nextSetBit(j + 1);
        }
        return result;
    }

    public static class SccCondensedGraph
    extends Graph {
        private final int[] sccIds_;
        private final int[][] sccMembers_;
        private final RandomAccessibleGraph condensed_;

        private SccCondensedGraph(int[] sccIds, int[][] sccMembers, RandomAccessibleGraph condensed) {
            this.sccIds_ = sccIds;
            this.sccMembers_ = sccMembers;
            this.condensed_ = condensed;
        }

        @Override
        public int numVertices() {
            return this.sccIds_.length;
        }

        @Override
        public IntIterator dstIter(final int srcVid) {
            return new IntIterator(){
                private final int[] condensedAdjList;
                private int adjListPos;
                private int memberPos;
                {
                    this.condensedAdjList = condensed_.adjList_[sccIds_[srcVid]];
                    this.adjListPos = 0;
                    this.memberPos = 0;
                }

                @Override
                public boolean hasNext() {
                    while (this.adjListPos < this.condensedAdjList.length && this.memberPos == sccMembers_[this.condensedAdjList[this.adjListPos]].length) {
                        ++this.adjListPos;
                        this.memberPos = 0;
                    }
                    return this.adjListPos < this.condensedAdjList.length;
                }

                @Override
                public int next() {
                    int result = this.peek();
                    ++this.memberPos;
                    return result;
                }

                @Override
                public int peek() {
                    if (!this.hasNext()) {
                        throw new IndexOutOfBoundsException();
                    }
                    return sccMembers_[this.condensedAdjList[this.adjListPos]][this.memberPos];
                }
            };
        }

        public boolean hasEdge(int srcVid, int dstVid) {
            return this.condensed_.hasEdge(this.sccIds_[srcVid], this.sccIds_[dstVid]);
        }

        public static SccCondensedGraph condensedReflexiveTransitiveClosure(WritableGraph g) {
            Pair<int[], int[][]> scc = SccCondensedGraph.tarjanScc(g);
            RandomAccessibleGraph condensed = SccCondensedGraph.condenseGraphOnScc(g, (int[])scc.first, (int[][])scc.second);
            RandomAccessibleGraph condensedTc = condensed.reflexiveTransitiveClosure();
            return new SccCondensedGraph((int[])scc.first, (int[][])scc.second, condensedTc);
        }

        public int sccId(int vid) {
            return this.sccIds_[vid];
        }

        public int[] sccMembersBySccId(int sccId) {
            return this.sccMembers_[sccId];
        }

        public int[] sccMembersByVid(int vid) {
            return this.sccMembers_[this.sccIds_[vid]];
        }

        private static Pair<int[], int[][]> tarjanScc(final WritableGraph g) {
            int[] sccIds = new int[g.numVertices()];
            ArrayList<int[]> sccMembers = new ArrayList<int[]>();
            int[] dfsIdxs = new int[g.numVertices()];
            Arrays.fill(dfsIdxs, -1);
            int[] lowLinks = new int[g.numVertices()];
            IntArrayList unAssignedStack = new IntArrayList(g.numVertices());
            class DfsContext {
                final int vid;
                IntIterator dstIt;
                int unAssignedStackPos;

                DfsContext(int vid) {
                    this.vid = vid;
                    this.dstIt = g.dstIter(vid);
                }
            }
            ArrayDeque<DfsContext> dfsStack = new ArrayDeque<DfsContext>();
            BitSet onUnassignedStack = new BitSet(g.numVertices());
            int nextDfsIndex = 0;
            for (int dfsRootVid = 0; dfsRootVid < g.numVertices(); ++dfsRootVid) {
                if (dfsIdxs[dfsRootVid] != -1) continue;
                dfsStack.push(new DfsContext(dfsRootVid));
                while (!dfsStack.isEmpty()) {
                    DfsContext ctx = (DfsContext)dfsStack.peek();
                    if (dfsIdxs[ctx.vid] == -1) {
                        dfsIdxs[ctx.vid] = lowLinks[ctx.vid] = nextDfsIndex++;
                        ctx.unAssignedStackPos = unAssignedStack.size();
                        unAssignedStack.add(ctx.vid);
                        onUnassignedStack.set(ctx.vid);
                    }
                    if (!ctx.dstIt.hasNext()) {
                        if (lowLinks[ctx.vid] == dfsIdxs[ctx.vid]) {
                            int[] members = Arrays.copyOfRange(unAssignedStack.data(), ctx.unAssignedStackPos, unAssignedStack.size());
                            unAssignedStack.removeLast(members.length);
                            for (int member : members) {
                                sccIds[member] = sccMembers.size();
                                onUnassignedStack.clear(member);
                            }
                            sccMembers.add(members);
                        }
                        dfsStack.pop();
                        continue;
                    }
                    int nextDstVid = ctx.dstIt.peek();
                    if (dfsIdxs[nextDstVid] == -1) {
                        dfsStack.push(new DfsContext(nextDstVid));
                        continue;
                    }
                    if (onUnassignedStack.get(nextDstVid)) {
                        lowLinks[ctx.vid] = dfsIdxs[nextDstVid] >= dfsIdxs[ctx.vid] ? Math.min(lowLinks[ctx.vid], lowLinks[nextDstVid]) : Math.min(lowLinks[ctx.vid], dfsIdxs[nextDstVid]);
                    }
                    ctx.dstIt.next();
                }
                Preconditions.checkState((unAssignedStack.size() == 0 ? 1 : 0) != 0);
            }
            return Pair.create(sccIds, sccMembers.toArray((T[])new int[0][]));
        }

        private static RandomAccessibleGraph condenseGraphOnScc(WritableGraph g, int[] sccIds, int[][] sccMembers) {
            int[][] condensedAdjList = new int[sccMembers.length][];
            BitSet bs = new BitSet(sccMembers.length);
            for (int srcSccId = 0; srcSccId < sccMembers.length; ++srcSccId) {
                bs.clear();
                for (int srcVid : sccMembers[srcSccId]) {
                    IntIterator dstIt = g.dstIter(srcVid);
                    while (dstIt.hasNext()) {
                        bs.set(sccIds[dstIt.peek()]);
                        dstIt.next();
                    }
                }
                condensedAdjList[srcSccId] = Graph.collectIdxsFromBitSet(bs);
            }
            return new RandomAccessibleGraph(condensedAdjList);
        }

        public boolean validate(RandomAccessibleGraph reference) {
            if (reference.numVertices() != this.numVertices()) {
                return false;
            }
            IntArrayList sortedDsts = new IntArrayList(reference.numVertices());
            for (int i = 0; i < reference.numVertices(); ++i) {
                sortedDsts.clear();
                IntIterator dstIt = this.dstIter(i);
                while (dstIt.hasNext()) {
                    sortedDsts.add(dstIt.peek());
                    dstIt.next();
                }
                Arrays.sort(sortedDsts.data(), 0, sortedDsts.size());
                IntIterator refIt = reference.dstIter(i);
                IntIterator condensedIt = sortedDsts.iterator();
                while (refIt.hasNext() || condensedIt.hasNext()) {
                    if (refIt.hasNext() && condensedIt.hasNext() && refIt.next() == condensedIt.next()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class RandomAccessibleGraph
    extends Graph {
        private final int[][] adjList_;

        RandomAccessibleGraph(int[][] adjList) {
            this.adjList_ = adjList;
        }

        @Override
        public int numVertices() {
            return this.adjList_.length;
        }

        @Override
        public IntIterator dstIter(int srcVid) {
            return IntIterator.fromArray(this.adjList_[srcVid]);
        }

        boolean hasEdge(int srcVid, int dstVid) {
            int idx = Arrays.binarySearch(this.adjList_[srcVid], dstVid);
            return idx >= 0 && idx < this.adjList_[srcVid].length && this.adjList_[srcVid][idx] == dstVid;
        }

        public RandomAccessibleGraph reflexiveTransitiveClosure() {
            int[][] tcAdjList = new int[this.numVertices()][];
            BitSet visited = new BitSet(this.numVertices());
            IntArrayList queue = new IntArrayList(this.numVertices());
            for (int srcVid = 0; srcVid < this.numVertices(); ++srcVid) {
                visited.clear();
                visited.set(srcVid);
                queue.clear();
                queue.add(srcVid);
                for (int queueFront = 0; queueFront < queue.size(); ++queueFront) {
                    IntIterator dstIt = this.dstIter(queue.get(queueFront));
                    while (dstIt.hasNext()) {
                        if (!visited.get(dstIt.peek())) {
                            visited.set(dstIt.peek());
                            queue.add(dstIt.peek());
                        }
                        dstIt.next();
                    }
                }
                tcAdjList[srcVid] = Graph.collectIdxsFromBitSet(visited);
            }
            return new RandomAccessibleGraph(tcAdjList);
        }
    }

    public static class WritableGraph
    extends Graph {
        private final IntArrayList[] adjList_;

        public WritableGraph(int numVertices) {
            this.adjList_ = new IntArrayList[numVertices];
            for (int i = 0; i < numVertices; ++i) {
                this.adjList_[i] = new IntArrayList();
            }
        }

        @Override
        public int numVertices() {
            return this.adjList_.length;
        }

        @Override
        public IntIterator dstIter(int srcVid) {
            return this.adjList_[srcVid].iterator();
        }

        public void addEdge(int srcVid, int dstVid) {
            if (dstVid < 0 || dstVid >= this.numVertices()) {
                throw new IndexOutOfBoundsException();
            }
            this.adjList_[srcVid].add(dstVid);
        }

        public RandomAccessibleGraph toRandomAccessible() {
            int[][] sortedAdjList = new int[this.numVertices()][];
            for (int srcVid = 0; srcVid < this.numVertices(); ++srcVid) {
                int[] dsts = Arrays.copyOfRange(this.adjList_[srcVid].data(), 0, this.adjList_[srcVid].size());
                Arrays.sort(dsts);
                int uniqueSize = 0;
                for (int i = 0; i < dsts.length; ++i) {
                    if (i != 0 && dsts[i] == dsts[i - 1]) continue;
                    dsts[uniqueSize++] = dsts[i];
                }
                sortedAdjList[srcVid] = Arrays.copyOfRange(dsts, 0, uniqueSize);
            }
            return new RandomAccessibleGraph(sortedAdjList);
        }
    }
}

