/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TGetJavaLogLevelsResult;
import org.apache.impala.thrift.TLogLevel;
import org.apache.impala.thrift.TSetJavaLogLevelParams;
import org.apache.impala.util.NativeLogger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.thrift.protocol.TBinaryProtocol;

public class GlogAppender
extends AppenderSkeleton {
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();

    public boolean requiresLayout() {
        return false;
    }

    public void ActivateOptions() {
    }

    public void close() {
    }

    private TLogLevel levelToSeverity(Level level) {
        Preconditions.checkState((!level.equals((Object)Level.OFF) ? 1 : 0) != 0);
        if (level.equals((Object)Level.TRACE)) {
            return TLogLevel.VLOG_3;
        }
        if (level.equals((Object)Level.ALL)) {
            return TLogLevel.VLOG_3;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return TLogLevel.VLOG;
        }
        if (level.equals((Object)Level.ERROR)) {
            return TLogLevel.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return TLogLevel.FATAL;
        }
        if (level.equals((Object)Level.INFO)) {
            return TLogLevel.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return TLogLevel.WARN;
        }
        throw new IllegalStateException("Unknown log level: " + level.toString());
    }

    public void append(LoggingEvent event) {
        Level level = event.getLevel();
        if (level.equals((Object)Level.OFF)) {
            return;
        }
        String msg = event.getRenderedMessage();
        if (event.getThrowableInformation() != null) {
            msg = msg + "\nJava exception follows:\n" + Joiner.on((String)"\n").join((Object[])event.getThrowableStrRep());
        }
        int lineNumber = Integer.parseInt(event.getLocationInformation().getLineNumber());
        String fileName = event.getLocationInformation().getFileName();
        NativeLogger.LogToGlog(this.levelToSeverity(level).getValue(), msg, fileName, lineNumber);
    }

    private static String log4jLevelForTLogLevel(TLogLevel logLevel) throws InternalException {
        switch (logLevel) {
            case INFO: {
                return "INFO";
            }
            case WARN: {
                return "WARN";
            }
            case ERROR: {
                return "ERROR";
            }
            case FATAL: {
                return "FATAL";
            }
            case VLOG: 
            case VLOG_2: {
                return "DEBUG";
            }
            case VLOG_3: {
                return "TRACE";
            }
        }
        throw new InternalException("Unknown log level:" + (Object)((Object)logLevel));
    }

    public static void Install(TLogLevel impalaLogLevel, TLogLevel otherLogLevel) throws InternalException {
        Properties properties = new Properties();
        properties.setProperty("log4j.appender.glog", GlogAppender.class.getName());
        properties.setProperty("log4j.rootLogger", GlogAppender.log4jLevelForTLogLevel(otherLogLevel) + ",glog");
        properties.setProperty("log4j.appender.glog.Threshold", "TRACE");
        properties.setProperty("log4j.logger.org.apache.impala", GlogAppender.log4jLevelForTLogLevel(impalaLogLevel));
        PropertyConfigurator.configure((Properties)properties);
        Logger.getLogger(GlogAppender.class).info((Object)String.format("Logging (re)initialized. Impala: %s, All other: %s", new Object[]{impalaLogLevel, otherLogLevel}));
    }

    public static String setLogLevel(byte[] serializedParams) throws ImpalaException {
        TSetJavaLogLevelParams thriftParams = new TSetJavaLogLevelParams();
        JniUtil.deserializeThrift(protocolFactory_, thriftParams, serializedParams);
        String className = thriftParams.getClass_name();
        String logLevel = thriftParams.getLog_level();
        if (Strings.isNullOrEmpty((String)className) || Strings.isNullOrEmpty((String)logLevel)) {
            return null;
        }
        Logger.getLogger((String)className).setLevel(Level.toLevel((String)logLevel));
        return Logger.getLogger((String)className).getEffectiveLevel().toString();
    }

    public static void resetLogLevels() throws ImpalaException {
        LogManager.resetConfiguration();
        GlogAppender.Install(TLogLevel.values()[BackendConfig.INSTANCE.getImpalaLogLevel()], TLogLevel.values()[BackendConfig.INSTANCE.getNonImpalaJavaVlogLevel()]);
    }

    public static byte[] getLogLevels() throws ImpalaException {
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        ArrayList<String> logLevels = new ArrayList<String>();
        while (allLoggers.hasMoreElements()) {
            Logger logger = (Logger)allLoggers.nextElement();
            if (logger.getLevel() == null) continue;
            logLevels.add(logger.getName() + " : " + logger.getLevel());
        }
        TGetJavaLogLevelsResult result = new TGetJavaLogLevelsResult();
        result.setLog_levels(logLevels);
        return JniUtil.serializeToThrift(result, protocolFactory_);
    }
}

