/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.log4j.Logger;
import org.apache.thrift.protocol.TCompactProtocol;

public abstract class FunctionUtils {
    public static final Logger LOG = Logger.getLogger(FunctionUtils.class);
    public static final FunctionResolutionOrder FUNCTION_RESOLUTION_ORDER = new FunctionResolutionOrder();

    public static List<Function> deserializeNativeFunctionsFromDbParams(Map<String, String> dbParams) {
        ArrayList results = Lists.newArrayList();
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        for (Map.Entry<String, String> entry : dbParams.entrySet()) {
            if (!entry.getKey().startsWith("impala_registered_function_")) continue;
            try {
                TFunction fn = new TFunction();
                JniUtil.deserializeThrift(protocolFactory, fn, Base64.getDecoder().decode(entry.getValue()));
                results.add(Function.fromThrift(fn));
            }
            catch (ImpalaException e) {
                LOG.error((Object)("Encountered an error during function load: key=" + entry.getKey() + ",continuing"), (Throwable)e);
            }
        }
        return results;
    }

    public static Function resolveFunction(Iterable<Function> fns, Function desc, Function.CompareMode mode) {
        Preconditions.checkNotNull(fns);
        Preconditions.checkNotNull((Object)desc);
        Preconditions.checkNotNull((Object)((Object)mode));
        Function f = FunctionUtils.getBestFitFunction(fns, desc, Function.CompareMode.IS_IDENTICAL);
        if (f != null || mode == Function.CompareMode.IS_IDENTICAL) {
            return f;
        }
        f = FunctionUtils.getBestFitFunction(fns, desc, Function.CompareMode.IS_INDISTINGUISHABLE);
        if (f != null || mode == Function.CompareMode.IS_INDISTINGUISHABLE) {
            return f;
        }
        f = FunctionUtils.getBestFitFunction(fns, desc, Function.CompareMode.IS_SUPERTYPE_OF);
        if (f != null || mode == Function.CompareMode.IS_SUPERTYPE_OF) {
            return f;
        }
        return FunctionUtils.getBestFitFunction(fns, desc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
    }

    private static Function getBestFitFunction(Iterable<Function> fns, Function desc, Function.CompareMode mode) {
        int maxScore = -1;
        Function maxFunc = null;
        for (Function f : fns) {
            int score = f.calcMatchScore(desc, mode);
            if (score < 0 || score <= maxScore) continue;
            maxScore = score;
            maxFunc = f;
        }
        return maxFunc;
    }

    public static List<Function> getVisibleFunctionsInCategory(Iterable<Function> candidates, TFunctionCategory category) {
        ArrayList result = Lists.newArrayList();
        for (Function fn : candidates) {
            if (!fn.userVisible() || !Function.categoryMatch(fn, category)) continue;
            result.add(fn);
        }
        return result;
    }

    public static List<Function> getVisibleFunctions(Iterable<Function> candidates) {
        ArrayList result = Lists.newArrayList();
        for (Function fn : candidates) {
            if (!fn.userVisible()) continue;
            result.add(fn);
        }
        return result;
    }

    public static class FunctionResolutionOrder
    implements Comparator<Function> {
        @Override
        public int compare(Function f1, Function f2) {
            int numSharedArgs = Math.min(f1.getNumArgs(), f2.getNumArgs());
            for (int i = 0; i < numSharedArgs; ++i) {
                int cmp = this.typeCompare(f1.getArgs()[i], f2.getArgs()[i]);
                if (cmp < 0) {
                    return -1;
                }
                if (cmp <= 0) continue;
                return 1;
            }
            if (f1.getNumArgs() < f2.getNumArgs()) {
                return -1;
            }
            if (f1.getNumArgs() > f2.getNumArgs()) {
                return 1;
            }
            return 0;
        }

        private int typeCompare(Type t1, Type t2) {
            Preconditions.checkState((!t1.isComplexType() ? 1 : 0) != 0);
            Preconditions.checkState((!t2.isComplexType() ? 1 : 0) != 0);
            return Integer.compare(t1.getPrimitiveType().ordinal(), t2.getPrimitiveType().ordinal());
        }
    }
}

