/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.impala.util.FsPermissionChecker;

public class FsPermissionCache {
    private static Configuration CONF = new Configuration();
    private Map<Path, FsPermissionChecker.Permissions> cache_ = new HashMap<Path, FsPermissionChecker.Permissions>();

    public FsPermissionChecker.Permissions getPermissions(Path location) throws IOException {
        FsPermissionChecker.Permissions perms = this.cache_.get(location);
        if (perms != null) {
            return perms;
        }
        FsPermissionChecker checker = FsPermissionChecker.getInstance();
        FileSystem fs = location.getFileSystem(CONF);
        perms = checker.getPermissions(fs, location);
        this.cache_.put(location, perms);
        return perms;
    }

    public void precacheChildrenOf(FileSystem fs, Path p) throws FileNotFoundException, IOException {
        FsPermissionChecker checker = FsPermissionChecker.getInstance();
        RemoteIterator iter = fs.listStatusIterator(p);
        while (iter.hasNext()) {
            FileStatus status = (FileStatus)iter.next();
            FsPermissionChecker.Permissions perms = checker.getPermissions(fs, status);
            this.cache_.put(status.getPath(), perms);
        }
    }
}

