/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatchService {
    static final Logger LOG = LoggerFactory.getLogger(FileWatchService.class);
    static final long DEFAULT_CHECK_INTERVAL_MS = 10000L;
    private long checkIntervalMs_ = 10000L;
    private ScheduledFuture<?> fileCheckFuture_;
    private final AtomicBoolean running_;
    private final FileChangeListener changeListener_;
    private final File file_;
    private boolean alreadyWarned_;
    private long prevChange_;

    public FileWatchService(File file, FileChangeListener listener) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkArgument((boolean)file.exists());
        this.running_ = new AtomicBoolean(false);
        this.file_ = file;
        this.changeListener_ = listener;
        this.prevChange_ = 0L;
        this.alreadyWarned_ = false;
    }

    @VisibleForTesting
    public void setCheckIntervalMs(long checkIntervalMs) {
        this.checkIntervalMs_ = checkIntervalMs;
    }

    private void checkFile() {
        if (this.file_.exists()) {
            long lastChange = this.file_.lastModified();
            if (lastChange > this.prevChange_) {
                this.changeListener_.onFileChange();
                this.prevChange_ = lastChange;
                this.alreadyWarned_ = false;
            }
        } else if (!this.alreadyWarned_) {
            LOG.warn("File does not exist: {}", (Object)this.file_.getPath());
            this.alreadyWarned_ = true;
        }
    }

    public synchronized void start() {
        Preconditions.checkState((!this.running_.get() ? 1 : 0) != 0);
        this.running_.set(true);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FileWatchThread(" + this.file_.getPath() + ")-%d").build());
        this.fileCheckFuture_ = executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    FileWatchService.this.checkFile();
                }
                catch (SecurityException e) {
                    LOG.warn("Not allowed to check read file existence: " + FileWatchService.this.file_.getPath(), (Throwable)e);
                }
            }
        }, 0L, this.checkIntervalMs_, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        Preconditions.checkState((boolean)this.running_.get());
        this.running_.set(false);
        this.fileCheckFuture_.cancel(false);
    }

    public static interface FileChangeListener {
        public void onFileChange();
    }
}

