/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.thrift.TEventSequence;
import org.apache.impala.util.NoOpEventSequence;

public class EventSequence {
    private final List<Long> timestamps_ = Lists.newArrayList();
    private final List<String> labels_ = Lists.newArrayList();
    private final long startTime_;
    private final String name_;
    private long lastTime_;

    public EventSequence(String name) {
        this.name_ = name;
        this.lastTime_ = this.startTime_ = System.nanoTime();
    }

    public static EventSequence getUnusedTimeline() {
        return NoOpEventSequence.INSTANCE;
    }

    public long markEvent(String label) {
        long currentTime = System.nanoTime();
        long durationNs = currentTime - this.lastTime_;
        this.lastTime_ = currentTime;
        this.timestamps_.add(currentTime - this.startTime_);
        this.labels_.add(label);
        return durationNs;
    }

    public int getNumEvents() {
        return this.labels_.size();
    }

    public TEventSequence toThrift() {
        TEventSequence ret = new TEventSequence();
        ret.timestamps = this.timestamps_;
        ret.labels = this.labels_;
        ret.name = this.name_;
        return ret;
    }
}

