/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.impala.analysis.TableName;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;

public class CatalogBlacklistUtils {
    private static final Set<String> BLACKLISTED_DBS = CatalogBlacklistUtils.parseBlacklistedDbsFromConfigs();
    private static final Set<TableName> BLACKLISTED_TABLES = CatalogBlacklistUtils.parseBlacklistedTablesFromConfigs();

    public static Set<String> parseBlacklistedDbsFromConfigs() {
        return CatalogBlacklistUtils.parseBlacklistedDbs(BackendConfig.INSTANCE == null ? "" : BackendConfig.INSTANCE.getBlacklistedDbs(), null);
    }

    public static Set<TableName> parseBlacklistedTablesFromConfigs() {
        return CatalogBlacklistUtils.parseBlacklistedTables(BackendConfig.INSTANCE == null ? "" : BackendConfig.INSTANCE.getBlacklistedTables(), null);
    }

    public static Set<String> parseBlacklistedDbs(String blacklistedDbsConfig, Logger logger) {
        Preconditions.checkNotNull((Object)blacklistedDbsConfig);
        HashSet blacklistedDbs = Sets.newHashSet();
        for (String db : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)blacklistedDbsConfig)) {
            blacklistedDbs.add(db.toLowerCase());
            if (logger == null) continue;
            logger.info("Blacklist db: " + db);
        }
        return blacklistedDbs;
    }

    public static Set<TableName> parseBlacklistedTables(String blacklistedTablesConfig, Logger logger) {
        Preconditions.checkNotNull((Object)blacklistedTablesConfig);
        HashSet blacklistedTables = Sets.newHashSet();
        for (String tblName : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)blacklistedTablesConfig)) {
            TableName tbl = TableName.parse(tblName);
            if (tbl == null) {
                if (logger == null) continue;
                logger.warn(String.format("Illegal blacklisted table name: '%s'", tblName));
                continue;
            }
            blacklistedTables.add(tbl);
            if (logger == null) continue;
            logger.info("Blacklist table: " + tbl);
        }
        return blacklistedTables;
    }

    public static void verifyDbName(String dbName) throws AnalysisException {
        if (BackendConfig.INSTANCE.enableWorkloadMgmt() && dbName.equalsIgnoreCase("sys")) {
            return;
        }
        if (BLACKLISTED_DBS.contains(dbName)) {
            throw new AnalysisException("Invalid db name: " + dbName + ". It has been blacklisted using --blacklisted_dbs");
        }
    }

    public static void verifyTableName(TableName table) throws AnalysisException {
        if (BLACKLISTED_TABLES.contains(table)) {
            throw new AnalysisException("Invalid table/view name: " + table + ". It has been blacklisted using --blacklisted_tables");
        }
    }
}

