/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.AvroSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AvroSchemaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaUtils.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAvroSchema(List<Map<String, String>> schemaSearchLocations) throws AnalysisException {
        String url = null;
        for (Map<String, String> schemaLocation : schemaSearchLocations) {
            if (schemaLocation == null) continue;
            String literal = schemaLocation.get(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
            if (literal != null && !literal.equals("none")) {
                return literal;
            }
            url = schemaLocation.get(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
            if (url == null || url.equals("none")) continue;
            url = url.trim();
            break;
        }
        if (url == null) {
            return null;
        }
        String schema = null;
        InputStream urlStream = null;
        try {
            if (url.toLowerCase().startsWith("http://")) {
                urlStream = new URL(url).openStream();
                schema = IOUtils.toString((InputStream)urlStream);
            } else if (!BackendConfig.INSTANCE.disableCatalogDataOpsDebugOnly()) {
                Path path = new Path(url);
                FileSystem fs = null;
                fs = path.getFileSystem(FileSystemUtil.getConfiguration());
                if (!fs.exists(path)) {
                    throw new AnalysisException(String.format("Invalid avro.schema.url: %s. Path does not exist.", url));
                }
                schema = FileSystemUtil.readFile(path);
            } else {
                LOG.info(String.format("Avro schema, %s, not loaded from fs: catalog data ops disabled.", url));
            }
            if (urlStream == null) return schema;
        }
        catch (AnalysisException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw new AnalysisException(String.format("Failed to read Avro schema at: %s. %s ", url, e2.getMessage()));
                }
                catch (Exception e3) {
                    throw new AnalysisException(String.format("Invalid avro.schema.url: %s. %s", url, e3.getMessage()));
                }
            }
            catch (Throwable throwable) {
                if (urlStream == null) throw throwable;
                IOUtils.closeQuietly(urlStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)urlStream);
        return schema;
    }

    public static List<FieldSchema> reconcileAvroSchema(Table msTbl, String avroSchema) throws AnalysisException {
        Preconditions.checkNotNull((Object)msTbl);
        Preconditions.checkNotNull((Object)avroSchema);
        List<ColumnDef> colDefs = ColumnDef.createFromFieldSchemas(msTbl.getSd().getCols());
        List<ColumnDef> avroCols = AvroSchemaParser.parse(avroSchema);
        StringBuilder warning = new StringBuilder();
        List<ColumnDef> reconciledColDefs = AvroSchemaUtils.reconcileSchemas(colDefs, avroCols, warning);
        if (warning.length() != 0) {
            LOG.warn(String.format("Warning while loading table %s.%s:\n%s", msTbl.getDbName(), msTbl.getTableName(), warning.toString()));
        }
        AvroSchemaUtils.setFromSerdeComment(reconciledColDefs);
        return ColumnDef.toFieldSchemas(reconciledColDefs);
    }

    public static List<ColumnDef> reconcileSchemas(List<ColumnDef> colDefs, List<ColumnDef> avroCols, StringBuilder warning) {
        if (colDefs.size() != avroCols.size()) {
            warning.append(String.format("Ignoring column definitions in favor of Avro schema.\nThe Avro schema has %s column(s) but %s column definition(s) were given.", avroCols.size(), colDefs.size()));
            return avroCols;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)colDefs.size());
        for (int i = 0; i < avroCols.size(); ++i) {
            ColumnDef colDef = colDefs.get(i);
            ColumnDef avroCol = avroCols.get(i);
            Preconditions.checkNotNull((Object)colDef.getType());
            Preconditions.checkNotNull((Object)avroCol.getType());
            if (colDef.getType().isStringType() && avroCol.getType().isStringType()) {
                Preconditions.checkState((avroCol.getType().getPrimitiveType() == PrimitiveType.STRING || avroCol.getType().isBinary() ? 1 : 0) != 0);
                HashMap option = Maps.newHashMap();
                String comment = avroCol.getComment();
                if (comment != null) {
                    option.put(ColumnDef.Option.COMMENT, comment);
                }
                ColumnDef reconciledColDef = new ColumnDef(avroCol.getColName(), colDef.getTypeDef(), option);
                try {
                    reconciledColDef.analyze(null);
                }
                catch (AnalysisException e) {
                    Preconditions.checkNotNull(null, (Object)"reconciledColDef.analyze() should never throw.");
                }
                result.add(reconciledColDef);
            } else {
                result.add(avroCol);
            }
            if (colDef.getColName().equals(avroCol.getColName()) && colDef.getType().equals(avroCol.getType())) continue;
            if (warning.length() == 0) {
                warning.append("Resolved the following name and/or type inconsistencies between the column definitions and the Avro schema.\n");
            }
            warning.append(String.format("Column definition at position %s:  %s %s\n", i, colDefs.get(i).getColName(), colDefs.get(i).getType().toSql()));
            warning.append(String.format("Avro schema column at position %s: %s %s\n", i, avroCols.get(i).getColName(), avroCols.get(i).getType().toSql()));
            warning.append(String.format("Resolution at position %s: %s %s\n", i, ((ColumnDef)result.get(i)).getColName(), ((ColumnDef)result.get(i)).getType().toSql()));
        }
        Preconditions.checkState((result.size() == avroCols.size() ? 1 : 0) != 0);
        Preconditions.checkState((result.size() == colDefs.size() ? 1 : 0) != 0);
        return result;
    }

    public static void setFromSerdeComment(List<ColumnDef> colDefs) {
        for (ColumnDef colDef : colDefs) {
            if (!Strings.isNullOrEmpty((String)colDef.getComment())) continue;
            colDef.setComment("from deserializer");
        }
    }
}

