/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;

public class AvroSchemaParser {
    private static final Map<Schema.Type, Type> avroToImpalaPrimitiveTypeMap_;

    public static List<ColumnDef> parse(String schemaStr) throws SchemaParseException, AnalysisException {
        Schema.Parser avroSchemaParser = new Schema.Parser();
        Schema schema = avroSchemaParser.parse(schemaStr);
        if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new UnsupportedOperationException("Schema for table must be of type RECORD. Received type: " + schema.getType());
        }
        ArrayList colDefs = Lists.newArrayListWithCapacity((int)schema.getFields().size());
        for (Schema.Field field : schema.getFields()) {
            HashMap option = Maps.newHashMap();
            String comment = field.doc();
            if (comment != null) {
                option.put(ColumnDef.Option.COMMENT, comment);
            }
            ColumnDef colDef = new ColumnDef(field.name(), new TypeDef(AvroSchemaParser.getTypeInfo(field.schema(), field.name())), option);
            colDef.analyze(null);
            colDefs.add(colDef);
        }
        return colDefs;
    }

    private static Type getTypeInfo(Schema schema, String colName) throws AnalysisException {
        String logicalType;
        if (AvroSchemaParser.isNullableType(schema)) {
            return AvroSchemaParser.getTypeInfo(AvroSchemaParser.getColumnType(schema), colName);
        }
        Schema.Type type = schema.getType();
        if (type == Schema.Type.INT && (logicalType = schema.getProp("logicalType")) != null && logicalType.equalsIgnoreCase("date")) {
            return Type.DATE;
        }
        if (avroToImpalaPrimitiveTypeMap_.containsKey(type)) {
            return avroToImpalaPrimitiveTypeMap_.get(type);
        }
        switch (type) {
            case ARRAY: {
                Type itemType = AvroSchemaParser.getTypeInfo(schema.getElementType(), colName);
                return new ArrayType(itemType);
            }
            case MAP: {
                Type valueType = AvroSchemaParser.getTypeInfo(schema.getValueType(), colName);
                return new MapType(Type.STRING, valueType);
            }
            case RECORD: {
                StructType structType = new StructType();
                for (Schema.Field field : schema.getFields()) {
                    Type fieldType = AvroSchemaParser.getTypeInfo(field.schema(), colName);
                    structType.addField(new StructField(field.name(), fieldType, field.doc()));
                }
                return structType;
            }
            case BYTES: {
                String logicalType2 = schema.getProp("logicalType");
                if (logicalType2 == null) {
                    return Type.BINARY;
                }
                if (logicalType2.equalsIgnoreCase("decimal")) {
                    return AvroSchemaParser.getDecimalType(schema);
                }
                throw new AnalysisException(String.format("Unsupported logicalType: '%s' for column '%s' with type BYTES", logicalType2, colName));
            }
        }
        throw new AnalysisException(String.format("Unsupported type '%s' of column '%s'", type.getName(), colName));
    }

    private static boolean isNullableType(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    private static Schema getColumnType(Schema schema) {
        List types = schema.getTypes();
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }

    private static Type getDecimalType(Schema schema) {
        Integer precision;
        Preconditions.checkState((schema.getType() == Schema.Type.BYTES ? 1 : 0) != 0);
        Integer scale = AvroSchemaParser.getDecimalProp(schema, "scale");
        if (scale == null) {
            scale = 0;
        }
        if ((precision = AvroSchemaParser.getDecimalProp(schema, "precision")) == null) {
            throw new SchemaParseException("No 'precision' property specified for 'decimal' logicalType");
        }
        return ScalarType.createDecimalType(precision, scale);
    }

    private static Integer getDecimalProp(Schema schema, String propName) {
        Object node = schema.getObjectProp(propName);
        if (node == null) {
            return null;
        }
        Integer value = -1;
        if (node instanceof Integer) {
            value = (Integer)node;
        }
        if (node instanceof Double) {
            value = ((Double)node).intValue();
        }
        if (value < 0) {
            throw new SchemaParseException(String.format("Invalid decimal '%s' property value: %s", propName, node));
        }
        return value;
    }

    static {
        Hashtable<Schema.Type, ScalarType> typeMap = new Hashtable<Schema.Type, ScalarType>();
        typeMap.put(Schema.Type.STRING, Type.STRING);
        typeMap.put(Schema.Type.INT, Type.INT);
        typeMap.put(Schema.Type.BOOLEAN, Type.BOOLEAN);
        typeMap.put(Schema.Type.LONG, Type.BIGINT);
        typeMap.put(Schema.Type.FLOAT, Type.FLOAT);
        typeMap.put(Schema.Type.DOUBLE, Type.DOUBLE);
        avroToImpalaPrimitiveTypeMap_ = Collections.unmodifiableMap(typeMap);
    }
}

