/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;

public class AvroSchemaConverter {
    private static final String DEFAULT_SCHEMA_NAME = "baseRecord";
    private static final String RECORD_NAME_PREFIX = "record_";
    private static final String AVRO_LOGICAL_TYPE = "logicalType";
    private static final String PRECISION_PROP_NAME = "precision";
    private static final String SCALE_PROP_NAME = "scale";
    private static final String AVRO_DECIMAL_TYPE = "decimal";
    private static final String AVRO_DATE_TYPE = "date";
    private int recordCounter_ = 0;

    public static Schema convertColumns(List<Column> columns, String schemaName) {
        AvroSchemaConverter converter = new AvroSchemaConverter();
        return converter.convertColumnsImpl(columns, schemaName);
    }

    public static Schema convertColumnDefs(List<ColumnDef> colDefs, String schemaName) {
        AvroSchemaConverter converter = new AvroSchemaConverter();
        return converter.convertColumnDefsImpl(colDefs, schemaName);
    }

    public static Schema convertFieldSchemas(List<FieldSchema> fieldSchemas, String schemaName) {
        AvroSchemaConverter converter = new AvroSchemaConverter();
        return converter.convertFieldSchemasImpl(fieldSchemas, schemaName);
    }

    private Schema convertColumnsImpl(List<Column> columns, String schemaName) {
        ArrayList avroFields = Lists.newArrayList();
        for (Column column : columns) {
            Schema.Field avroField = new Schema.Field(column.getName(), this.createAvroSchema(column.getType()), column.getComment(), null);
            avroFields.add(avroField);
        }
        return this.createAvroRecord(avroFields, schemaName);
    }

    private Schema convertColumnDefsImpl(List<ColumnDef> colDefs, String schemaName) {
        ArrayList avroFields = Lists.newArrayList();
        for (ColumnDef colDef : colDefs) {
            Schema.Field avroField = new Schema.Field(colDef.getColName(), this.createAvroSchema(colDef.getType()), colDef.getComment(), null);
            avroFields.add(avroField);
        }
        return this.createAvroRecord(avroFields, schemaName);
    }

    private Schema convertFieldSchemasImpl(List<FieldSchema> fieldSchemas, String schemaName) {
        ArrayList avroFields = Lists.newArrayList();
        for (FieldSchema fs : fieldSchemas) {
            Type impalaType = Type.parseColumnType(fs.getType());
            if (impalaType == null) {
                throw new UnsupportedOperationException(fs.getType() + " is not a suppported Impala type");
            }
            Schema.Field avroField = new Schema.Field(fs.getName(), this.createAvroSchema(impalaType), fs.getComment(), (Object)Schema.NULL_VALUE);
            avroFields.add(avroField);
        }
        return this.createAvroRecord(avroFields, schemaName);
    }

    private Schema createAvroRecord(List<Schema.Field> avroFields, String schemaName) {
        if (schemaName == null || schemaName.isEmpty()) {
            schemaName = DEFAULT_SCHEMA_NAME;
        }
        Schema schema = Schema.createRecord((String)schemaName, null, null, (boolean)false);
        schema.setFields(avroFields);
        return schema;
    }

    private Schema createAvroSchema(Type impalaType) {
        Schema schema = null;
        if (impalaType.isScalarType()) {
            schema = this.createScalarSchema((ScalarType)impalaType);
        } else if (impalaType.isArrayType()) {
            schema = this.createArraySchema((ArrayType)impalaType);
        } else if (impalaType.isMapType()) {
            schema = this.createMapSchema((MapType)impalaType);
        } else if (impalaType.isStructType()) {
            schema = this.createRecordSchema((StructType)impalaType);
        } else {
            throw new UnsupportedOperationException(impalaType.toSql() + " cannot be converted to an Avro type");
        }
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        return Schema.createUnion(Arrays.asList(nullSchema, schema));
    }

    private Schema createScalarSchema(ScalarType impalaScalarType) {
        switch (impalaScalarType.getPrimitiveType()) {
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case CHAR: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case VARCHAR: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case BINARY: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case TINYINT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case SMALLINT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case BIGINT: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case TIMESTAMP: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case DATE: {
                return this.createDateSchema();
            }
            case DECIMAL: {
                return this.createDecimalSchema(impalaScalarType);
            }
        }
        throw new UnsupportedOperationException(impalaScalarType.toSql() + " cannot be converted to an Avro type");
    }

    private Schema createDateSchema() {
        Schema dateSchema = Schema.create((Schema.Type)Schema.Type.INT);
        dateSchema.addProp(AVRO_LOGICAL_TYPE, AVRO_DATE_TYPE);
        return dateSchema;
    }

    private Schema createDecimalSchema(ScalarType impalaDecimalType) {
        Schema decimalSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        decimalSchema.addProp(AVRO_LOGICAL_TYPE, AVRO_DECIMAL_TYPE);
        decimalSchema.addProp(PRECISION_PROP_NAME, (Object)impalaDecimalType.decimalPrecision());
        decimalSchema.addProp(SCALE_PROP_NAME, (Object)impalaDecimalType.decimalScale());
        return decimalSchema;
    }

    private Schema createArraySchema(ArrayType impalaArrayType) {
        Schema elementSchema = this.createAvroSchema(impalaArrayType.getItemType());
        return Schema.createArray((Schema)elementSchema);
    }

    private Schema createMapSchema(MapType impalaMapType) {
        Schema valueSchema = this.createAvroSchema(impalaMapType.getValueType());
        return Schema.createMap((Schema)valueSchema);
    }

    private Schema createRecordSchema(StructType impalaStructType) {
        ArrayList schemaFields = Lists.newArrayList();
        for (StructField structField : impalaStructType.getFields()) {
            Schema.Field avroField = new Schema.Field(structField.getName(), this.createAvroSchema(structField.getType()), structField.getComment(), null);
            schemaFields.add(avroField);
        }
        Schema structSchema = Schema.createRecord((String)(RECORD_NAME_PREFIX + this.recordCounter_), null, null, (boolean)false);
        ++this.recordCounter_;
        structSchema.setFields((List)schemaFields);
        return structSchema;
    }
}

