/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationProvider;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationUtil.class);

    private AuthorizationUtil() {
    }

    public static String authzFactoryClassNameFrom(BackendConfig beCfg) throws InternalException {
        String authzFactoryClassName;
        String authzFactoryClassOption = beCfg.getAuthorizationFactoryClass();
        if (authzFactoryClassOption != null) {
            authzFactoryClassName = authzFactoryClassOption;
        } else {
            String authzProvider = beCfg.getAuthorizationProvider();
            if (authzProvider.equals("")) {
                authzProvider = "noop";
            }
            try {
                AuthorizationProvider provider = AuthorizationProvider.valueOf(authzProvider.toUpperCase().trim());
                authzFactoryClassName = provider.getAuthorizationFactoryClassName();
            }
            catch (Exception e) {
                throw new InternalException("Could not parse authorization_provider flag: " + authzProvider);
            }
        }
        return authzFactoryClassName;
    }

    public static AuthorizationFactory authzFactoryFrom(BackendConfig beCfg) throws InternalException {
        AuthorizationFactory authzFactory;
        String authzFactoryClassName = AuthorizationUtil.authzFactoryClassNameFrom(beCfg);
        try {
            authzFactory = (AuthorizationFactory)Class.forName(authzFactoryClassName).getConstructor(BackendConfig.class).newInstance(beCfg);
        }
        catch (Exception e) {
            throw new InternalException("Unable to instantiate authorization provider: " + authzFactoryClassName, e);
        }
        if (!beCfg.isColumnMaskingEnabled() && beCfg.isRowFilteringEnabled()) {
            throw new InternalException("Unable to enable row-filtering without column-masking. Please set --enable_column_masking to true as well");
        }
        AuthorizationConfig authzConfig = authzFactory.getAuthorizationConfig();
        if (!authzConfig.isEnabled()) {
            LOG.info("Authorization is 'DISABLED'.");
            return new NoopAuthorizationFactory(beCfg);
        }
        LOG.info(String.format("Authorization is 'ENABLED' using %s.", authzConfig.getProviderName()));
        return authzFactory;
    }
}

