/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TVirtualColumnType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TSlotDescriptor
implements TBase<TSlotDescriptor, _Fields>,
Serializable,
Cloneable,
Comparable<TSlotDescriptor> {
    private static final TStruct STRUCT_DESC = new TStruct("TSlotDescriptor");
    private static final TField ID_FIELD_DESC = new TField("id", 8, 1);
    private static final TField PARENT_FIELD_DESC = new TField("parent", 8, 2);
    private static final TField ITEM_TUPLE_ID_FIELD_DESC = new TField("itemTupleId", 8, 3);
    private static final TField SLOT_TYPE_FIELD_DESC = new TField("slotType", 12, 4);
    private static final TField MATERIALIZED_PATH_FIELD_DESC = new TField("materializedPath", 15, 5);
    private static final TField BYTE_OFFSET_FIELD_DESC = new TField("byteOffset", 8, 6);
    private static final TField NULL_INDICATOR_BYTE_FIELD_DESC = new TField("nullIndicatorByte", 8, 7);
    private static final TField NULL_INDICATOR_BIT_FIELD_DESC = new TField("nullIndicatorBit", 8, 8);
    private static final TField SLOT_IDX_FIELD_DESC = new TField("slotIdx", 8, 9);
    private static final TField VIRTUAL_COL_TYPE_FIELD_DESC = new TField("virtual_col_type", 8, 10);
    private static final TField PATH_FIELD_DESC = new TField("path", 11, 11);
    private static final TField STRUCT_FIELD_IDX_FIELD_DESC = new TField("structFieldIdx", 8, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSlotDescriptorStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSlotDescriptorTupleSchemeFactory();
    public int id;
    public int parent;
    public int itemTupleId;
    @Nullable
    public TColumnType slotType;
    @Nullable
    public List<Integer> materializedPath;
    public int byteOffset;
    public int nullIndicatorByte;
    public int nullIndicatorBit;
    public int slotIdx;
    @Nullable
    public TVirtualColumnType virtual_col_type;
    @Nullable
    public String path;
    public int structFieldIdx;
    private static final int __ID_ISSET_ID = 0;
    private static final int __PARENT_ISSET_ID = 1;
    private static final int __ITEMTUPLEID_ISSET_ID = 2;
    private static final int __BYTEOFFSET_ISSET_ID = 3;
    private static final int __NULLINDICATORBYTE_ISSET_ID = 4;
    private static final int __NULLINDICATORBIT_ISSET_ID = 5;
    private static final int __SLOTIDX_ISSET_ID = 6;
    private static final int __STRUCTFIELDIDX_ISSET_ID = 7;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.ITEM_TUPLE_ID, _Fields.PATH, _Fields.STRUCT_FIELD_IDX};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSlotDescriptor() {
        this.virtual_col_type = TVirtualColumnType.NONE;
    }

    public TSlotDescriptor(int id, int parent, TColumnType slotType, List<Integer> materializedPath, int byteOffset, int nullIndicatorByte, int nullIndicatorBit, int slotIdx, TVirtualColumnType virtual_col_type) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.parent = parent;
        this.setParentIsSet(true);
        this.slotType = slotType;
        this.materializedPath = materializedPath;
        this.byteOffset = byteOffset;
        this.setByteOffsetIsSet(true);
        this.nullIndicatorByte = nullIndicatorByte;
        this.setNullIndicatorByteIsSet(true);
        this.nullIndicatorBit = nullIndicatorBit;
        this.setNullIndicatorBitIsSet(true);
        this.slotIdx = slotIdx;
        this.setSlotIdxIsSet(true);
        this.virtual_col_type = virtual_col_type;
    }

    public TSlotDescriptor(TSlotDescriptor other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.id = other.id;
        this.parent = other.parent;
        this.itemTupleId = other.itemTupleId;
        if (other.isSetSlotType()) {
            this.slotType = new TColumnType(other.slotType);
        }
        if (other.isSetMaterializedPath()) {
            ArrayList<Integer> __this__materializedPath = new ArrayList<Integer>(other.materializedPath);
            this.materializedPath = __this__materializedPath;
        }
        this.byteOffset = other.byteOffset;
        this.nullIndicatorByte = other.nullIndicatorByte;
        this.nullIndicatorBit = other.nullIndicatorBit;
        this.slotIdx = other.slotIdx;
        if (other.isSetVirtual_col_type()) {
            this.virtual_col_type = other.virtual_col_type;
        }
        if (other.isSetPath()) {
            this.path = other.path;
        }
        this.structFieldIdx = other.structFieldIdx;
    }

    public TSlotDescriptor deepCopy() {
        return new TSlotDescriptor(this);
    }

    public void clear() {
        this.setIdIsSet(false);
        this.id = 0;
        this.setParentIsSet(false);
        this.parent = 0;
        this.setItemTupleIdIsSet(false);
        this.itemTupleId = 0;
        this.slotType = null;
        this.materializedPath = null;
        this.setByteOffsetIsSet(false);
        this.byteOffset = 0;
        this.setNullIndicatorByteIsSet(false);
        this.nullIndicatorByte = 0;
        this.setNullIndicatorBitIsSet(false);
        this.nullIndicatorBit = 0;
        this.setSlotIdxIsSet(false);
        this.slotIdx = 0;
        this.virtual_col_type = TVirtualColumnType.NONE;
        this.path = null;
        this.setStructFieldIdxIsSet(false);
        this.structFieldIdx = 0;
    }

    public int getId() {
        return this.id;
    }

    public TSlotDescriptor setId(int id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getParent() {
        return this.parent;
    }

    public TSlotDescriptor setParent(int parent) {
        this.parent = parent;
        this.setParentIsSet(true);
        return this;
    }

    public void unsetParent() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetParent() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setParentIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getItemTupleId() {
        return this.itemTupleId;
    }

    public TSlotDescriptor setItemTupleId(int itemTupleId) {
        this.itemTupleId = itemTupleId;
        this.setItemTupleIdIsSet(true);
        return this;
    }

    public void unsetItemTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetItemTupleId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setItemTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    @Nullable
    public TColumnType getSlotType() {
        return this.slotType;
    }

    public TSlotDescriptor setSlotType(@Nullable TColumnType slotType) {
        this.slotType = slotType;
        return this;
    }

    public void unsetSlotType() {
        this.slotType = null;
    }

    public boolean isSetSlotType() {
        return this.slotType != null;
    }

    public void setSlotTypeIsSet(boolean value) {
        if (!value) {
            this.slotType = null;
        }
    }

    public int getMaterializedPathSize() {
        return this.materializedPath == null ? 0 : this.materializedPath.size();
    }

    @Nullable
    public Iterator<Integer> getMaterializedPathIterator() {
        return this.materializedPath == null ? null : this.materializedPath.iterator();
    }

    public void addToMaterializedPath(int elem) {
        if (this.materializedPath == null) {
            this.materializedPath = new ArrayList<Integer>();
        }
        this.materializedPath.add(elem);
    }

    @Nullable
    public List<Integer> getMaterializedPath() {
        return this.materializedPath;
    }

    public TSlotDescriptor setMaterializedPath(@Nullable List<Integer> materializedPath) {
        this.materializedPath = materializedPath;
        return this;
    }

    public void unsetMaterializedPath() {
        this.materializedPath = null;
    }

    public boolean isSetMaterializedPath() {
        return this.materializedPath != null;
    }

    public void setMaterializedPathIsSet(boolean value) {
        if (!value) {
            this.materializedPath = null;
        }
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public TSlotDescriptor setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
        this.setByteOffsetIsSet(true);
        return this;
    }

    public void unsetByteOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetByteOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setByteOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getNullIndicatorByte() {
        return this.nullIndicatorByte;
    }

    public TSlotDescriptor setNullIndicatorByte(int nullIndicatorByte) {
        this.nullIndicatorByte = nullIndicatorByte;
        this.setNullIndicatorByteIsSet(true);
        return this;
    }

    public void unsetNullIndicatorByte() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetNullIndicatorByte() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setNullIndicatorByteIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getNullIndicatorBit() {
        return this.nullIndicatorBit;
    }

    public TSlotDescriptor setNullIndicatorBit(int nullIndicatorBit) {
        this.nullIndicatorBit = nullIndicatorBit;
        this.setNullIndicatorBitIsSet(true);
        return this;
    }

    public void unsetNullIndicatorBit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetNullIndicatorBit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setNullIndicatorBitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public int getSlotIdx() {
        return this.slotIdx;
    }

    public TSlotDescriptor setSlotIdx(int slotIdx) {
        this.slotIdx = slotIdx;
        this.setSlotIdxIsSet(true);
        return this;
    }

    public void unsetSlotIdx() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetSlotIdx() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setSlotIdxIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    @Nullable
    public TVirtualColumnType getVirtual_col_type() {
        return this.virtual_col_type;
    }

    public TSlotDescriptor setVirtual_col_type(@Nullable TVirtualColumnType virtual_col_type) {
        this.virtual_col_type = virtual_col_type;
        return this;
    }

    public void unsetVirtual_col_type() {
        this.virtual_col_type = null;
    }

    public boolean isSetVirtual_col_type() {
        return this.virtual_col_type != null;
    }

    public void setVirtual_col_typeIsSet(boolean value) {
        if (!value) {
            this.virtual_col_type = null;
        }
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public TSlotDescriptor setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public void unsetPath() {
        this.path = null;
    }

    public boolean isSetPath() {
        return this.path != null;
    }

    public void setPathIsSet(boolean value) {
        if (!value) {
            this.path = null;
        }
    }

    public int getStructFieldIdx() {
        return this.structFieldIdx;
    }

    public TSlotDescriptor setStructFieldIdx(int structFieldIdx) {
        this.structFieldIdx = structFieldIdx;
        this.setStructFieldIdxIsSet(true);
        return this;
    }

    public void unsetStructFieldIdx() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)7);
    }

    public boolean isSetStructFieldIdx() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)7);
    }

    public void setStructFieldIdxIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Integer)value);
                break;
            }
            case PARENT: {
                if (value == null) {
                    this.unsetParent();
                    break;
                }
                this.setParent((Integer)value);
                break;
            }
            case ITEM_TUPLE_ID: {
                if (value == null) {
                    this.unsetItemTupleId();
                    break;
                }
                this.setItemTupleId((Integer)value);
                break;
            }
            case SLOT_TYPE: {
                if (value == null) {
                    this.unsetSlotType();
                    break;
                }
                this.setSlotType((TColumnType)value);
                break;
            }
            case MATERIALIZED_PATH: {
                if (value == null) {
                    this.unsetMaterializedPath();
                    break;
                }
                this.setMaterializedPath((List)value);
                break;
            }
            case BYTE_OFFSET: {
                if (value == null) {
                    this.unsetByteOffset();
                    break;
                }
                this.setByteOffset((Integer)value);
                break;
            }
            case NULL_INDICATOR_BYTE: {
                if (value == null) {
                    this.unsetNullIndicatorByte();
                    break;
                }
                this.setNullIndicatorByte((Integer)value);
                break;
            }
            case NULL_INDICATOR_BIT: {
                if (value == null) {
                    this.unsetNullIndicatorBit();
                    break;
                }
                this.setNullIndicatorBit((Integer)value);
                break;
            }
            case SLOT_IDX: {
                if (value == null) {
                    this.unsetSlotIdx();
                    break;
                }
                this.setSlotIdx((Integer)value);
                break;
            }
            case VIRTUAL_COL_TYPE: {
                if (value == null) {
                    this.unsetVirtual_col_type();
                    break;
                }
                this.setVirtual_col_type((TVirtualColumnType)((Object)value));
                break;
            }
            case PATH: {
                if (value == null) {
                    this.unsetPath();
                    break;
                }
                this.setPath((String)value);
                break;
            }
            case STRUCT_FIELD_IDX: {
                if (value == null) {
                    this.unsetStructFieldIdx();
                    break;
                }
                this.setStructFieldIdx((Integer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ID: {
                return this.getId();
            }
            case PARENT: {
                return this.getParent();
            }
            case ITEM_TUPLE_ID: {
                return this.getItemTupleId();
            }
            case SLOT_TYPE: {
                return this.getSlotType();
            }
            case MATERIALIZED_PATH: {
                return this.getMaterializedPath();
            }
            case BYTE_OFFSET: {
                return this.getByteOffset();
            }
            case NULL_INDICATOR_BYTE: {
                return this.getNullIndicatorByte();
            }
            case NULL_INDICATOR_BIT: {
                return this.getNullIndicatorBit();
            }
            case SLOT_IDX: {
                return this.getSlotIdx();
            }
            case VIRTUAL_COL_TYPE: {
                return this.getVirtual_col_type();
            }
            case PATH: {
                return this.getPath();
            }
            case STRUCT_FIELD_IDX: {
                return this.getStructFieldIdx();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ID: {
                return this.isSetId();
            }
            case PARENT: {
                return this.isSetParent();
            }
            case ITEM_TUPLE_ID: {
                return this.isSetItemTupleId();
            }
            case SLOT_TYPE: {
                return this.isSetSlotType();
            }
            case MATERIALIZED_PATH: {
                return this.isSetMaterializedPath();
            }
            case BYTE_OFFSET: {
                return this.isSetByteOffset();
            }
            case NULL_INDICATOR_BYTE: {
                return this.isSetNullIndicatorByte();
            }
            case NULL_INDICATOR_BIT: {
                return this.isSetNullIndicatorBit();
            }
            case SLOT_IDX: {
                return this.isSetSlotIdx();
            }
            case VIRTUAL_COL_TYPE: {
                return this.isSetVirtual_col_type();
            }
            case PATH: {
                return this.isSetPath();
            }
            case STRUCT_FIELD_IDX: {
                return this.isSetStructFieldIdx();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TSlotDescriptor) {
            return this.equals((TSlotDescriptor)that);
        }
        return false;
    }

    public boolean equals(TSlotDescriptor that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_parent = true;
        boolean that_present_parent = true;
        if (this_present_parent || that_present_parent) {
            if (!this_present_parent || !that_present_parent) {
                return false;
            }
            if (this.parent != that.parent) {
                return false;
            }
        }
        boolean this_present_itemTupleId = this.isSetItemTupleId();
        boolean that_present_itemTupleId = that.isSetItemTupleId();
        if (this_present_itemTupleId || that_present_itemTupleId) {
            if (!this_present_itemTupleId || !that_present_itemTupleId) {
                return false;
            }
            if (this.itemTupleId != that.itemTupleId) {
                return false;
            }
        }
        boolean this_present_slotType = this.isSetSlotType();
        boolean that_present_slotType = that.isSetSlotType();
        if (this_present_slotType || that_present_slotType) {
            if (!this_present_slotType || !that_present_slotType) {
                return false;
            }
            if (!this.slotType.equals(that.slotType)) {
                return false;
            }
        }
        boolean this_present_materializedPath = this.isSetMaterializedPath();
        boolean that_present_materializedPath = that.isSetMaterializedPath();
        if (this_present_materializedPath || that_present_materializedPath) {
            if (!this_present_materializedPath || !that_present_materializedPath) {
                return false;
            }
            if (!this.materializedPath.equals(that.materializedPath)) {
                return false;
            }
        }
        boolean this_present_byteOffset = true;
        boolean that_present_byteOffset = true;
        if (this_present_byteOffset || that_present_byteOffset) {
            if (!this_present_byteOffset || !that_present_byteOffset) {
                return false;
            }
            if (this.byteOffset != that.byteOffset) {
                return false;
            }
        }
        boolean this_present_nullIndicatorByte = true;
        boolean that_present_nullIndicatorByte = true;
        if (this_present_nullIndicatorByte || that_present_nullIndicatorByte) {
            if (!this_present_nullIndicatorByte || !that_present_nullIndicatorByte) {
                return false;
            }
            if (this.nullIndicatorByte != that.nullIndicatorByte) {
                return false;
            }
        }
        boolean this_present_nullIndicatorBit = true;
        boolean that_present_nullIndicatorBit = true;
        if (this_present_nullIndicatorBit || that_present_nullIndicatorBit) {
            if (!this_present_nullIndicatorBit || !that_present_nullIndicatorBit) {
                return false;
            }
            if (this.nullIndicatorBit != that.nullIndicatorBit) {
                return false;
            }
        }
        boolean this_present_slotIdx = true;
        boolean that_present_slotIdx = true;
        if (this_present_slotIdx || that_present_slotIdx) {
            if (!this_present_slotIdx || !that_present_slotIdx) {
                return false;
            }
            if (this.slotIdx != that.slotIdx) {
                return false;
            }
        }
        boolean this_present_virtual_col_type = this.isSetVirtual_col_type();
        boolean that_present_virtual_col_type = that.isSetVirtual_col_type();
        if (this_present_virtual_col_type || that_present_virtual_col_type) {
            if (!this_present_virtual_col_type || !that_present_virtual_col_type) {
                return false;
            }
            if (!this.virtual_col_type.equals((Object)that.virtual_col_type)) {
                return false;
            }
        }
        boolean this_present_path = this.isSetPath();
        boolean that_present_path = that.isSetPath();
        if (this_present_path || that_present_path) {
            if (!this_present_path || !that_present_path) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
        }
        boolean this_present_structFieldIdx = this.isSetStructFieldIdx();
        boolean that_present_structFieldIdx = that.isSetStructFieldIdx();
        if (this_present_structFieldIdx || that_present_structFieldIdx) {
            if (!this_present_structFieldIdx || !that_present_structFieldIdx) {
                return false;
            }
            if (this.structFieldIdx != that.structFieldIdx) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.id;
        hashCode = hashCode * 8191 + this.parent;
        hashCode = hashCode * 8191 + (this.isSetItemTupleId() ? 131071 : 524287);
        if (this.isSetItemTupleId()) {
            hashCode = hashCode * 8191 + this.itemTupleId;
        }
        hashCode = hashCode * 8191 + (this.isSetSlotType() ? 131071 : 524287);
        if (this.isSetSlotType()) {
            hashCode = hashCode * 8191 + this.slotType.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMaterializedPath() ? 131071 : 524287);
        if (this.isSetMaterializedPath()) {
            hashCode = hashCode * 8191 + this.materializedPath.hashCode();
        }
        hashCode = hashCode * 8191 + this.byteOffset;
        hashCode = hashCode * 8191 + this.nullIndicatorByte;
        hashCode = hashCode * 8191 + this.nullIndicatorBit;
        hashCode = hashCode * 8191 + this.slotIdx;
        hashCode = hashCode * 8191 + (this.isSetVirtual_col_type() ? 131071 : 524287);
        if (this.isSetVirtual_col_type()) {
            hashCode = hashCode * 8191 + this.virtual_col_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetPath() ? 131071 : 524287);
        if (this.isSetPath()) {
            hashCode = hashCode * 8191 + this.path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStructFieldIdx() ? 131071 : 524287);
        if (this.isSetStructFieldIdx()) {
            hashCode = hashCode * 8191 + this.structFieldIdx;
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSlotDescriptor other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetId(), other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((int)this.id, (int)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParent(), other.isSetParent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParent() && (lastComparison = TBaseHelper.compareTo((int)this.parent, (int)other.parent)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetItemTupleId(), other.isSetItemTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetItemTupleId() && (lastComparison = TBaseHelper.compareTo((int)this.itemTupleId, (int)other.itemTupleId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSlotType(), other.isSetSlotType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSlotType() && (lastComparison = TBaseHelper.compareTo((Comparable)this.slotType, (Comparable)other.slotType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaterializedPath(), other.isSetMaterializedPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaterializedPath() && (lastComparison = TBaseHelper.compareTo(this.materializedPath, other.materializedPath)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetByteOffset(), other.isSetByteOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetByteOffset() && (lastComparison = TBaseHelper.compareTo((int)this.byteOffset, (int)other.byteOffset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNullIndicatorByte(), other.isSetNullIndicatorByte());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNullIndicatorByte() && (lastComparison = TBaseHelper.compareTo((int)this.nullIndicatorByte, (int)other.nullIndicatorByte)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNullIndicatorBit(), other.isSetNullIndicatorBit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNullIndicatorBit() && (lastComparison = TBaseHelper.compareTo((int)this.nullIndicatorBit, (int)other.nullIndicatorBit)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSlotIdx(), other.isSetSlotIdx());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSlotIdx() && (lastComparison = TBaseHelper.compareTo((int)this.slotIdx, (int)other.slotIdx)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVirtual_col_type(), other.isSetVirtual_col_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVirtual_col_type() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.virtual_col_type), (Comparable)((Object)other.virtual_col_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPath(), other.isSetPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath() && (lastComparison = TBaseHelper.compareTo((String)this.path, (String)other.path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStructFieldIdx(), other.isSetStructFieldIdx());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStructFieldIdx() && (lastComparison = TBaseHelper.compareTo((int)this.structFieldIdx, (int)other.structFieldIdx)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TSlotDescriptor.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TSlotDescriptor.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSlotDescriptor(");
        boolean first = true;
        sb.append("id:");
        sb.append(this.id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parent:");
        sb.append(this.parent);
        first = false;
        if (this.isSetItemTupleId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("itemTupleId:");
            sb.append(this.itemTupleId);
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("slotType:");
        if (this.slotType == null) {
            sb.append("null");
        } else {
            sb.append(this.slotType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("materializedPath:");
        if (this.materializedPath == null) {
            sb.append("null");
        } else {
            sb.append(this.materializedPath);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("byteOffset:");
        sb.append(this.byteOffset);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("nullIndicatorByte:");
        sb.append(this.nullIndicatorByte);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("nullIndicatorBit:");
        sb.append(this.nullIndicatorBit);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("slotIdx:");
        sb.append(this.slotIdx);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("virtual_col_type:");
        if (this.virtual_col_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.virtual_col_type);
        }
        first = false;
        if (this.isSetPath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("path:");
            if (this.path == null) {
                sb.append("null");
            } else {
                sb.append(this.path);
            }
            first = false;
        }
        if (this.isSetStructFieldIdx()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("structFieldIdx:");
            sb.append(this.structFieldIdx);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.slotType == null) {
            throw new TProtocolException("Required field 'slotType' was not present! Struct: " + this.toString());
        }
        if (this.materializedPath == null) {
            throw new TProtocolException("Required field 'materializedPath' was not present! Struct: " + this.toString());
        }
        if (this.virtual_col_type == null) {
            throw new TProtocolException("Required field 'virtual_col_type' was not present! Struct: " + this.toString());
        }
        if (this.slotType != null) {
            this.slotType.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 1, new FieldValueMetaData(8, "TSlotId")));
        tmpMap.put(_Fields.PARENT, new FieldMetaData("parent", 1, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.ITEM_TUPLE_ID, new FieldMetaData("itemTupleId", 2, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.SLOT_TYPE, new FieldMetaData("slotType", 1, (FieldValueMetaData)new StructMetaData(12, TColumnType.class)));
        tmpMap.put(_Fields.MATERIALIZED_PATH, new FieldMetaData("materializedPath", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.BYTE_OFFSET, new FieldMetaData("byteOffset", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NULL_INDICATOR_BYTE, new FieldMetaData("nullIndicatorByte", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NULL_INDICATOR_BIT, new FieldMetaData("nullIndicatorBit", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SLOT_IDX, new FieldMetaData("slotIdx", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.VIRTUAL_COL_TYPE, new FieldMetaData("virtual_col_type", 1, (FieldValueMetaData)new EnumMetaData(16, TVirtualColumnType.class)));
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.STRUCT_FIELD_IDX, new FieldMetaData("structFieldIdx", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSlotDescriptor.class, metaDataMap);
    }

    private static class TSlotDescriptorTupleScheme
    extends TupleScheme<TSlotDescriptor> {
        private TSlotDescriptorTupleScheme() {
        }

        public void write(TProtocol prot, TSlotDescriptor struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.id);
            oprot.writeI32(struct.parent);
            struct.slotType.write((TProtocol)oprot);
            oprot.writeI32(struct.materializedPath.size());
            for (int _iter4 : struct.materializedPath) {
                oprot.writeI32(_iter4);
            }
            oprot.writeI32(struct.byteOffset);
            oprot.writeI32(struct.nullIndicatorByte);
            oprot.writeI32(struct.nullIndicatorBit);
            oprot.writeI32(struct.slotIdx);
            oprot.writeI32(struct.virtual_col_type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetItemTupleId()) {
                optionals.set(0);
            }
            if (struct.isSetPath()) {
                optionals.set(1);
            }
            if (struct.isSetStructFieldIdx()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetItemTupleId()) {
                oprot.writeI32(struct.itemTupleId);
            }
            if (struct.isSetPath()) {
                oprot.writeString(struct.path);
            }
            if (struct.isSetStructFieldIdx()) {
                oprot.writeI32(struct.structFieldIdx);
            }
        }

        public void read(TProtocol prot, TSlotDescriptor struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.id = iprot.readI32();
            struct.setIdIsSet(true);
            struct.parent = iprot.readI32();
            struct.setParentIsSet(true);
            struct.slotType = new TColumnType();
            struct.slotType.read((TProtocol)iprot);
            struct.setSlotTypeIsSet(true);
            TList _list5 = iprot.readListBegin((byte)8);
            struct.materializedPath = new ArrayList<Integer>(_list5.size);
            for (int _i7 = 0; _i7 < _list5.size; ++_i7) {
                int _elem6 = iprot.readI32();
                struct.materializedPath.add(_elem6);
            }
            struct.setMaterializedPathIsSet(true);
            struct.byteOffset = iprot.readI32();
            struct.setByteOffsetIsSet(true);
            struct.nullIndicatorByte = iprot.readI32();
            struct.setNullIndicatorByteIsSet(true);
            struct.nullIndicatorBit = iprot.readI32();
            struct.setNullIndicatorBitIsSet(true);
            struct.slotIdx = iprot.readI32();
            struct.setSlotIdxIsSet(true);
            struct.virtual_col_type = TVirtualColumnType.findByValue(iprot.readI32());
            struct.setVirtual_col_typeIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.itemTupleId = iprot.readI32();
                struct.setItemTupleIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
            }
            if (incoming.get(2)) {
                struct.structFieldIdx = iprot.readI32();
                struct.setStructFieldIdxIsSet(true);
            }
        }
    }

    private static class TSlotDescriptorTupleSchemeFactory
    implements SchemeFactory {
        private TSlotDescriptorTupleSchemeFactory() {
        }

        public TSlotDescriptorTupleScheme getScheme() {
            return new TSlotDescriptorTupleScheme();
        }
    }

    private static class TSlotDescriptorStandardScheme
    extends StandardScheme<TSlotDescriptor> {
        private TSlotDescriptorStandardScheme() {
        }

        public void read(TProtocol iprot, TSlotDescriptor struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.id = iprot.readI32();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.parent = iprot.readI32();
                            struct.setParentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.itemTupleId = iprot.readI32();
                            struct.setItemTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.slotType = new TColumnType();
                            struct.slotType.read(iprot);
                            struct.setSlotTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.materializedPath = new ArrayList<Integer>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                int _elem1 = iprot.readI32();
                                struct.materializedPath.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setMaterializedPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.byteOffset = iprot.readI32();
                            struct.setByteOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.nullIndicatorByte = iprot.readI32();
                            struct.setNullIndicatorByteIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.nullIndicatorBit = iprot.readI32();
                            struct.setNullIndicatorBitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.slotIdx = iprot.readI32();
                            struct.setSlotIdxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.virtual_col_type = TVirtualColumnType.findByValue(iprot.readI32());
                            struct.setVirtual_col_typeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.path = iprot.readString();
                            struct.setPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 8) {
                            struct.structFieldIdx = iprot.readI32();
                            struct.setStructFieldIdxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetId()) {
                throw new TProtocolException("Required field 'id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetParent()) {
                throw new TProtocolException("Required field 'parent' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetByteOffset()) {
                throw new TProtocolException("Required field 'byteOffset' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetNullIndicatorByte()) {
                throw new TProtocolException("Required field 'nullIndicatorByte' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetNullIndicatorBit()) {
                throw new TProtocolException("Required field 'nullIndicatorBit' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetSlotIdx()) {
                throw new TProtocolException("Required field 'slotIdx' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TSlotDescriptor struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI32(struct.id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(PARENT_FIELD_DESC);
            oprot.writeI32(struct.parent);
            oprot.writeFieldEnd();
            if (struct.isSetItemTupleId()) {
                oprot.writeFieldBegin(ITEM_TUPLE_ID_FIELD_DESC);
                oprot.writeI32(struct.itemTupleId);
                oprot.writeFieldEnd();
            }
            if (struct.slotType != null) {
                oprot.writeFieldBegin(SLOT_TYPE_FIELD_DESC);
                struct.slotType.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.materializedPath != null) {
                oprot.writeFieldBegin(MATERIALIZED_PATH_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.materializedPath.size()));
                for (int _iter3 : struct.materializedPath) {
                    oprot.writeI32(_iter3);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(BYTE_OFFSET_FIELD_DESC);
            oprot.writeI32(struct.byteOffset);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NULL_INDICATOR_BYTE_FIELD_DESC);
            oprot.writeI32(struct.nullIndicatorByte);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NULL_INDICATOR_BIT_FIELD_DESC);
            oprot.writeI32(struct.nullIndicatorBit);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SLOT_IDX_FIELD_DESC);
            oprot.writeI32(struct.slotIdx);
            oprot.writeFieldEnd();
            if (struct.virtual_col_type != null) {
                oprot.writeFieldBegin(VIRTUAL_COL_TYPE_FIELD_DESC);
                oprot.writeI32(struct.virtual_col_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.path != null && struct.isSetPath()) {
                oprot.writeFieldBegin(PATH_FIELD_DESC);
                oprot.writeString(struct.path);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStructFieldIdx()) {
                oprot.writeFieldBegin(STRUCT_FIELD_IDX_FIELD_DESC);
                oprot.writeI32(struct.structFieldIdx);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TSlotDescriptorStandardSchemeFactory
    implements SchemeFactory {
        private TSlotDescriptorStandardSchemeFactory() {
        }

        public TSlotDescriptorStandardScheme getScheme() {
            return new TSlotDescriptorStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ID(1, "id"),
        PARENT(2, "parent"),
        ITEM_TUPLE_ID(3, "itemTupleId"),
        SLOT_TYPE(4, "slotType"),
        MATERIALIZED_PATH(5, "materializedPath"),
        BYTE_OFFSET(6, "byteOffset"),
        NULL_INDICATOR_BYTE(7, "nullIndicatorByte"),
        NULL_INDICATOR_BIT(8, "nullIndicatorBit"),
        SLOT_IDX(9, "slotIdx"),
        VIRTUAL_COL_TYPE(10, "virtual_col_type"),
        PATH(11, "path"),
        STRUCT_FIELD_IDX(12, "structFieldIdx");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ID;
                }
                case 2: {
                    return PARENT;
                }
                case 3: {
                    return ITEM_TUPLE_ID;
                }
                case 4: {
                    return SLOT_TYPE;
                }
                case 5: {
                    return MATERIALIZED_PATH;
                }
                case 6: {
                    return BYTE_OFFSET;
                }
                case 7: {
                    return NULL_INDICATOR_BYTE;
                }
                case 8: {
                    return NULL_INDICATOR_BIT;
                }
                case 9: {
                    return SLOT_IDX;
                }
                case 10: {
                    return VIRTUAL_COL_TYPE;
                }
                case 11: {
                    return PATH;
                }
                case 12: {
                    return STRUCT_FIELD_IDX;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

