/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum TJoinOp implements TEnum
{
    INNER_JOIN(0),
    LEFT_OUTER_JOIN(1),
    LEFT_SEMI_JOIN(2),
    LEFT_ANTI_JOIN(3),
    NULL_AWARE_LEFT_ANTI_JOIN(4),
    RIGHT_OUTER_JOIN(5),
    RIGHT_SEMI_JOIN(6),
    RIGHT_ANTI_JOIN(7),
    FULL_OUTER_JOIN(8),
    CROSS_JOIN(9),
    ICEBERG_DELETE_JOIN(10);

    private final int value;

    private TJoinOp(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TJoinOp findByValue(int value) {
        switch (value) {
            case 0: {
                return INNER_JOIN;
            }
            case 1: {
                return LEFT_OUTER_JOIN;
            }
            case 2: {
                return LEFT_SEMI_JOIN;
            }
            case 3: {
                return LEFT_ANTI_JOIN;
            }
            case 4: {
                return NULL_AWARE_LEFT_ANTI_JOIN;
            }
            case 5: {
                return RIGHT_OUTER_JOIN;
            }
            case 6: {
                return RIGHT_SEMI_JOIN;
            }
            case 7: {
                return RIGHT_ANTI_JOIN;
            }
            case 8: {
                return FULL_OUTER_JOIN;
            }
            case 9: {
                return CROSS_JOIN;
            }
            case 10: {
                return ICEBERG_DELETE_JOIN;
            }
        }
        return null;
    }
}

