/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TJsonBinaryFormat;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class THdfsStorageDescriptor
implements TBase<THdfsStorageDescriptor, _Fields>,
Serializable,
Cloneable,
Comparable<THdfsStorageDescriptor> {
    private static final TStruct STRUCT_DESC = new TStruct("THdfsStorageDescriptor");
    private static final TField LINE_DELIM_FIELD_DESC = new TField("lineDelim", 3, 1);
    private static final TField FIELD_DELIM_FIELD_DESC = new TField("fieldDelim", 3, 2);
    private static final TField COLLECTION_DELIM_FIELD_DESC = new TField("collectionDelim", 3, 3);
    private static final TField MAP_KEY_DELIM_FIELD_DESC = new TField("mapKeyDelim", 3, 4);
    private static final TField ESCAPE_CHAR_FIELD_DESC = new TField("escapeChar", 3, 5);
    private static final TField QUOTE_CHAR_FIELD_DESC = new TField("quoteChar", 3, 6);
    private static final TField FILE_FORMAT_FIELD_DESC = new TField("fileFormat", 8, 7);
    private static final TField BLOCK_SIZE_FIELD_DESC = new TField("blockSize", 8, 8);
    private static final TField JSON_BINARY_FORMAT_FIELD_DESC = new TField("jsonBinaryFormat", 8, 9);
    private static final TField ENCODING_VALUE_FIELD_DESC = new TField("encodingValue", 11, 10);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new THdfsStorageDescriptorStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new THdfsStorageDescriptorTupleSchemeFactory();
    public byte lineDelim;
    public byte fieldDelim;
    public byte collectionDelim;
    public byte mapKeyDelim;
    public byte escapeChar;
    public byte quoteChar;
    @Nullable
    public THdfsFileFormat fileFormat;
    public int blockSize;
    @Nullable
    public TJsonBinaryFormat jsonBinaryFormat;
    @Nullable
    public String encodingValue;
    private static final int __LINEDELIM_ISSET_ID = 0;
    private static final int __FIELDDELIM_ISSET_ID = 1;
    private static final int __COLLECTIONDELIM_ISSET_ID = 2;
    private static final int __MAPKEYDELIM_ISSET_ID = 3;
    private static final int __ESCAPECHAR_ISSET_ID = 4;
    private static final int __QUOTECHAR_ISSET_ID = 5;
    private static final int __BLOCKSIZE_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.JSON_BINARY_FORMAT, _Fields.ENCODING_VALUE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public THdfsStorageDescriptor() {
    }

    public THdfsStorageDescriptor(byte lineDelim, byte fieldDelim, byte collectionDelim, byte mapKeyDelim, byte escapeChar, byte quoteChar, THdfsFileFormat fileFormat, int blockSize) {
        this();
        this.lineDelim = lineDelim;
        this.setLineDelimIsSet(true);
        this.fieldDelim = fieldDelim;
        this.setFieldDelimIsSet(true);
        this.collectionDelim = collectionDelim;
        this.setCollectionDelimIsSet(true);
        this.mapKeyDelim = mapKeyDelim;
        this.setMapKeyDelimIsSet(true);
        this.escapeChar = escapeChar;
        this.setEscapeCharIsSet(true);
        this.quoteChar = quoteChar;
        this.setQuoteCharIsSet(true);
        this.fileFormat = fileFormat;
        this.blockSize = blockSize;
        this.setBlockSizeIsSet(true);
    }

    public THdfsStorageDescriptor(THdfsStorageDescriptor other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.lineDelim = other.lineDelim;
        this.fieldDelim = other.fieldDelim;
        this.collectionDelim = other.collectionDelim;
        this.mapKeyDelim = other.mapKeyDelim;
        this.escapeChar = other.escapeChar;
        this.quoteChar = other.quoteChar;
        if (other.isSetFileFormat()) {
            this.fileFormat = other.fileFormat;
        }
        this.blockSize = other.blockSize;
        if (other.isSetJsonBinaryFormat()) {
            this.jsonBinaryFormat = other.jsonBinaryFormat;
        }
        if (other.isSetEncodingValue()) {
            this.encodingValue = other.encodingValue;
        }
    }

    public THdfsStorageDescriptor deepCopy() {
        return new THdfsStorageDescriptor(this);
    }

    public void clear() {
        this.setLineDelimIsSet(false);
        this.lineDelim = 0;
        this.setFieldDelimIsSet(false);
        this.fieldDelim = 0;
        this.setCollectionDelimIsSet(false);
        this.collectionDelim = 0;
        this.setMapKeyDelimIsSet(false);
        this.mapKeyDelim = 0;
        this.setEscapeCharIsSet(false);
        this.escapeChar = 0;
        this.setQuoteCharIsSet(false);
        this.quoteChar = 0;
        this.fileFormat = null;
        this.setBlockSizeIsSet(false);
        this.blockSize = 0;
        this.jsonBinaryFormat = null;
        this.encodingValue = null;
    }

    public byte getLineDelim() {
        return this.lineDelim;
    }

    public THdfsStorageDescriptor setLineDelim(byte lineDelim) {
        this.lineDelim = lineDelim;
        this.setLineDelimIsSet(true);
        return this;
    }

    public void unsetLineDelim() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetLineDelim() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setLineDelimIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte getFieldDelim() {
        return this.fieldDelim;
    }

    public THdfsStorageDescriptor setFieldDelim(byte fieldDelim) {
        this.fieldDelim = fieldDelim;
        this.setFieldDelimIsSet(true);
        return this;
    }

    public void unsetFieldDelim() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetFieldDelim() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setFieldDelimIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public byte getCollectionDelim() {
        return this.collectionDelim;
    }

    public THdfsStorageDescriptor setCollectionDelim(byte collectionDelim) {
        this.collectionDelim = collectionDelim;
        this.setCollectionDelimIsSet(true);
        return this;
    }

    public void unsetCollectionDelim() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetCollectionDelim() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setCollectionDelimIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public byte getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public THdfsStorageDescriptor setMapKeyDelim(byte mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
        this.setMapKeyDelimIsSet(true);
        return this;
    }

    public void unsetMapKeyDelim() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetMapKeyDelim() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setMapKeyDelimIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }

    public THdfsStorageDescriptor setEscapeChar(byte escapeChar) {
        this.escapeChar = escapeChar;
        this.setEscapeCharIsSet(true);
        return this;
    }

    public void unsetEscapeChar() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetEscapeChar() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setEscapeCharIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public byte getQuoteChar() {
        return this.quoteChar;
    }

    public THdfsStorageDescriptor setQuoteChar(byte quoteChar) {
        this.quoteChar = quoteChar;
        this.setQuoteCharIsSet(true);
        return this;
    }

    public void unsetQuoteChar() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetQuoteChar() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setQuoteCharIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    @Nullable
    public THdfsFileFormat getFileFormat() {
        return this.fileFormat;
    }

    public THdfsStorageDescriptor setFileFormat(@Nullable THdfsFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public void unsetFileFormat() {
        this.fileFormat = null;
    }

    public boolean isSetFileFormat() {
        return this.fileFormat != null;
    }

    public void setFileFormatIsSet(boolean value) {
        if (!value) {
            this.fileFormat = null;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public THdfsStorageDescriptor setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        this.setBlockSizeIsSet(true);
        return this;
    }

    public void unsetBlockSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetBlockSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setBlockSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    @Nullable
    public TJsonBinaryFormat getJsonBinaryFormat() {
        return this.jsonBinaryFormat;
    }

    public THdfsStorageDescriptor setJsonBinaryFormat(@Nullable TJsonBinaryFormat jsonBinaryFormat) {
        this.jsonBinaryFormat = jsonBinaryFormat;
        return this;
    }

    public void unsetJsonBinaryFormat() {
        this.jsonBinaryFormat = null;
    }

    public boolean isSetJsonBinaryFormat() {
        return this.jsonBinaryFormat != null;
    }

    public void setJsonBinaryFormatIsSet(boolean value) {
        if (!value) {
            this.jsonBinaryFormat = null;
        }
    }

    @Nullable
    public String getEncodingValue() {
        return this.encodingValue;
    }

    public THdfsStorageDescriptor setEncodingValue(@Nullable String encodingValue) {
        this.encodingValue = encodingValue;
        return this;
    }

    public void unsetEncodingValue() {
        this.encodingValue = null;
    }

    public boolean isSetEncodingValue() {
        return this.encodingValue != null;
    }

    public void setEncodingValueIsSet(boolean value) {
        if (!value) {
            this.encodingValue = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case LINE_DELIM: {
                if (value == null) {
                    this.unsetLineDelim();
                    break;
                }
                this.setLineDelim((Byte)value);
                break;
            }
            case FIELD_DELIM: {
                if (value == null) {
                    this.unsetFieldDelim();
                    break;
                }
                this.setFieldDelim((Byte)value);
                break;
            }
            case COLLECTION_DELIM: {
                if (value == null) {
                    this.unsetCollectionDelim();
                    break;
                }
                this.setCollectionDelim((Byte)value);
                break;
            }
            case MAP_KEY_DELIM: {
                if (value == null) {
                    this.unsetMapKeyDelim();
                    break;
                }
                this.setMapKeyDelim((Byte)value);
                break;
            }
            case ESCAPE_CHAR: {
                if (value == null) {
                    this.unsetEscapeChar();
                    break;
                }
                this.setEscapeChar((Byte)value);
                break;
            }
            case QUOTE_CHAR: {
                if (value == null) {
                    this.unsetQuoteChar();
                    break;
                }
                this.setQuoteChar((Byte)value);
                break;
            }
            case FILE_FORMAT: {
                if (value == null) {
                    this.unsetFileFormat();
                    break;
                }
                this.setFileFormat((THdfsFileFormat)((Object)value));
                break;
            }
            case BLOCK_SIZE: {
                if (value == null) {
                    this.unsetBlockSize();
                    break;
                }
                this.setBlockSize((Integer)value);
                break;
            }
            case JSON_BINARY_FORMAT: {
                if (value == null) {
                    this.unsetJsonBinaryFormat();
                    break;
                }
                this.setJsonBinaryFormat((TJsonBinaryFormat)((Object)value));
                break;
            }
            case ENCODING_VALUE: {
                if (value == null) {
                    this.unsetEncodingValue();
                    break;
                }
                this.setEncodingValue((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case LINE_DELIM: {
                return this.getLineDelim();
            }
            case FIELD_DELIM: {
                return this.getFieldDelim();
            }
            case COLLECTION_DELIM: {
                return this.getCollectionDelim();
            }
            case MAP_KEY_DELIM: {
                return this.getMapKeyDelim();
            }
            case ESCAPE_CHAR: {
                return this.getEscapeChar();
            }
            case QUOTE_CHAR: {
                return this.getQuoteChar();
            }
            case FILE_FORMAT: {
                return this.getFileFormat();
            }
            case BLOCK_SIZE: {
                return this.getBlockSize();
            }
            case JSON_BINARY_FORMAT: {
                return this.getJsonBinaryFormat();
            }
            case ENCODING_VALUE: {
                return this.getEncodingValue();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case LINE_DELIM: {
                return this.isSetLineDelim();
            }
            case FIELD_DELIM: {
                return this.isSetFieldDelim();
            }
            case COLLECTION_DELIM: {
                return this.isSetCollectionDelim();
            }
            case MAP_KEY_DELIM: {
                return this.isSetMapKeyDelim();
            }
            case ESCAPE_CHAR: {
                return this.isSetEscapeChar();
            }
            case QUOTE_CHAR: {
                return this.isSetQuoteChar();
            }
            case FILE_FORMAT: {
                return this.isSetFileFormat();
            }
            case BLOCK_SIZE: {
                return this.isSetBlockSize();
            }
            case JSON_BINARY_FORMAT: {
                return this.isSetJsonBinaryFormat();
            }
            case ENCODING_VALUE: {
                return this.isSetEncodingValue();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof THdfsStorageDescriptor) {
            return this.equals((THdfsStorageDescriptor)that);
        }
        return false;
    }

    public boolean equals(THdfsStorageDescriptor that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_lineDelim = true;
        boolean that_present_lineDelim = true;
        if (this_present_lineDelim || that_present_lineDelim) {
            if (!this_present_lineDelim || !that_present_lineDelim) {
                return false;
            }
            if (this.lineDelim != that.lineDelim) {
                return false;
            }
        }
        boolean this_present_fieldDelim = true;
        boolean that_present_fieldDelim = true;
        if (this_present_fieldDelim || that_present_fieldDelim) {
            if (!this_present_fieldDelim || !that_present_fieldDelim) {
                return false;
            }
            if (this.fieldDelim != that.fieldDelim) {
                return false;
            }
        }
        boolean this_present_collectionDelim = true;
        boolean that_present_collectionDelim = true;
        if (this_present_collectionDelim || that_present_collectionDelim) {
            if (!this_present_collectionDelim || !that_present_collectionDelim) {
                return false;
            }
            if (this.collectionDelim != that.collectionDelim) {
                return false;
            }
        }
        boolean this_present_mapKeyDelim = true;
        boolean that_present_mapKeyDelim = true;
        if (this_present_mapKeyDelim || that_present_mapKeyDelim) {
            if (!this_present_mapKeyDelim || !that_present_mapKeyDelim) {
                return false;
            }
            if (this.mapKeyDelim != that.mapKeyDelim) {
                return false;
            }
        }
        boolean this_present_escapeChar = true;
        boolean that_present_escapeChar = true;
        if (this_present_escapeChar || that_present_escapeChar) {
            if (!this_present_escapeChar || !that_present_escapeChar) {
                return false;
            }
            if (this.escapeChar != that.escapeChar) {
                return false;
            }
        }
        boolean this_present_quoteChar = true;
        boolean that_present_quoteChar = true;
        if (this_present_quoteChar || that_present_quoteChar) {
            if (!this_present_quoteChar || !that_present_quoteChar) {
                return false;
            }
            if (this.quoteChar != that.quoteChar) {
                return false;
            }
        }
        boolean this_present_fileFormat = this.isSetFileFormat();
        boolean that_present_fileFormat = that.isSetFileFormat();
        if (this_present_fileFormat || that_present_fileFormat) {
            if (!this_present_fileFormat || !that_present_fileFormat) {
                return false;
            }
            if (!this.fileFormat.equals((Object)that.fileFormat)) {
                return false;
            }
        }
        boolean this_present_blockSize = true;
        boolean that_present_blockSize = true;
        if (this_present_blockSize || that_present_blockSize) {
            if (!this_present_blockSize || !that_present_blockSize) {
                return false;
            }
            if (this.blockSize != that.blockSize) {
                return false;
            }
        }
        boolean this_present_jsonBinaryFormat = this.isSetJsonBinaryFormat();
        boolean that_present_jsonBinaryFormat = that.isSetJsonBinaryFormat();
        if (this_present_jsonBinaryFormat || that_present_jsonBinaryFormat) {
            if (!this_present_jsonBinaryFormat || !that_present_jsonBinaryFormat) {
                return false;
            }
            if (!this.jsonBinaryFormat.equals((Object)that.jsonBinaryFormat)) {
                return false;
            }
        }
        boolean this_present_encodingValue = this.isSetEncodingValue();
        boolean that_present_encodingValue = that.isSetEncodingValue();
        if (this_present_encodingValue || that_present_encodingValue) {
            if (!this_present_encodingValue || !that_present_encodingValue) {
                return false;
            }
            if (!this.encodingValue.equals(that.encodingValue)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.lineDelim;
        hashCode = hashCode * 8191 + this.fieldDelim;
        hashCode = hashCode * 8191 + this.collectionDelim;
        hashCode = hashCode * 8191 + this.mapKeyDelim;
        hashCode = hashCode * 8191 + this.escapeChar;
        hashCode = hashCode * 8191 + this.quoteChar;
        hashCode = hashCode * 8191 + (this.isSetFileFormat() ? 131071 : 524287);
        if (this.isSetFileFormat()) {
            hashCode = hashCode * 8191 + this.fileFormat.getValue();
        }
        hashCode = hashCode * 8191 + this.blockSize;
        hashCode = hashCode * 8191 + (this.isSetJsonBinaryFormat() ? 131071 : 524287);
        if (this.isSetJsonBinaryFormat()) {
            hashCode = hashCode * 8191 + this.jsonBinaryFormat.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetEncodingValue() ? 131071 : 524287);
        if (this.isSetEncodingValue()) {
            hashCode = hashCode * 8191 + this.encodingValue.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(THdfsStorageDescriptor other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetLineDelim(), other.isSetLineDelim());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLineDelim() && (lastComparison = TBaseHelper.compareTo((byte)this.lineDelim, (byte)other.lineDelim)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFieldDelim(), other.isSetFieldDelim());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFieldDelim() && (lastComparison = TBaseHelper.compareTo((byte)this.fieldDelim, (byte)other.fieldDelim)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCollectionDelim(), other.isSetCollectionDelim());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCollectionDelim() && (lastComparison = TBaseHelper.compareTo((byte)this.collectionDelim, (byte)other.collectionDelim)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMapKeyDelim(), other.isSetMapKeyDelim());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMapKeyDelim() && (lastComparison = TBaseHelper.compareTo((byte)this.mapKeyDelim, (byte)other.mapKeyDelim)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEscapeChar(), other.isSetEscapeChar());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEscapeChar() && (lastComparison = TBaseHelper.compareTo((byte)this.escapeChar, (byte)other.escapeChar)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQuoteChar(), other.isSetQuoteChar());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQuoteChar() && (lastComparison = TBaseHelper.compareTo((byte)this.quoteChar, (byte)other.quoteChar)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFileFormat(), other.isSetFileFormat());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileFormat() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.fileFormat), (Comparable)((Object)other.fileFormat))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBlockSize(), other.isSetBlockSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlockSize() && (lastComparison = TBaseHelper.compareTo((int)this.blockSize, (int)other.blockSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetJsonBinaryFormat(), other.isSetJsonBinaryFormat());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJsonBinaryFormat() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.jsonBinaryFormat), (Comparable)((Object)other.jsonBinaryFormat))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEncodingValue(), other.isSetEncodingValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncodingValue() && (lastComparison = TBaseHelper.compareTo((String)this.encodingValue, (String)other.encodingValue)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        THdfsStorageDescriptor.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        THdfsStorageDescriptor.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("THdfsStorageDescriptor(");
        boolean first = true;
        sb.append("lineDelim:");
        sb.append(this.lineDelim);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("fieldDelim:");
        sb.append(this.fieldDelim);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("collectionDelim:");
        sb.append(this.collectionDelim);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("mapKeyDelim:");
        sb.append(this.mapKeyDelim);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("escapeChar:");
        sb.append(this.escapeChar);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("quoteChar:");
        sb.append(this.quoteChar);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("fileFormat:");
        if (this.fileFormat == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.fileFormat);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("blockSize:");
        sb.append(this.blockSize);
        first = false;
        if (this.isSetJsonBinaryFormat()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("jsonBinaryFormat:");
            if (this.jsonBinaryFormat == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.jsonBinaryFormat);
            }
            first = false;
        }
        if (this.isSetEncodingValue()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encodingValue:");
            if (this.encodingValue == null) {
                sb.append("null");
            } else {
                sb.append(this.encodingValue);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.fileFormat == null) {
            throw new TProtocolException("Required field 'fileFormat' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.LINE_DELIM, new FieldMetaData("lineDelim", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.FIELD_DELIM, new FieldMetaData("fieldDelim", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.COLLECTION_DELIM, new FieldMetaData("collectionDelim", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.MAP_KEY_DELIM, new FieldMetaData("mapKeyDelim", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.ESCAPE_CHAR, new FieldMetaData("escapeChar", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.QUOTE_CHAR, new FieldMetaData("quoteChar", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.FILE_FORMAT, new FieldMetaData("fileFormat", 1, (FieldValueMetaData)new EnumMetaData(16, THdfsFileFormat.class)));
        tmpMap.put(_Fields.BLOCK_SIZE, new FieldMetaData("blockSize", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.JSON_BINARY_FORMAT, new FieldMetaData("jsonBinaryFormat", 2, (FieldValueMetaData)new EnumMetaData(16, TJsonBinaryFormat.class)));
        tmpMap.put(_Fields.ENCODING_VALUE, new FieldMetaData("encodingValue", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(THdfsStorageDescriptor.class, metaDataMap);
    }

    private static class THdfsStorageDescriptorTupleScheme
    extends TupleScheme<THdfsStorageDescriptor> {
        private THdfsStorageDescriptorTupleScheme() {
        }

        public void write(TProtocol prot, THdfsStorageDescriptor struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeByte(struct.lineDelim);
            oprot.writeByte(struct.fieldDelim);
            oprot.writeByte(struct.collectionDelim);
            oprot.writeByte(struct.mapKeyDelim);
            oprot.writeByte(struct.escapeChar);
            oprot.writeByte(struct.quoteChar);
            oprot.writeI32(struct.fileFormat.getValue());
            oprot.writeI32(struct.blockSize);
            BitSet optionals = new BitSet();
            if (struct.isSetJsonBinaryFormat()) {
                optionals.set(0);
            }
            if (struct.isSetEncodingValue()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetJsonBinaryFormat()) {
                oprot.writeI32(struct.jsonBinaryFormat.getValue());
            }
            if (struct.isSetEncodingValue()) {
                oprot.writeString(struct.encodingValue);
            }
        }

        public void read(TProtocol prot, THdfsStorageDescriptor struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.lineDelim = iprot.readByte();
            struct.setLineDelimIsSet(true);
            struct.fieldDelim = iprot.readByte();
            struct.setFieldDelimIsSet(true);
            struct.collectionDelim = iprot.readByte();
            struct.setCollectionDelimIsSet(true);
            struct.mapKeyDelim = iprot.readByte();
            struct.setMapKeyDelimIsSet(true);
            struct.escapeChar = iprot.readByte();
            struct.setEscapeCharIsSet(true);
            struct.quoteChar = iprot.readByte();
            struct.setQuoteCharIsSet(true);
            struct.fileFormat = THdfsFileFormat.findByValue(iprot.readI32());
            struct.setFileFormatIsSet(true);
            struct.blockSize = iprot.readI32();
            struct.setBlockSizeIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.jsonBinaryFormat = TJsonBinaryFormat.findByValue(iprot.readI32());
                struct.setJsonBinaryFormatIsSet(true);
            }
            if (incoming.get(1)) {
                struct.encodingValue = iprot.readString();
                struct.setEncodingValueIsSet(true);
            }
        }
    }

    private static class THdfsStorageDescriptorTupleSchemeFactory
    implements SchemeFactory {
        private THdfsStorageDescriptorTupleSchemeFactory() {
        }

        public THdfsStorageDescriptorTupleScheme getScheme() {
            return new THdfsStorageDescriptorTupleScheme();
        }
    }

    private static class THdfsStorageDescriptorStandardScheme
    extends StandardScheme<THdfsStorageDescriptor> {
        private THdfsStorageDescriptorStandardScheme() {
        }

        public void read(TProtocol iprot, THdfsStorageDescriptor struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 3) {
                            struct.lineDelim = iprot.readByte();
                            struct.setLineDelimIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 3) {
                            struct.fieldDelim = iprot.readByte();
                            struct.setFieldDelimIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 3) {
                            struct.collectionDelim = iprot.readByte();
                            struct.setCollectionDelimIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 3) {
                            struct.mapKeyDelim = iprot.readByte();
                            struct.setMapKeyDelimIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 3) {
                            struct.escapeChar = iprot.readByte();
                            struct.setEscapeCharIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 3) {
                            struct.quoteChar = iprot.readByte();
                            struct.setQuoteCharIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.fileFormat = THdfsFileFormat.findByValue(iprot.readI32());
                            struct.setFileFormatIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.blockSize = iprot.readI32();
                            struct.setBlockSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.jsonBinaryFormat = TJsonBinaryFormat.findByValue(iprot.readI32());
                            struct.setJsonBinaryFormatIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.encodingValue = iprot.readString();
                            struct.setEncodingValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetLineDelim()) {
                throw new TProtocolException("Required field 'lineDelim' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetFieldDelim()) {
                throw new TProtocolException("Required field 'fieldDelim' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetCollectionDelim()) {
                throw new TProtocolException("Required field 'collectionDelim' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetMapKeyDelim()) {
                throw new TProtocolException("Required field 'mapKeyDelim' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetEscapeChar()) {
                throw new TProtocolException("Required field 'escapeChar' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetQuoteChar()) {
                throw new TProtocolException("Required field 'quoteChar' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetBlockSize()) {
                throw new TProtocolException("Required field 'blockSize' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, THdfsStorageDescriptor struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(LINE_DELIM_FIELD_DESC);
            oprot.writeByte(struct.lineDelim);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(FIELD_DELIM_FIELD_DESC);
            oprot.writeByte(struct.fieldDelim);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(COLLECTION_DELIM_FIELD_DESC);
            oprot.writeByte(struct.collectionDelim);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAP_KEY_DELIM_FIELD_DESC);
            oprot.writeByte(struct.mapKeyDelim);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(ESCAPE_CHAR_FIELD_DESC);
            oprot.writeByte(struct.escapeChar);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(QUOTE_CHAR_FIELD_DESC);
            oprot.writeByte(struct.quoteChar);
            oprot.writeFieldEnd();
            if (struct.fileFormat != null) {
                oprot.writeFieldBegin(FILE_FORMAT_FIELD_DESC);
                oprot.writeI32(struct.fileFormat.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(BLOCK_SIZE_FIELD_DESC);
            oprot.writeI32(struct.blockSize);
            oprot.writeFieldEnd();
            if (struct.jsonBinaryFormat != null && struct.isSetJsonBinaryFormat()) {
                oprot.writeFieldBegin(JSON_BINARY_FORMAT_FIELD_DESC);
                oprot.writeI32(struct.jsonBinaryFormat.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.encodingValue != null && struct.isSetEncodingValue()) {
                oprot.writeFieldBegin(ENCODING_VALUE_FIELD_DESC);
                oprot.writeString(struct.encodingValue);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class THdfsStorageDescriptorStandardSchemeFactory
    implements SchemeFactory {
        private THdfsStorageDescriptorStandardSchemeFactory() {
        }

        public THdfsStorageDescriptorStandardScheme getScheme() {
            return new THdfsStorageDescriptorStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        LINE_DELIM(1, "lineDelim"),
        FIELD_DELIM(2, "fieldDelim"),
        COLLECTION_DELIM(3, "collectionDelim"),
        MAP_KEY_DELIM(4, "mapKeyDelim"),
        ESCAPE_CHAR(5, "escapeChar"),
        QUOTE_CHAR(6, "quoteChar"),
        FILE_FORMAT(7, "fileFormat"),
        BLOCK_SIZE(8, "blockSize"),
        JSON_BINARY_FORMAT(9, "jsonBinaryFormat"),
        ENCODING_VALUE(10, "encodingValue");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return LINE_DELIM;
                }
                case 2: {
                    return FIELD_DELIM;
                }
                case 3: {
                    return COLLECTION_DELIM;
                }
                case 4: {
                    return MAP_KEY_DELIM;
                }
                case 5: {
                    return ESCAPE_CHAR;
                }
                case 6: {
                    return QUOTE_CHAR;
                }
                case 7: {
                    return FILE_FORMAT;
                }
                case 8: {
                    return BLOCK_SIZE;
                }
                case 9: {
                    return JSON_BINARY_FORMAT;
                }
                case 10: {
                    return ENCODING_VALUE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

