/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service.catalogmanager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.IcebergMetaProvider;
import org.apache.impala.catalog.local.LocalCatalog;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.catalog.local.MultiMetaProvider;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.catalogmanager.ConfigLoader;
import org.apache.impala.service.catalogmanager.FeCatalogManager;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalImpl
extends FeCatalogManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalImpl.class);
    private final MetaProvider provider_ = this.getMetaProvider();

    private MetaProvider getMetaProvider() throws ImpalaRuntimeException {
        TBackendGflags backendCfg = BackendConfig.INSTANCE.getBackendCfg();
        String catalogConfigDir = backendCfg.catalog_config_dir;
        ArrayList<MetaProvider> providers = new ArrayList<MetaProvider>();
        if (backendCfg.catalogd_deployed) {
            providers.add(new CatalogdMetaProvider(backendCfg));
        }
        if (catalogConfigDir != null && !catalogConfigDir.isEmpty()) {
            File configDir = new File(catalogConfigDir);
            try {
                LOG.info("Loading catalog config from {}", (Object)configDir);
                List<MetaProvider> secondaryProviders = LocalImpl.getSecondaryProviders(configDir);
                providers.addAll(secondaryProviders);
            }
            catch (ImpalaRuntimeException e) {
                LOG.warn("Unable to load secondary providers from catalog config file", (Throwable)e);
            }
        }
        if (providers.isEmpty()) {
            throw new ImpalaRuntimeException("No metadata providers available");
        }
        if (providers.size() == 1) {
            return (MetaProvider)providers.get(0);
        }
        return new MultiMetaProvider((MetaProvider)providers.get(0), providers.subList(1, providers.size()));
    }

    @Override
    public FeCatalog getOrCreateCatalog() {
        if (this.provider_ instanceof CatalogdMetaProvider) {
            ((CatalogdMetaProvider)this.provider_).setAuthzChecker(this.authzChecker_);
        }
        return new LocalCatalog(this.provider_);
    }

    @Override
    public TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) {
        MetaProvider primaryProvider;
        if (this.provider_ instanceof CatalogdMetaProvider) {
            return ((CatalogdMetaProvider)this.provider_).updateCatalogCache(req);
        }
        if (this.provider_ instanceof MultiMetaProvider && (primaryProvider = ((MultiMetaProvider)this.provider_).getPrimaryProvider()) instanceof CatalogdMetaProvider) {
            return ((CatalogdMetaProvider)primaryProvider).updateCatalogCache(req);
        }
        return null;
    }

    private static List<MetaProvider> getSecondaryProviders(File catalogConfigDir) throws ImpalaRuntimeException {
        ConfigLoader loader = new ConfigLoader(catalogConfigDir);
        ArrayList<MetaProvider> list = new ArrayList<MetaProvider>();
        for (Properties properties : loader.loadConfigs()) {
            try {
                IcebergMetaProvider icebergMetaProvider = new IcebergMetaProvider(properties);
                list.add(icebergMetaProvider);
            }
            catch (RESTException e) {
                LOG.error(String.format("Unable to instantiate IcebergMetaProvider from the following properties: %s", properties), (Throwable)e);
            }
        }
        return list;
    }
}

