/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service.catalogmanager;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.catalogmanager.CatalogdImpl;
import org.apache.impala.service.catalogmanager.LocalImpl;
import org.apache.impala.service.catalogmanager.TestImpl;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.thrift.TException;

public abstract class FeCatalogManager {
    protected AtomicReference<? extends AuthorizationChecker> authzChecker_;

    public static FeCatalogManager createFromBackendConfig() throws ImpalaRuntimeException {
        TBackendGflags cfg = BackendConfig.INSTANCE.getBackendCfg();
        if (cfg.use_local_catalog) {
            return new LocalImpl();
        }
        return new CatalogdImpl();
    }

    public static FeCatalogManager createForTests(FeCatalog testCatalog) {
        return new TestImpl(testCatalog);
    }

    public void setAuthzChecker(AtomicReference<? extends AuthorizationChecker> authzChecker) {
        this.authzChecker_ = (AtomicReference)Preconditions.checkNotNull(authzChecker);
    }

    public abstract FeCatalog getOrCreateCatalog();

    public abstract TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest var1) throws CatalogException, TException;
}

