/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service.catalogmanager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.impala.common.ImpalaRuntimeException;

public class ConfigLoader {
    private final File configFolder_;

    public ConfigLoader(File configFolder) {
        this.configFolder_ = configFolder;
    }

    public List<Properties> loadConfigs() throws ImpalaRuntimeException {
        List<File> files = this.listFiles(this.configFolder_);
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        for (File configFile : files) {
            String fileName = configFile.getName();
            try {
                Properties props = this.readPropertiesFile(configFile);
                this.checkPropertyValue(fileName, props, "connector.name", "iceberg");
                this.checkPropertyValue(fileName, props, "iceberg.catalog.type", "rest");
                propertiesList.add(props);
            }
            catch (IOException e) {
                throw new ImpalaRuntimeException(String.format("Unable to read file %s from configuration directory: %s", fileName, this.configFolder_.getAbsolutePath()), e);
            }
        }
        return propertiesList;
    }

    List<File> listFiles(File configDirectory) {
        Preconditions.checkState((configDirectory.exists() && configDirectory.isDirectory() ? 1 : 0) != 0);
        return Stream.of(configDirectory.listFiles()).filter(file -> !file.isDirectory()).collect(Collectors.toList());
    }

    Properties readPropertiesFile(File file) throws IOException {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            props.load(in);
        }
        return props;
    }

    private void checkPropertyValue(String configFile, Properties props, String key, String expectedValue) {
        if (!props.containsKey(key)) {
            throw new IllegalStateException(String.format("Expected property %s was not specified in config file %s.", key, configFile));
        }
        String actualValue = props.getProperty(key);
        if (!Objects.equals(actualValue, expectedValue)) {
            throw new IllegalStateException(String.format("Expected value of '%s' is '%s', but found '%s' in config file %s", key, expectedValue, actualValue, configFile));
        }
    }
}

