/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service.catalogmanager;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.ImpaladCatalog;
import org.apache.impala.service.catalogmanager.FeCatalogManager;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.thrift.TException;

class CatalogdImpl
extends FeCatalogManager {
    private final AtomicReference<ImpaladCatalog> catalog_ = new AtomicReference();

    CatalogdImpl() {
        this.catalog_.set(this.createNewCatalog());
    }

    @Override
    public FeCatalog getOrCreateCatalog() {
        return this.catalog_.get();
    }

    @Override
    public TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) throws CatalogException, TException {
        ImpaladCatalog catalog = this.catalog_.get();
        if (req.is_delta) {
            return catalog.updateCatalog(req);
        }
        ImpaladCatalog oldCatalog = catalog;
        catalog = this.createNewCatalog();
        TUpdateCatalogCacheResponse response = catalog.updateCatalog(req);
        this.catalog_.set(catalog);
        if (oldCatalog != null) {
            oldCatalog.release();
        }
        return response;
    }

    private ImpaladCatalog createNewCatalog() {
        return new ImpaladCatalog(this.authzChecker_);
    }
}

